/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edi.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.milyn.edisax.model.internal.Delimiters;

public class MessageBuilder {
    private String packageScope;
    private String delimiterForEscaping;
    private Delimiters delimiters;

    public MessageBuilder(String packageScope, String delimiterForEscaping, Delimiters delimiters) {
        this.packageScope = packageScope;
        this.delimiterForEscaping = delimiterForEscaping;
        this.delimiters = delimiters;
    }

    public Delimiters getDelimiters() {
        return this.delimiters;
    }

    public <T> T buildMessage(Class<T> messageType) {
        try {
            return this.buildObject(messageType, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to construct an instance of '" + messageType.getName() + "'", e);
        }
    }

    private <T> T buildObject(Class<T> objectType, String name) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Method[] methods;
        if (objectType == Delimiters.class) {
            return objectType.cast(this.delimiters);
        }
        if (String.class.isAssignableFrom(objectType)) {
            return objectType.cast(name + this.delimiterForEscaping + name);
        }
        if (Number.class.isAssignableFrom(objectType)) {
            return objectType.getConstructor(String.class).newInstance("1.1");
        }
        if (Integer.TYPE.isAssignableFrom(objectType)) {
            return (T)new Integer(1);
        }
        if (objectType == Object.class) {
            return null;
        }
        if (!objectType.getPackage().getName().startsWith(this.packageScope)) {
            throw new InstantiationException("Cannot create instance of type '" + objectType.getName() + "'.  Not inside the scope of package '" + this.packageScope + "'");
        }
        T messageInstance = objectType.newInstance();
        for (Method method : methods = objectType.getMethods()) {
            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            Class<?> propertyType = method.getParameterTypes()[0];
            ArrayList<T> propertyInstance = null;
            if (List.class.isAssignableFrom(propertyType)) {
                Type genericType = method.getGenericParameterTypes()[0];
                if (genericType instanceof ParameterizedType) {
                    ArrayList<T> list = new ArrayList<T>();
                    ParameterizedType genericTypeClass = (ParameterizedType)genericType;
                    list.add(this.buildObject((Class)genericTypeClass.getActualTypeArguments()[0], method.getName().substring(3)));
                    propertyInstance = list;
                }
            } else {
                propertyInstance = (ArrayList<T>)this.buildObject(propertyType, method.getName().substring(3));
            }
            if (propertyInstance == null) continue;
            method.invoke(messageInstance, propertyInstance);
        }
        return messageInstance;
    }
}

