/*
 * Milyn - Copyright (C) 2006 - 2010
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License (version 2.1) as published by the Free Software
 * Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU Lesser General Public License for more details:
 * http://www.gnu.org/licenses/lgpl.txt
 */

package org.milyn.smooks.edi.unedifact.model;

import org.xml.sax.InputSource;

import javax.xml.transform.Result;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

/**
 * UN/EDIFACT interchange factory.
 * 
 * @author <a href="mailto:tom.fennelly@gmail.com">tom.fennelly@gmail.com</a>
 */
public interface UNEdifactInterchangeFactory {

    /**
     * Create a {@link UNEdifactInterchange} from the supplied UN/EDIFACT EDI Stream.
     * @param ediStream The UN/EDIFACT interchange data stream.
     * @param additionalResults Additional results e.g. supply a {@link javax.xml.transform.stream.StreamResult}
     * to capture the serialized XML event stream generated by the UNEdifact reader.
     * @return The interchange object graph.
     * @throws IOException Error reading interchange data stream.
     */
    UNEdifactInterchange fromUNEdifact(InputStream ediStream, Result... additionalResults) throws IOException;

    /**
     * Create a {@link UNEdifactInterchange} from the supplied UN/EDIFACT EDI Stream.
     * @param ediSource The UN/EDIFACT interchange data stream.
     * @param additionalResults Additional results e.g. supply a {@link javax.xml.transform.stream.StreamResult}
     * to capture the serialized XML event stream generated by the UNEdifact reader.
     * @return The interchange object graph.
     * @throws IOException Error reading interchange data stream.
     */
    UNEdifactInterchange fromUNEdifact(InputSource ediSource, Result... additionalResults) throws IOException;

    /**
     * Serialized the supplied {@link UNEdifactInterchange} to a UN/EDIFACT EDI Stream.
     * @param interchange The interchange instance to be serialized.
     * @param writer The output writer.
     * @throws IOException Exception writing interchange.
     */
    void toUNEdifact(UNEdifactInterchange interchange, Writer writer) throws IOException;

    /**
     * Set the Execution Report output path.
     *
     * Only use for debug purposes.  <b>Do not use in production!!</b>
     *
     * @param reportPath Execution Report output path.
     */
    void setReportPath(String reportPath);
}
