/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.milyn.assertion.AssertArgument;
import org.milyn.ejc.BindingConfig;
import org.milyn.ejc.ClassModel;
import org.milyn.util.FreeMarkerTemplate;

public class BindingWriter {
    private ClassModel classModel;
    private FreeMarkerTemplate template = new FreeMarkerTemplate("templates/bindingConfig.ftl.xml", BindingWriter.class);

    public BindingWriter(ClassModel classModel) throws ClassNotFoundException {
        AssertArgument.isNotNull((Object)classModel, (String)"classModel");
        this.classModel = classModel;
    }

    public void generate(String bindingfile) throws IOException {
        try (OutputStreamWriter writer = null;){
            writer = new OutputStreamWriter(new FileOutputStream(bindingfile));
            this.writeBindingConfig(writer);
        }
    }

    public static void writeBindingConfig(ClassModel classModel, Writer writer) throws IOException, ClassNotFoundException {
        new BindingWriter(classModel).writeBindingConfig(writer);
        writer.flush();
    }

    public void writeBindingConfig(Writer writer) throws IOException {
        HashMap<String, Object> templatingContextObject = new HashMap<String, Object>();
        ArrayList<BindingConfig> beanConfigs = new ArrayList<BindingConfig>();
        this.flattenBeanConfigGraph(beanConfigs, this.classModel.getRootBeanConfig());
        templatingContextObject.put("beanConfigs", beanConfigs);
        templatingContextObject.put("classPackage", this.classModel.getRootBeanConfig().getBeanClass().getPackageName().replace('.', '/'));
        writer.write(this.template.apply(templatingContextObject));
    }

    private void flattenBeanConfigGraph(List<BindingConfig> beanConfigs, BindingConfig beanConfig) {
        beanConfigs.add(beanConfig);
        for (BindingConfig wiredConfig : beanConfig.getWireBindings()) {
            this.flattenBeanConfigGraph(beanConfigs, wiredConfig);
        }
    }

    private List<String> parsePackages(String packagesString) {
        String[] packages = packagesString.split(";");
        ArrayList<String> packagesSet = new ArrayList<String>();
        for (String aPackage : packages) {
            packagesSet.add(aPackage.trim());
        }
        return packagesSet;
    }
}

