/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.DelimiterType;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.MappingNode;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;
import org.milyn.edisax.model.internal.SubComponent;
import org.milyn.edisax.model.internal.ValueNode;
import org.milyn.edisax.util.EDIUtils;
import org.milyn.edisax.util.IllegalNameException;
import org.milyn.ejc.BindingConfig;
import org.milyn.ejc.ClassModel;
import org.milyn.ejc.EJCException;
import org.milyn.ejc.EJCLogFactory;
import org.milyn.ejc.ValueNodeInfo;
import org.milyn.ejc.WriteMethod;
import org.milyn.javabean.pojogen.JClass;
import org.milyn.javabean.pojogen.JMethod;
import org.milyn.javabean.pojogen.JNamedType;
import org.milyn.javabean.pojogen.JType;
import org.milyn.smooks.edi.EDIMessage;

public class ClassModelCompiler {
    private static Log LOG = EJCLogFactory.getLog(ClassModelCompiler.class);
    private Map<MappingNode, JClass> injectedCommonTypes = new HashMap<MappingNode, JClass>();
    private Map<MappingNode, JClass> createdClassesByNode = new HashMap<MappingNode, JClass>();
    private ClassModel model;
    private Stack<String> nodeStack = new Stack();
    private boolean addEDIMessageAnnotation;

    public ClassModelCompiler(Map<MappingNode, JClass> commonTypes, boolean addEDIMessageAnnotation) {
        if (commonTypes != null) {
            this.injectedCommonTypes.putAll(commonTypes);
        }
        this.addEDIMessageAnnotation = addEDIMessageAnnotation;
    }

    public ClassModel compile(Edimap edimap, String classPackage) throws IllegalNameException {
        this.model = new ClassModel();
        this.model.setEdimap(edimap);
        SegmentGroup segmentGroup = edimap.getSegments();
        this.pushNode((MappingNode)segmentGroup);
        JClass rootClass = new JClass(classPackage, EDIUtils.encodeClassName((String)segmentGroup.getJavaName()), this.getCurrentClassId()).setSerializable();
        BindingConfig rootBeanConfig = new BindingConfig(this.getCurrentClassId(), this.getCurrentNodePath(), rootClass, null, null);
        this.model.addCreatedClass(rootClass);
        this.model.setRootBeanConfig(rootBeanConfig);
        LOG.debug((Object)("Added root class [" + rootClass + "] to ClassModel."));
        this.addWriteMethod(rootBeanConfig);
        this.processSegmentGroups(segmentGroup.getSegments(), rootBeanConfig);
        LOG.debug((Object)"Finished parsing edi-configuration. All segments are added to ClassModel.");
        LOG.debug((Object)("ClassModel contains " + this.model.getCreatedClasses().size() + " classes."));
        this.model.setClassesByNode(this.createdClassesByNode);
        this.model.setReferencedClasses(this.injectedCommonTypes.values());
        this.popNode();
        if (this.addEDIMessageAnnotation) {
            this.model.getRootBeanConfig().getBeanClass().getAnnotationTypes().add(new JType(EDIMessage.class));
        }
        return this.model;
    }

    private void processSegmentGroups(List<SegmentGroup> segmentGroups, BindingConfig parentBinding) throws IllegalNameException {
        WriteMethod writeMethod = null;
        for (SegmentGroup segmentGroup : segmentGroups) {
            BindingConfig childBeanConfig = this.processSegmentGroup(segmentGroup, parentBinding);
            writeMethod = parentBinding.getWriteMethod();
            if (writeMethod != null) {
                if (ClassModelCompiler.isCollection(childBeanConfig.getPropertyOnParent())) {
                    writeMethod.writeSegmentCollection(childBeanConfig.getPropertyOnParent(), segmentGroup);
                } else {
                    writeMethod.writeObject(childBeanConfig.getPropertyOnParent(), parentBinding, (MappingNode)segmentGroup);
                }
            }
            if (ClassModelCompiler.isCollection(childBeanConfig.getPropertyOnParent())) {
                BindingConfig collectionBinding = new BindingConfig(childBeanConfig.getBeanId() + "_List", parentBinding.getCreateOnElement(), ArrayList.class, parentBinding, childBeanConfig.getPropertyOnParent());
                parentBinding.getWireBindings().add(collectionBinding);
                collectionBinding.getWireBindings().add(childBeanConfig);
                childBeanConfig.setPropertyOnParent(null);
                continue;
            }
            parentBinding.getWireBindings().add(childBeanConfig);
        }
    }

    private BindingConfig processSegmentGroup(SegmentGroup segmentGroup, BindingConfig parent) throws IllegalNameException {
        LOG.debug((Object)("Parsing SegmentGroup " + segmentGroup.getXmltag()));
        if (segmentGroup.getJavaName() == null) {
            throw new EJCException("The <segmentGroup> element can optionally omit the 'xmltag' attribute.  However, this attribute must be present for EJC to work properly.  It is omitted from one of the <segmentGroup> elements in this configuration.");
        }
        this.pushNode((MappingNode)segmentGroup);
        BindingConfig segGroupBinding = this.createChildAndConnectWithParent(parent, (MappingNode)segmentGroup, segmentGroup.getMaxOccurs(), null);
        if (segmentGroup instanceof Segment) {
            Segment segment = (Segment)segmentGroup;
            this.processFields(segment.getFields(), segGroupBinding);
        }
        this.processSegmentGroups(segmentGroup.getSegments(), segGroupBinding);
        this.popNode();
        return segGroupBinding;
    }

    private void processFields(List<Field> fields, BindingConfig parent) throws IllegalNameException {
        for (Field field : fields) {
            LOG.debug((Object)("Parsing field " + field.getXmltag()));
            this.pushNode((MappingNode)field);
            if (field.getComponents() != null && field.getComponents().size() > 0) {
                BindingConfig childBinding = this.createChildAndConnectWithParent(parent, (MappingNode)field, 1, DelimiterType.FIELD);
                parent.getWireBindings().add(childBinding);
                this.processComponents(field.getComponents(), childBinding);
            } else {
                this.createAndAddSimpleType((ValueNode)field, parent, DelimiterType.FIELD);
            }
            this.popNode();
        }
        this.collapseSingleFieldSegmentBinding(parent);
        if (parent.getWriteMethod() != null) {
            parent.getWriteMethod().addTerminatingDelimiter(DelimiterType.SEGMENT);
            parent.getWriteMethod().addFlush();
        }
    }

    private void collapseSingleFieldSegmentBinding(BindingConfig parent) {
        if (parent.getValueBindings().isEmpty() && parent.getWireBindings().size() == 1) {
            String childClassName;
            BindingConfig child = parent.getWireBindings().get(0);
            String parentClassName = parent.getBeanClass().getSkeletonClass().getName();
            if (parentClassName.equals(childClassName = child.getBeanClass().getSkeletonClass().getName())) {
                parent.setBeanClass(child.getBeanClass());
                parent.setValueBindings(child.getValueBindings());
                parent.setWireBindings(child.getWireBindings());
            }
        }
    }

    private JNamedType createAndAddSimpleType(ValueNode valueNode, BindingConfig parent, DelimiterType delimiterType) throws IllegalNameException {
        JType jtype = valueNode.getDataType() != null && !valueNode.getDataType().equals("") ? new JType(valueNode.getTypeClass()) : new JType(String.class);
        String propertyName = EDIUtils.encodeAttributeName((JType)jtype, (String)valueNode.getJavaName());
        JNamedType childToParentProperty = new JNamedType(jtype, propertyName);
        JClass parentBeanClass = parent.getBeanClass();
        if (!parentBeanClass.isFinalized() && !parentBeanClass.hasProperty(propertyName) && this.model.isClassCreator(parentBeanClass)) {
            parentBeanClass.addBeanProperty(childToParentProperty);
            this.getWriteMethod(parent).writeValue(childToParentProperty, valueNode, delimiterType);
        }
        parent.getValueBindings().add(new ValueNodeInfo(childToParentProperty, this.getCurrentNodePath(), valueNode));
        return childToParentProperty;
    }

    private void processComponents(List<Component> components, BindingConfig parent) throws IllegalNameException {
        for (Component component : components) {
            this.pushNode((MappingNode)component);
            if (component.getSubComponents() != null && component.getSubComponents().size() > 0) {
                BindingConfig childBeanConfig = this.createChildAndConnectWithParent(parent, (MappingNode)component, 1, DelimiterType.COMPONENT);
                parent.getWireBindings().add(childBeanConfig);
                this.processSubComponents(component.getSubComponents(), childBeanConfig);
            } else {
                this.createAndAddSimpleType((ValueNode)component, parent, DelimiterType.COMPONENT);
            }
            this.popNode();
        }
    }

    private void processSubComponents(List<SubComponent> subComponents, BindingConfig parent) throws IllegalNameException {
        for (SubComponent subComponent : subComponents) {
            this.pushNode((MappingNode)subComponent);
            this.createAndAddSimpleType((ValueNode)subComponent, parent, DelimiterType.SUB_COMPONENT);
            this.popNode();
        }
    }

    private void pushNode(MappingNode node) {
        this.nodeStack.push(node.getXmltag());
    }

    private void popNode() {
        this.nodeStack.pop();
    }

    private BindingConfig createChildAndConnectWithParent(BindingConfig parentBinding, MappingNode mappingNode, int maxOccurs, DelimiterType delimiterType) throws IllegalNameException {
        JClass child = this.getCommonType(mappingNode);
        boolean addClassToModel = false;
        if (child == null) {
            String packageName = parentBinding.getBeanClass().getPackageName();
            String className = EDIUtils.encodeClassName((String)mappingNode.getJavaName());
            if (mappingNode instanceof Field) {
                packageName = packageName + ".field";
            } else if (mappingNode instanceof Component) {
                packageName = packageName + ".component";
            } else if (mappingNode instanceof SubComponent) {
                packageName = packageName + ".subcomponent";
            }
            child = new JClass(packageName, className, this.getCurrentClassId()).setSerializable();
            addClassToModel = true;
            LOG.debug((Object)("Created class " + child.getClassName() + "."));
        }
        JType jtype = maxOccurs > 1 || maxOccurs == -1 ? new JType(List.class, child.getSkeletonClass()) : new JType(child.getSkeletonClass());
        String propertyName = EDIUtils.encodeAttributeName((JType)jtype, (String)mappingNode.getJavaName());
        JNamedType childProperty = new JNamedType(jtype, propertyName);
        BindingConfig childBeanConfig = new BindingConfig(this.getCurrentClassId(), this.getCurrentNodePath(), child, parentBinding, childProperty);
        childBeanConfig.setMappingNode(mappingNode);
        JClass parentBeanClass = parentBinding.getBeanClass();
        if (!parentBeanClass.isFinalized() && !parentBeanClass.hasProperty(propertyName) && this.model.isClassCreator(parentBeanClass)) {
            parentBeanClass.addBeanProperty(childProperty);
            if (delimiterType != null) {
                this.getWriteMethod(parentBinding).writeObject(childProperty, delimiterType, parentBinding, mappingNode);
            }
        }
        if (addClassToModel) {
            this.model.addCreatedClass(child);
            this.createdClassesByNode.put(mappingNode, child);
            childBeanConfig.setWriteMethod(new WriteMethod(child, mappingNode));
        }
        return childBeanConfig;
    }

    private String getCurrentClassId() {
        return this.getCurrentNodePath().replace('/', '.');
    }

    private String getCurrentNodePath() {
        StringBuilder builder = new StringBuilder();
        for (String nodePathElement : this.nodeStack) {
            if (builder.length() > 0) {
                builder.append('/');
            }
            builder.append(nodePathElement);
        }
        return builder.toString();
    }

    private JClass getCommonType(MappingNode mappingNode) {
        String nodeTypeRef = mappingNode.getNodeTypeRef();
        if (nodeTypeRef != null) {
            JClass commonType;
            int colonIndex = nodeTypeRef.indexOf(58);
            if (colonIndex != -1) {
                nodeTypeRef = nodeTypeRef.substring(colonIndex + 1);
            }
            if ((commonType = this.getCommonType(mappingNode, nodeTypeRef, this.createdClassesByNode)) == null) {
                commonType = this.getCommonType(mappingNode, nodeTypeRef, this.injectedCommonTypes);
            }
            return commonType;
        }
        JClass commonType = this.createdClassesByNode.get(mappingNode);
        if (commonType == null) {
            commonType = this.injectedCommonTypes.get(mappingNode);
        }
        return commonType;
    }

    private JClass getCommonType(MappingNode mappingNode, String nodeTypeRef, Map<MappingNode, JClass> typeSet) {
        Set<Map.Entry<MappingNode, JClass>> commonTypes = typeSet.entrySet();
        for (Map.Entry<MappingNode, JClass> typeEntry : commonTypes) {
            MappingNode entryMappingNode = typeEntry.getKey();
            String entryNodeTypeRef = entryMappingNode.getNodeTypeRef();
            if (!(entryMappingNode instanceof Segment ? nodeTypeRef.equals(((Segment)entryMappingNode).getSegcode()) : entryNodeTypeRef != null && entryMappingNode.getClass() == mappingNode.getClass() && nodeTypeRef.equals(entryNodeTypeRef))) continue;
            return typeEntry.getValue();
        }
        return null;
    }

    private WriteMethod getWriteMethod(BindingConfig bindingConfig) {
        for (JMethod method : bindingConfig.getBeanClass().getMethods()) {
            if (!(method instanceof WriteMethod)) continue;
            return (WriteMethod)method;
        }
        JClass beanClass = bindingConfig.getBeanClass();
        WriteMethod writeMethod = new WriteMethod(beanClass, bindingConfig.getMappingNode());
        bindingConfig.setWriteMethod(writeMethod);
        return writeMethod;
    }

    private WriteMethod addWriteMethod(BindingConfig bindingConfig) {
        return this.getWriteMethod(bindingConfig);
    }

    private static boolean isCollection(JNamedType property) {
        return property != null && Collection.class.isAssignableFrom(property.getType().getType());
    }
}

