/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import org.apache.commons.logging.Log;
import org.milyn.ejc.EJCLogFactory;

public class EJCLog
implements Log {
    private EJCLogFactory.Level level;

    public EJCLog(EJCLogFactory.Level level) {
        this.level = level;
    }

    public void setLevel(EJCLogFactory.Level level) {
        this.level = level;
    }

    public void debug(Object object) {
        this.write(EJCLogFactory.Level.DEBUG, object);
    }

    public void debug(Object object, Throwable throwable) {
        this.write(EJCLogFactory.Level.DEBUG, object);
    }

    public void error(Object object) {
        this.write(EJCLogFactory.Level.ERROR, object);
    }

    public void error(Object object, Throwable throwable) {
        this.write(EJCLogFactory.Level.ERROR, object);
    }

    public void fatal(Object object) {
        this.write(EJCLogFactory.Level.FATAL, object);
    }

    public void fatal(Object object, Throwable throwable) {
        this.write(EJCLogFactory.Level.FATAL, object);
    }

    public void info(Object object) {
        this.write(EJCLogFactory.Level.INFO, object);
    }

    public void info(Object object, Throwable throwable) {
        this.write(EJCLogFactory.Level.INFO, object);
    }

    public boolean isDebugEnabled() {
        return this.level == EJCLogFactory.Level.DEBUG;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void trace(Object object) {
    }

    public void trace(Object object, Throwable throwable) {
    }

    public void warn(Object object) {
        this.write(EJCLogFactory.Level.WARN, object);
    }

    public void warn(Object object, Throwable throwable) {
        this.write(EJCLogFactory.Level.WARN, object);
    }

    private void write(EJCLogFactory.Level level, Object object) {
        if (this.level.getValue() > level.getValue()) {
            return;
        }
        System.out.println("[" + (Object)((Object)level) + "] " + object);
    }
}

