@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ackone.kotlin

import com.pulumi.alicloud.ackone.kotlin.outputs.ClusterNetwork
import com.pulumi.alicloud.ackone.kotlin.outputs.ClusterNetwork.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.alicloud.ackone.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Provides a Ack One Cluster resource. Fleet Manager Cluster.
 * For information about Ack One Cluster and how to use it, see [What is Cluster](https://www.alibabacloud.com/help/en/ack/distributed-cloud-container-platform-for-kubernetes/developer-reference/api-adcp-2022-01-01-createhubcluster).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultVpc = new alicloud.vpc.Network("defaultVpc", {
 *     cidrBlock: "172.16.0.0/12",
 *     vpcName: name,
 * });
 * const defaultyVSwitch = new alicloud.vpc.Switch("defaultyVSwitch", {
 *     vpcId: defaultVpc.id,
 *     cidrBlock: "172.16.2.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultCluster = new alicloud.ackone.Cluster("default", {network: {
 *     vpcId: defaultVpc.id,
 *     vswitches: [defaultyVSwitch&#46;id],
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_vpc = alicloud.vpc.Network("defaultVpc",
 *     cidr_block="172.16.0.0/12",
 *     vpc_name=name)
 * defaulty_v_switch = alicloud.vpc.Switch("defaultyVSwitch",
 *     vpc_id=default_vpc.id,
 *     cidr_block="172.16.2.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_cluster = alicloud.ackone.Cluster("default", network={
 *     "vpc_id": default_vpc.id,
 *     "vswitches": [defaulty_v_switch&#46;id],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultVpc = new AliCloud.Vpc.Network("defaultVpc", new()
 *     {
 *         CidrBlock = "172.16.0.0/12",
 *         VpcName = name,
 *     });
 *     var defaultyVSwitch = new AliCloud.Vpc.Switch("defaultyVSwitch", new()
 *     {
 *         VpcId = defaultVpc.Id,
 *         CidrBlock = "172.16.2.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultCluster = new AliCloud.AckOne.Cluster("default", new()
 *     {
 *         Network = new AliCloud.AckOne.Inputs.ClusterNetworkArgs
 *         {
 *             VpcId = defaultVpc.Id,
 *             Vswitches = new[]
 *             {
 *                 defaultyVSwitch.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ackone"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVpc, err := vpc.NewNetwork(ctx, "defaultVpc", &vpc.NetworkArgs{
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 			VpcName:   pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultyVSwitch, err := vpc.NewSwitch(ctx, "defaultyVSwitch", &vpc.SwitchArgs{
 * 			VpcId:       defaultVpc.ID(),
 * 			CidrBlock:   pulumi.String("172.16.2.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ackone.NewCluster(ctx, "default", &ackone.ClusterArgs{
 * 			Network: &ackone.ClusterNetworkArgs{
 * 				VpcId: defaultVpc.ID(),
 * 				Vswitches: pulumi.StringArray{
 * 					defaultyVSwitch.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ackone.Cluster;
 * import com.pulumi.alicloud.ackone.ClusterArgs;
 * import com.pulumi.alicloud.ackone.inputs.ClusterNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultVpc = new Network("defaultVpc", NetworkArgs.builder()
 *             .cidrBlock("172.16.0.0/12")
 *             .vpcName(name)
 *             .build());
 *         var defaultyVSwitch = new Switch("defaultyVSwitch", SwitchArgs.builder()
 *             .vpcId(defaultVpc.id())
 *             .cidrBlock("172.16.2.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .network(ClusterNetworkArgs.builder()
 *                 .vpcId(defaultVpc.id())
 *                 .vswitches(defaultyVSwitch.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       cidrBlock: 172.16.0.0/12
 *       vpcName: ${name}
 *   defaultyVSwitch:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${defaultVpc.id}
 *       cidrBlock: 172.16.2.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultCluster:
 *     type: alicloud:ackone:Cluster
 *     name: default
 *     properties:
 *       network:
 *         vpcId: ${defaultVpc.id}
 *         vswitches:
 *           - ${defaultyVSwitch.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Ack One Cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ackone/cluster:Cluster example <id>
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.alicloud.ackone.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * Cluster name.
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * Cluster creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Cluster network information. See `network` below.
     */
    public val network: Output<ClusterNetwork>
        get() = javaResource.network().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Cluster attributes. Valid values: 'Default', 'XFlow'.
     */
    public val profile: Output<String>
        get() = javaResource.profile().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ackone.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.alicloud.ackone.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
