@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ackone.kotlin.inputs

import com.pulumi.alicloud.ackone.inputs.ClusterNetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds Security group to which the cluster belongs.
 * @property vpcId VpcId to which the cluster belongs.
 * @property vswitches Switch to which the cluster belongs.
 */
public data class ClusterNetworkArgs(
    public val securityGroupIds: Output<List<String>>? = null,
    public val vpcId: Output<String>,
    public val vswitches: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.alicloud.ackone.inputs.ClusterNetworkArgs> {
    override fun toJava(): com.pulumi.alicloud.ackone.inputs.ClusterNetworkArgs =
        com.pulumi.alicloud.ackone.inputs.ClusterNetworkArgs.builder()
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId.applyValue({ args0 -> args0 }))
            .vswitches(vswitches.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ClusterNetworkArgs].
 */
@PulumiTagMarker
public class ClusterNetworkArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitches: Output<List<String>>? = null

    /**
     * @param value Security group to which the cluster belongs.
     */
    @JvmName("nslaaxtwvviwhsvh")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("mjbjqrumsvohkiil")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Security group to which the cluster belongs.
     */
    @JvmName("bxgaxdhibncwaqto")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value VpcId to which the cluster belongs.
     */
    @JvmName("quiaiwawpodbbess")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Switch to which the cluster belongs.
     */
    @JvmName("pwouxyukucqyndit")
    public suspend fun vswitches(`value`: Output<List<String>>) {
        this.vswitches = value
    }

    @JvmName("jskpgcadibmoiejx")
    public suspend fun vswitches(vararg values: Output<String>) {
        this.vswitches = Output.all(values.asList())
    }

    /**
     * @param values Switch to which the cluster belongs.
     */
    @JvmName("shueeusqkxiqkutx")
    public suspend fun vswitches(values: List<Output<String>>) {
        this.vswitches = Output.all(values)
    }

    /**
     * @param value Security group to which the cluster belongs.
     */
    @JvmName("nrjrylcfjdviwuah")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Security group to which the cluster belongs.
     */
    @JvmName("ahbbabqtagxbuttx")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value VpcId to which the cluster belongs.
     */
    @JvmName("eagiavmryidacukq")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value Switch to which the cluster belongs.
     */
    @JvmName("askknansnusgmcip")
    public suspend fun vswitches(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitches = mapped
    }

    /**
     * @param values Switch to which the cluster belongs.
     */
    @JvmName("asttbxlptnjracxl")
    public suspend fun vswitches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitches = mapped
    }

    internal fun build(): ClusterNetworkArgs = ClusterNetworkArgs(
        securityGroupIds = securityGroupIds,
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
        vswitches = vswitches ?: throw PulumiNullFieldException("vswitches"),
    )
}
