@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ackone.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds Security group to which the cluster belongs.
 * @property vpcId VpcId to which the cluster belongs.
 * @property vswitches Switch to which the cluster belongs.
 */
public data class ClusterNetwork(
    public val securityGroupIds: List<String>? = null,
    public val vpcId: String,
    public val vswitches: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ackone.outputs.ClusterNetwork): ClusterNetwork = ClusterNetwork(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
            vswitches = javaType.vswitches().map({ args0 -> args0 }),
        )
    }
}
