@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin

import com.pulumi.alicloud.actiontrail.ActiontrailFunctions.getConsumerGroupsPlain
import com.pulumi.alicloud.actiontrail.ActiontrailFunctions.getGlobalEventsStorageRegionPlain
import com.pulumi.alicloud.actiontrail.ActiontrailFunctions.getHistoryDeliveryJobsPlain
import com.pulumi.alicloud.actiontrail.ActiontrailFunctions.getInstancesPlain
import com.pulumi.alicloud.actiontrail.ActiontrailFunctions.getSaslAclsPlain
import com.pulumi.alicloud.actiontrail.ActiontrailFunctions.getSaslUsersPlain
import com.pulumi.alicloud.actiontrail.ActiontrailFunctions.getTopicsPlain
import com.pulumi.alicloud.actiontrail.ActiontrailFunctions.getTrailsDeprecatedPlain
import com.pulumi.alicloud.actiontrail.ActiontrailFunctions.getTrailsPlain
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetConsumerGroupsPlainArgs
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetConsumerGroupsPlainArgsBuilder
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetHistoryDeliveryJobsPlainArgs
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetHistoryDeliveryJobsPlainArgsBuilder
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetSaslAclsPlainArgs
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetSaslAclsPlainArgsBuilder
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetSaslUsersPlainArgs
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetSaslUsersPlainArgsBuilder
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetTopicsPlainArgs
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetTopicsPlainArgsBuilder
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetTrailsDeprecatedPlainArgs
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetTrailsDeprecatedPlainArgsBuilder
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetTrailsPlainArgs
import com.pulumi.alicloud.actiontrail.kotlin.inputs.GetTrailsPlainArgsBuilder
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetConsumerGroupsResult
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetGlobalEventsStorageRegionResult
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetHistoryDeliveryJobsResult
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetSaslAclsResult
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetSaslUsersResult
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetTopicsResult
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetTrailsDeprecatedResult
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetTrailsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetConsumerGroupsResult.Companion.toKotlin as getConsumerGroupsResultToKotlin
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetGlobalEventsStorageRegionResult.Companion.toKotlin as getGlobalEventsStorageRegionResultToKotlin
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetHistoryDeliveryJobsResult.Companion.toKotlin as getHistoryDeliveryJobsResultToKotlin
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetSaslAclsResult.Companion.toKotlin as getSaslAclsResultToKotlin
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetSaslUsersResult.Companion.toKotlin as getSaslUsersResultToKotlin
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetTopicsResult.Companion.toKotlin as getTopicsResultToKotlin
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetTrailsDeprecatedResult.Companion.toKotlin as getTrailsDeprecatedResultToKotlin
import com.pulumi.alicloud.actiontrail.kotlin.outputs.GetTrailsResult.Companion.toKotlin as getTrailsResultToKotlin

public object ActiontrailFunctions {
    /**
     * This data source provides a list of ALIKAFKA Consumer Groups in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.56.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const consumerGroupsDs = alicloud.actiontrail.getConsumerGroups({
     *     instanceId: "xxx",
     *     consumerIdRegex: "CID-alikafkaGroupDatasourceName",
     *     outputFile: "consumerGroups.txt",
     * });
     * export const firstGroupName = consumerGroupsDs.then(consumerGroupsDs => consumerGroupsDs.consumerIds?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * consumer_groups_ds = alicloud.actiontrail.get_consumer_groups(instance_id="xxx",
     *     consumer_id_regex="CID-alikafkaGroupDatasourceName",
     *     output_file="consumerGroups.txt")
     * pulumi.export("firstGroupName", consumer_groups_ds.consumer_ids[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var consumerGroupsDs = AliCloud.ActionTrail.GetConsumerGroups.Invoke(new()
     *     {
     *         InstanceId = "xxx",
     *         ConsumerIdRegex = "CID-alikafkaGroupDatasourceName",
     *         OutputFile = "consumerGroups.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstGroupName"] = consumerGroupsDs&#46;Apply(getConsumerGroupsResult => getConsumerGroupsResult&#46;ConsumerIds[0]),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		consumerGroupsDs, err := actiontrail.GetConsumerGroups(ctx, &actiontrail.GetConsumerGroupsArgs{
     * 			InstanceId:      "xxx",
     * 			ConsumerIdRegex: pulumi.StringRef("CID-alikafkaGroupDatasourceName"),
     * 			OutputFile:      pulumi.StringRef("consumerGroups.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstGroupName", consumerGroupsDs.ConsumerIds[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.actiontrail.ActiontrailFunctions;
     * import com.pulumi.alicloud.actiontrail.inputs.GetConsumerGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var consumerGroupsDs = ActiontrailFunctions.getConsumerGroups(GetConsumerGroupsArgs.builder()
     *             .instanceId("xxx")
     *             .consumerIdRegex("CID-alikafkaGroupDatasourceName")
     *             .outputFile("consumerGroups.txt")
     *             .build());
     *         ctx.export("firstGroupName", consumerGroupsDs.applyValue(getConsumerGroupsResult -> getConsumerGroupsResult.consumerIds()[0]));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   consumerGroupsDs:
     *     fn::invoke:
     *       Function: alicloud:actiontrail:getConsumerGroups
     *       Arguments:
     *         instanceId: xxx
     *         consumerIdRegex: CID-alikafkaGroupDatasourceName
     *         outputFile: consumerGroups.txt
     * outputs:
     *   firstGroupName: ${consumerGroupsDs.consumerIds[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConsumerGroups.
     * @return A collection of values returned by getConsumerGroups.
     */
    public suspend fun getConsumerGroups(argument: GetConsumerGroupsPlainArgs): GetConsumerGroupsResult =
        getConsumerGroupsResultToKotlin(getConsumerGroupsPlain(argument.toJava()).await())

    /**
     * @see [getConsumerGroups].
     * @param consumerIdRegex A regex string to filter results by the consumer group id.
     * @param ids A list of ALIKAFKA Consumer Groups IDs, It is formatted to `<instance_id>:<consumer_id>`.
     * @param instanceId ID of the ALIKAFKA Instance that owns the consumer groups.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getConsumerGroups.
     */
    public suspend fun getConsumerGroups(
        consumerIdRegex: String? = null,
        ids: List<String>? = null,
        instanceId: String,
        outputFile: String? = null,
    ): GetConsumerGroupsResult {
        val argument = GetConsumerGroupsPlainArgs(
            consumerIdRegex = consumerIdRegex,
            ids = ids,
            instanceId = instanceId,
            outputFile = outputFile,
        )
        return getConsumerGroupsResultToKotlin(getConsumerGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getConsumerGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;actiontrail&#46;kotlin&#46;inputs&#46;GetConsumerGroupsPlainArgs].
     * @return A collection of values returned by getConsumerGroups.
     */
    public suspend fun getConsumerGroups(argument: suspend GetConsumerGroupsPlainArgsBuilder.() -> Unit): GetConsumerGroupsResult {
        val builder = GetConsumerGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConsumerGroupsResultToKotlin(getConsumerGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Actiontrail Global Events Storage Region of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.201.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.actiontrail.getGlobalEventsStorageRegion({});
     * export const alicloudActiontrailGlobalEventsStorageRegion1 = _default.then(_default => _default.storageRegion);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.actiontrail.get_global_events_storage_region()
     * pulumi.export("alicloudActiontrailGlobalEventsStorageRegion1", default.storage_region)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ActionTrail.GetGlobalEventsStorageRegion.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudActiontrailGlobalEventsStorageRegion1"] = @default.Apply(@default => @default.Apply(getGlobalEventsStorageRegionResult => getGlobalEventsStorageRegionResult.StorageRegion)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := actiontrail.LookupGlobalEventsStorageRegion(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudActiontrailGlobalEventsStorageRegion1", _default.StorageRegion)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.actiontrail.ActiontrailFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ActiontrailFunctions.getGlobalEventsStorageRegion();
     *         ctx.export("alicloudActiontrailGlobalEventsStorageRegion1", default_.storageRegion());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:actiontrail:getGlobalEventsStorageRegion
     *       Arguments: {}
     * outputs:
     *   alicloudActiontrailGlobalEventsStorageRegion1: ${default.storageRegion}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument This data source provides the Actiontrail Global Events Storage Region of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.201.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.actiontrail.getGlobalEventsStorageRegion({});
     * export const alicloudActiontrailGlobalEventsStorageRegion1 = _default.then(_default => _default.storageRegion);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.actiontrail.get_global_events_storage_region()
     * pulumi.export("alicloudActiontrailGlobalEventsStorageRegion1", default.storage_region)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ActionTrail.GetGlobalEventsStorageRegion.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudActiontrailGlobalEventsStorageRegion1"] = @default.Apply(@default => @default.Apply(getGlobalEventsStorageRegionResult => getGlobalEventsStorageRegionResult.StorageRegion)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := actiontrail.LookupGlobalEventsStorageRegion(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudActiontrailGlobalEventsStorageRegion1", _default.StorageRegion)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.actiontrail.ActiontrailFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ActiontrailFunctions.getGlobalEventsStorageRegion();
     *         ctx.export("alicloudActiontrailGlobalEventsStorageRegion1", default_.storageRegion());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:actiontrail:getGlobalEventsStorageRegion
     *       Arguments: {}
     * outputs:
     *   alicloudActiontrailGlobalEventsStorageRegion1: ${default.storageRegion}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getGlobalEventsStorageRegion.
     */
    public suspend fun getGlobalEventsStorageRegion(): GetGlobalEventsStorageRegionResult =
        getGlobalEventsStorageRegionResultToKotlin(getGlobalEventsStorageRegionPlain().await())

    /**
     * This data source provides the Actiontrail History Delivery Jobs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.139.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.actiontrail.getHistoryDeliveryJobs({
     *     ids: ["example_id"],
     * });
     * export const actiontrailHistoryDeliveryJobId1 = ids.then(ids => ids.jobs?.[0]?.id);
     * const status = alicloud.actiontrail.getHistoryDeliveryJobs({
     *     ids: ["example_id"],
     *     status: 2,
     * });
     * export const actiontrailHistoryDeliveryJobId2 = status.then(status => status.jobs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.actiontrail.get_history_delivery_jobs(ids=["example_id"])
     * pulumi.export("actiontrailHistoryDeliveryJobId1", ids.jobs[0].id)
     * status = alicloud.actiontrail.get_history_delivery_jobs(ids=["example_id"],
     *     status=2)
     * pulumi.export("actiontrailHistoryDeliveryJobId2", status.jobs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ActionTrail.GetHistoryDeliveryJobs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var status = AliCloud.ActionTrail.GetHistoryDeliveryJobs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *         Status = 2,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["actiontrailHistoryDeliveryJobId1"] = ids&#46;Apply(getHistoryDeliveryJobsResult => getHistoryDeliveryJobsResult&#46;Jobs[0]?.Id),
     *         ["actiontrailHistoryDeliveryJobId2"] = status&#46;Apply(getHistoryDeliveryJobsResult => getHistoryDeliveryJobsResult&#46;Jobs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := actiontrail.GetHistoryDeliveryJobs(ctx, &actiontrail.GetHistoryDeliveryJobsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("actiontrailHistoryDeliveryJobId1", ids.Jobs[0].Id)
     * 		status, err := actiontrail.GetHistoryDeliveryJobs(ctx, &actiontrail.GetHistoryDeliveryJobsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 			Status: pulumi.IntRef(2),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("actiontrailHistoryDeliveryJobId2", status.Jobs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.actiontrail.ActiontrailFunctions;
     * import com.pulumi.alicloud.actiontrail.inputs.GetHistoryDeliveryJobsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ActiontrailFunctions.getHistoryDeliveryJobs(GetHistoryDeliveryJobsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("actiontrailHistoryDeliveryJobId1", ids.applyValue(getHistoryDeliveryJobsResult -> getHistoryDeliveryJobsResult.jobs()[0].id()));
     *         final var status = ActiontrailFunctions.getHistoryDeliveryJobs(GetHistoryDeliveryJobsArgs.builder()
     *             .ids("example_id")
     *             .status("2")
     *             .build());
     *         ctx.export("actiontrailHistoryDeliveryJobId2", status.applyValue(getHistoryDeliveryJobsResult -> getHistoryDeliveryJobsResult.jobs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:actiontrail:getHistoryDeliveryJobs
     *       Arguments:
     *         ids:
     *           - example_id
     *   status:
     *     fn::invoke:
     *       Function: alicloud:actiontrail:getHistoryDeliveryJobs
     *       Arguments:
     *         ids:
     *           - example_id
     *         status: '2'
     * outputs:
     *   actiontrailHistoryDeliveryJobId1: ${ids.jobs[0].id}
     *   actiontrailHistoryDeliveryJobId2: ${status.jobs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHistoryDeliveryJobs.
     * @return A collection of values returned by getHistoryDeliveryJobs.
     */
    public suspend fun getHistoryDeliveryJobs(argument: GetHistoryDeliveryJobsPlainArgs): GetHistoryDeliveryJobsResult =
        getHistoryDeliveryJobsResultToKotlin(getHistoryDeliveryJobsPlain(argument.toJava()).await())

    /**
     * @see [getHistoryDeliveryJobs].
     * @param enableDetails
     * @param ids A list of History Delivery Job IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the task. Valid values: `0`, `1`, `2`, `3`. `0`: The task is initializing. `1`: The task is delivering historical events. `2`: The delivery of historical events is complete. `3`: The task fails.
     * @return A collection of values returned by getHistoryDeliveryJobs.
     */
    public suspend fun getHistoryDeliveryJobs(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: Int? = null,
    ): GetHistoryDeliveryJobsResult {
        val argument = GetHistoryDeliveryJobsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getHistoryDeliveryJobsResultToKotlin(getHistoryDeliveryJobsPlain(argument.toJava()).await())
    }

    /**
     * @see [getHistoryDeliveryJobs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;actiontrail&#46;kotlin&#46;inputs&#46;GetHistoryDeliveryJobsPlainArgs].
     * @return A collection of values returned by getHistoryDeliveryJobs.
     */
    public suspend fun getHistoryDeliveryJobs(argument: suspend GetHistoryDeliveryJobsPlainArgsBuilder.() -> Unit): GetHistoryDeliveryJobsResult {
        val builder = GetHistoryDeliveryJobsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHistoryDeliveryJobsResultToKotlin(getHistoryDeliveryJobsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of ALIKAFKA Instances in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.59.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const instanceName = config.get("instanceName") || "alikafkaInstanceName";
     * const default = alicloud.getZones({
     *     availableResourceCreation: "VSwitch",
     * });
     * const defaultNetwork = new alicloud.vpc.Network("default", {cidrBlock: "172.16.0.0/12"});
     * const defaultSwitch = new alicloud.vpc.Switch("default", {
     *     vpcId: defaultNetwork.id,
     *     cidrBlock: "172.16.0.0/24",
     *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
     * });
     * const defaultInstance = new alicloud.alikafka.Instance("default", {
     *     name: instanceName,
     *     partitionNum: 50,
     *     diskType: 1,
     *     diskSize: 500,
     *     deployType: 4,
     *     ioMax: 20,
     *     vswitchId: defaultSwitch.id,
     * });
     * const instancesDs = alicloud.actiontrail.getInstances({
     *     nameRegex: "alikafkaInstanceName",
     *     outputFile: "instances.txt",
     * });
     * export const firstInstanceName = instancesDs.then(instancesDs => instancesDs.instances?.[0]?.name);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * instance_name = config.get("instanceName")
     * if instance_name is None:
     *     instance_name = "alikafkaInstanceName"
     * default = alicloud.get_zones(available_resource_creation="VSwitch")
     * default_network = alicloud.vpc.Network("default", cidr_block="172.16.0.0/12")
     * default_switch = alicloud.vpc.Switch("default",
     *     vpc_id=default_network.id,
     *     cidr_block="172.16.0.0/24",
     *     zone_id=default.zones[0].id)
     * default_instance = alicloud.alikafka.Instance("default",
     *     name=instance_name,
     *     partition_num=50,
     *     disk_type=1,
     *     disk_size=500,
     *     deploy_type=4,
     *     io_max=20,
     *     vswitch_id=default_switch.id)
     * instances_ds = alicloud.actiontrail.get_instances(name_regex="alikafkaInstanceName",
     *     output_file="instances.txt")
     * pulumi.export("firstInstanceName", instances_ds.instances[0].name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var instanceName = config.Get("instanceName") ?? "alikafkaInstanceName";
     *     var @default = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableResourceCreation = "VSwitch",
     *     });
     *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
     *     {
     *         CidrBlock = "172.16.0.0/12",
     *     });
     *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
     *     {
     *         VpcId = defaultNetwork.Id,
     *         CidrBlock = "172.16.0.0/24",
     *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *     });
     *     var defaultInstance = new AliCloud.AliKafka.Instance("default", new()
     *     {
     *         Name = instanceName,
     *         PartitionNum = 50,
     *         DiskType = 1,
     *         DiskSize = 500,
     *         DeployType = 4,
     *         IoMax = 20,
     *         VswitchId = defaultSwitch.Id,
     *     });
     *     var instancesDs = AliCloud.ActionTrail.GetInstances.Invoke(new()
     *     {
     *         NameRegex = "alikafkaInstanceName",
     *         OutputFile = "instances.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstInstanceName"] = instancesDs&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Name),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alikafka"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		instanceName := "alikafkaInstanceName"
     * 		if param := cfg.Get("instanceName"); param != "" {
     * 			instanceName = param
     * 		}
     * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
     * 			CidrBlock: pulumi.String("172.16.0.0/12"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
     * 			VpcId:     defaultNetwork.ID(),
     * 			CidrBlock: pulumi.String("172.16.0.0/24"),
     * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = alikafka.NewInstance(ctx, "default", &alikafka.InstanceArgs{
     * 			Name:         pulumi.String(instanceName),
     * 			PartitionNum: pulumi.Int(50),
     * 			DiskType:     pulumi.Int(1),
     * 			DiskSize:     pulumi.Int(500),
     * 			DeployType:   pulumi.Int(4),
     * 			IoMax:        pulumi.Int(20),
     * 			VswitchId:    defaultSwitch.ID(),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		instancesDs, err := actiontrail.GetInstances(ctx, &actiontrail.GetInstancesArgs{
     * 			NameRegex:  pulumi.StringRef("alikafkaInstanceName"),
     * 			OutputFile: pulumi.StringRef("instances.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstInstanceName", instancesDs.Instances[0].Name)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.alikafka.Instance;
     * import com.pulumi.alicloud.alikafka.InstanceArgs;
     * import com.pulumi.alicloud.actiontrail.ActiontrailFunctions;
     * import com.pulumi.alicloud.actiontrail.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var instanceName = config.get("instanceName").orElse("alikafkaInstanceName");
     *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableResourceCreation("VSwitch")
     *             .build());
     *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
     *             .cidrBlock("172.16.0.0/12")
     *             .build());
     *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
     *             .vpcId(defaultNetwork.id())
     *             .cidrBlock("172.16.0.0/24")
     *             .zoneId(default_.zones()[0].id())
     *             .build());
     *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
     *             .name(instanceName)
     *             .partitionNum("50")
     *             .diskType("1")
     *             .diskSize("500")
     *             .deployType("4")
     *             .ioMax("20")
     *             .vswitchId(defaultSwitch.id())
     *             .build());
     *         final var instancesDs = ActiontrailFunctions.getInstances(GetInstancesArgs.builder()
     *             .nameRegex("alikafkaInstanceName")
     *             .outputFile("instances.txt")
     *             .build());
     *         ctx.export("firstInstanceName", instancesDs.applyValue(getInstancesResult -> getInstancesResult.instances()[0].name()));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   instanceName:
     *     type: string
     *     default: alikafkaInstanceName
     * resources:
     *   defaultNetwork:
     *     type: alicloud:vpc:Network
     *     name: default
     *     properties:
     *       cidrBlock: 172.16.0.0/12
     *   defaultSwitch:
     *     type: alicloud:vpc:Switch
     *     name: default
     *     properties:
     *       vpcId: ${defaultNetwork.id}
     *       cidrBlock: 172.16.0.0/24
     *       zoneId: ${default.zones[0].id}
     *   defaultInstance:
     *     type: alicloud:alikafka:Instance
     *     name: default
     *     properties:
     *       name: ${instanceName}
     *       partitionNum: '50'
     *       diskType: '1'
     *       diskSize: '500'
     *       deployType: '4'
     *       ioMax: '20'
     *       vswitchId: ${defaultSwitch.id}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableResourceCreation: VSwitch
     *   instancesDs:
     *     fn::invoke:
     *       Function: alicloud:actiontrail:getInstances
     *       Arguments:
     *         nameRegex: alikafkaInstanceName
     *         outputFile: instances.txt
     * outputs:
     *   firstInstanceName: ${instancesDs.instances[0].name}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param enableDetails
     * @param ids A list of instance IDs to filter results.
     * @param nameRegex A regex string to filter results by the instance name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;actiontrail&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of ALIKAFKA Sasl acls in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.66.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const saslAclsDs = alicloud.actiontrail.getSaslAcls({
     *     instanceId: "xxx",
     *     username: "username",
     *     aclResourceType: "Topic",
     *     aclResourceName: "testTopic",
     *     outputFile: "saslAcls.txt",
     * });
     * export const firstSaslAclUsername = saslAclsDs.then(saslAclsDs => saslAclsDs.acls?.[0]?.username);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * sasl_acls_ds = alicloud.actiontrail.get_sasl_acls(instance_id="xxx",
     *     username="username",
     *     acl_resource_type="Topic",
     *     acl_resource_name="testTopic",
     *     output_file="saslAcls.txt")
     * pulumi.export("firstSaslAclUsername", sasl_acls_ds.acls[0].username)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var saslAclsDs = AliCloud.ActionTrail.GetSaslAcls.Invoke(new()
     *     {
     *         InstanceId = "xxx",
     *         Username = "username",
     *         AclResourceType = "Topic",
     *         AclResourceName = "testTopic",
     *         OutputFile = "saslAcls.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSaslAclUsername"] = saslAclsDs&#46;Apply(getSaslAclsResult => getSaslAclsResult&#46;Acls[0]?.Username),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		saslAclsDs, err := actiontrail.GetSaslAcls(ctx, &actiontrail.GetSaslAclsArgs{
     * 			InstanceId:      "xxx",
     * 			Username:        "username",
     * 			AclResourceType: "Topic",
     * 			AclResourceName: "testTopic",
     * 			OutputFile:      pulumi.StringRef("saslAcls.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstSaslAclUsername", saslAclsDs.Acls[0].Username)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.actiontrail.ActiontrailFunctions;
     * import com.pulumi.alicloud.actiontrail.inputs.GetSaslAclsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var saslAclsDs = ActiontrailFunctions.getSaslAcls(GetSaslAclsArgs.builder()
     *             .instanceId("xxx")
     *             .username("username")
     *             .aclResourceType("Topic")
     *             .aclResourceName("testTopic")
     *             .outputFile("saslAcls.txt")
     *             .build());
     *         ctx.export("firstSaslAclUsername", saslAclsDs.applyValue(getSaslAclsResult -> getSaslAclsResult.acls()[0].username()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   saslAclsDs:
     *     fn::invoke:
     *       Function: alicloud:actiontrail:getSaslAcls
     *       Arguments:
     *         instanceId: xxx
     *         username: username
     *         aclResourceType: Topic
     *         aclResourceName: testTopic
     *         outputFile: saslAcls.txt
     * outputs:
     *   firstSaslAclUsername: ${saslAclsDs.acls[0].username}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSaslAcls.
     * @return A collection of values returned by getSaslAcls.
     */
    public suspend fun getSaslAcls(argument: GetSaslAclsPlainArgs): GetSaslAclsResult =
        getSaslAclsResultToKotlin(getSaslAclsPlain(argument.toJava()).await())

    /**
     * @see [getSaslAcls].
     * @param aclResourceName Get results for the specified resource name.
     * @param aclResourceType Get results for the specified resource type.
     * @param instanceId ID of the ALIKAFKA Instance that owns the sasl acls.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param username Get results for the specified username.
     * @return A collection of values returned by getSaslAcls.
     */
    public suspend fun getSaslAcls(
        aclResourceName: String,
        aclResourceType: String,
        instanceId: String,
        outputFile: String? = null,
        username: String,
    ): GetSaslAclsResult {
        val argument = GetSaslAclsPlainArgs(
            aclResourceName = aclResourceName,
            aclResourceType = aclResourceType,
            instanceId = instanceId,
            outputFile = outputFile,
            username = username,
        )
        return getSaslAclsResultToKotlin(getSaslAclsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSaslAcls].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;actiontrail&#46;kotlin&#46;inputs&#46;GetSaslAclsPlainArgs].
     * @return A collection of values returned by getSaslAcls.
     */
    public suspend fun getSaslAcls(argument: suspend GetSaslAclsPlainArgsBuilder.() -> Unit): GetSaslAclsResult {
        val builder = GetSaslAclsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSaslAclsResultToKotlin(getSaslAclsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of ALIKAFKA Sasl users in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.66.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const saslUsersDs = alicloud.actiontrail.getSaslUsers({
     *     instanceId: "xxx",
     *     nameRegex: "username",
     *     outputFile: "saslUsers.txt",
     * });
     * export const firstSaslUsername = saslUsersDs.then(saslUsersDs => saslUsersDs.users?.[0]?.username);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * sasl_users_ds = alicloud.actiontrail.get_sasl_users(instance_id="xxx",
     *     name_regex="username",
     *     output_file="saslUsers.txt")
     * pulumi.export("firstSaslUsername", sasl_users_ds.users[0].username)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var saslUsersDs = AliCloud.ActionTrail.GetSaslUsers.Invoke(new()
     *     {
     *         InstanceId = "xxx",
     *         NameRegex = "username",
     *         OutputFile = "saslUsers.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSaslUsername"] = saslUsersDs&#46;Apply(getSaslUsersResult => getSaslUsersResult&#46;Users[0]?.Username),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		saslUsersDs, err := actiontrail.GetSaslUsers(ctx, &actiontrail.GetSaslUsersArgs{
     * 			InstanceId: "xxx",
     * 			NameRegex:  pulumi.StringRef("username"),
     * 			OutputFile: pulumi.StringRef("saslUsers.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstSaslUsername", saslUsersDs.Users[0].Username)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.actiontrail.ActiontrailFunctions;
     * import com.pulumi.alicloud.actiontrail.inputs.GetSaslUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var saslUsersDs = ActiontrailFunctions.getSaslUsers(GetSaslUsersArgs.builder()
     *             .instanceId("xxx")
     *             .nameRegex("username")
     *             .outputFile("saslUsers.txt")
     *             .build());
     *         ctx.export("firstSaslUsername", saslUsersDs.applyValue(getSaslUsersResult -> getSaslUsersResult.users()[0].username()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   saslUsersDs:
     *     fn::invoke:
     *       Function: alicloud:actiontrail:getSaslUsers
     *       Arguments:
     *         instanceId: xxx
     *         nameRegex: username
     *         outputFile: saslUsers.txt
     * outputs:
     *   firstSaslUsername: ${saslUsersDs.users[0].username}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSaslUsers.
     * @return A collection of values returned by getSaslUsers.
     */
    public suspend fun getSaslUsers(argument: GetSaslUsersPlainArgs): GetSaslUsersResult =
        getSaslUsersResultToKotlin(getSaslUsersPlain(argument.toJava()).await())

    /**
     * @see [getSaslUsers].
     * @param instanceId ID of the ALIKAFKA Instance that owns the sasl users.
     * @param nameRegex A regex string to filter results by the username.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getSaslUsers.
     */
    public suspend fun getSaslUsers(
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetSaslUsersResult {
        val argument = GetSaslUsersPlainArgs(
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getSaslUsersResultToKotlin(getSaslUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getSaslUsers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;actiontrail&#46;kotlin&#46;inputs&#46;GetSaslUsersPlainArgs].
     * @return A collection of values returned by getSaslUsers.
     */
    public suspend fun getSaslUsers(argument: suspend GetSaslUsersPlainArgsBuilder.() -> Unit): GetSaslUsersResult {
        val builder = GetSaslUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSaslUsersResultToKotlin(getSaslUsersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of ALIKAFKA Topics in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.56.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const topicsDs = alicloud.actiontrail.getTopics({
     *     instanceId: "xxx",
     *     nameRegex: "alikafkaTopicName",
     *     outputFile: "topics.txt",
     * });
     * export const firstTopicName = topicsDs.then(topicsDs => topicsDs.topics?.[0]?.topic);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * topics_ds = alicloud.actiontrail.get_topics(instance_id="xxx",
     *     name_regex="alikafkaTopicName",
     *     output_file="topics.txt")
     * pulumi.export("firstTopicName", topics_ds.topics[0].topic)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var topicsDs = AliCloud.ActionTrail.GetTopics.Invoke(new()
     *     {
     *         InstanceId = "xxx",
     *         NameRegex = "alikafkaTopicName",
     *         OutputFile = "topics.txt",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstTopicName"] = topicsDs&#46;Apply(getTopicsResult => getTopicsResult&#46;Topics[0]?.Topic),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		topicsDs, err := actiontrail.GetTopics(ctx, &actiontrail.GetTopicsArgs{
     * 			InstanceId: "xxx",
     * 			NameRegex:  pulumi.StringRef("alikafkaTopicName"),
     * 			OutputFile: pulumi.StringRef("topics.txt"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstTopicName", topicsDs.Topics[0].Topic)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.actiontrail.ActiontrailFunctions;
     * import com.pulumi.alicloud.actiontrail.inputs.GetTopicsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var topicsDs = ActiontrailFunctions.getTopics(GetTopicsArgs.builder()
     *             .instanceId("xxx")
     *             .nameRegex("alikafkaTopicName")
     *             .outputFile("topics.txt")
     *             .build());
     *         ctx.export("firstTopicName", topicsDs.applyValue(getTopicsResult -> getTopicsResult.topics()[0].topic()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   topicsDs:
     *     fn::invoke:
     *       Function: alicloud:actiontrail:getTopics
     *       Arguments:
     *         instanceId: xxx
     *         nameRegex: alikafkaTopicName
     *         outputFile: topics.txt
     * outputs:
     *   firstTopicName: ${topicsDs.topics[0].topic}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTopics.
     * @return A collection of values returned by getTopics.
     */
    public suspend fun getTopics(argument: GetTopicsPlainArgs): GetTopicsResult =
        getTopicsResultToKotlin(getTopicsPlain(argument.toJava()).await())

    /**
     * @see [getTopics].
     * @param ids A list of ALIKAFKA Topics IDs, It is formatted to `<instance_id>:<topic>`.
     * @param instanceId ID of the instance.
     * @param nameRegex A regex string to filter results by the topic name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param topic A topic to filter results by the topic name.
     * @return A collection of values returned by getTopics.
     */
    public suspend fun getTopics(
        ids: List<String>? = null,
        instanceId: String,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        topic: String? = null,
    ): GetTopicsResult {
        val argument = GetTopicsPlainArgs(
            ids = ids,
            instanceId = instanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            topic = topic,
        )
        return getTopicsResultToKotlin(getTopicsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTopics].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;actiontrail&#46;kotlin&#46;inputs&#46;GetTopicsPlainArgs].
     * @return A collection of values returned by getTopics.
     */
    public suspend fun getTopics(argument: suspend GetTopicsPlainArgsBuilder.() -> Unit): GetTopicsResult {
        val builder = GetTopicsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTopicsResultToKotlin(getTopicsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of ActionTrail Trails in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in 1.95.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.actiontrail.getTrails({
     *     nameRegex: "tf-testacc-actiontrail",
     * });
     * export const trailName = _default.then(_default => _default.trails?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.actiontrail.get_trails(name_regex="tf-testacc-actiontrail")
     * pulumi.export("trailName", default.trails[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ActionTrail.GetTrails.Invoke(new()
     *     {
     *         NameRegex = "tf-testacc-actiontrail",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["trailName"] = @default&#46;Apply(@default => @default&#46;Apply(getTrailsResult => getTrailsResult&#46;Trails[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := actiontrail.GetTrails(ctx, &actiontrail.GetTrailsArgs{
     * 			NameRegex: pulumi.StringRef("tf-testacc-actiontrail"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("trailName", _default.Trails[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.actiontrail.ActiontrailFunctions;
     * import com.pulumi.alicloud.actiontrail.inputs.GetTrailsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ActiontrailFunctions.getTrails(GetTrailsArgs.builder()
     *             .nameRegex("tf-testacc-actiontrail")
     *             .build());
     *         ctx.export("trailName", default_.trails()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:actiontrail:getTrails
     *       Arguments:
     *         nameRegex: tf-testacc-actiontrail
     * outputs:
     *   trailName: ${default.trails[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTrails.
     * @return A collection of values returned by getTrails.
     */
    public suspend fun getTrails(argument: GetTrailsPlainArgs): GetTrailsResult =
        getTrailsResultToKotlin(getTrailsPlain(argument.toJava()).await())

    /**
     * @see [getTrails].
     * @param ids A list of ActionTrail Trail IDs. It is the same as trail name.
     * @param includeOrganizationTrail Whether to show organization tracking. Default to `false`.
     * @param includeShadowTrails Whether to show shadow tracking. Default to `false`.
     * @param nameRegex A regex string to filter results by trail name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status Filter the results by status of the ActionTrail Trail. Valid values: `Disable`, `Enable`, `Fresh`.
     * @return A collection of values returned by getTrails.
     */
    public suspend fun getTrails(
        ids: List<String>? = null,
        includeOrganizationTrail: Boolean? = null,
        includeShadowTrails: Boolean? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetTrailsResult {
        val argument = GetTrailsPlainArgs(
            ids = ids,
            includeOrganizationTrail = includeOrganizationTrail,
            includeShadowTrails = includeShadowTrails,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getTrailsResultToKotlin(getTrailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrails].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;actiontrail&#46;kotlin&#46;inputs&#46;GetTrailsPlainArgs].
     * @return A collection of values returned by getTrails.
     */
    public suspend fun getTrails(argument: suspend GetTrailsPlainArgsBuilder.() -> Unit): GetTrailsResult {
        val builder = GetTrailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrailsResultToKotlin(getTrailsPlain(builtArgument.toJava()).await())
    }

    /**
     * > **DEPRECATED:**  This datasource has been renamed to alicloud.actiontrail.getTrails from version 1.95.0.
     * This data source provides a list of action trail of the current Alibaba Cloud user.
     * @param argument A collection of arguments for invoking getTrailsDeprecated.
     * @return A collection of values returned by getTrailsDeprecated.
     */
    @Deprecated(
        message = """
  DataSource has been renamed to `getTrails`
  """,
    )
    public suspend fun getTrailsDeprecated(argument: GetTrailsDeprecatedPlainArgs): GetTrailsDeprecatedResult =
        getTrailsDeprecatedResultToKotlin(getTrailsDeprecatedPlain(argument.toJava()).await())

    /**
     * @see [getTrailsDeprecated].
     * @param ids
     * @param includeOrganizationTrail
     * @param includeShadowTrails
     * @param nameRegex A regex string to filter results action trail name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status
     * @return A collection of values returned by getTrailsDeprecated.
     */
    @Deprecated(
        message = """
  DataSource has been renamed to `getTrails`
  """,
    )
    public suspend fun getTrailsDeprecated(
        ids: List<String>? = null,
        includeOrganizationTrail: Boolean? = null,
        includeShadowTrails: Boolean? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetTrailsDeprecatedResult {
        val argument = GetTrailsDeprecatedPlainArgs(
            ids = ids,
            includeOrganizationTrail = includeOrganizationTrail,
            includeShadowTrails = includeShadowTrails,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getTrailsDeprecatedResultToKotlin(getTrailsDeprecatedPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrailsDeprecated].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;actiontrail&#46;kotlin&#46;inputs&#46;GetTrailsDeprecatedPlainArgs].
     * @return A collection of values returned by getTrailsDeprecated.
     */
    @Deprecated(
        message = """
  DataSource has been renamed to `getTrails`
  """,
    )
    public suspend fun getTrailsDeprecated(argument: suspend GetTrailsDeprecatedPlainArgsBuilder.() -> Unit): GetTrailsDeprecatedResult {
        val builder = GetTrailsDeprecatedPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrailsDeprecatedResultToKotlin(getTrailsDeprecatedPlain(builtArgument.toJava()).await())
    }
}
