@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GlobalEventsStorageRegion].
 */
@PulumiTagMarker
public class GlobalEventsStorageRegionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GlobalEventsStorageRegionArgs = GlobalEventsStorageRegionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GlobalEventsStorageRegionArgsBuilder.() -> Unit) {
        val builder = GlobalEventsStorageRegionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GlobalEventsStorageRegion {
        val builtJavaResource =
            com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GlobalEventsStorageRegion(builtJavaResource)
    }
}

/**
 * Provides a Global events storage region resource.
 * For information about global events storage region and how to use it, see [What is Global Events Storage Region](https://help.aliyun.com/zh/actiontrail/developer-reference/api-actiontrail-2020-07-06-updateglobaleventsstorageregion).
 * > **NOTE:** Available since v1.201.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = new alicloud.actiontrail.GlobalEventsStorageRegion("foo", {storageRegion: "cn-hangzhou"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.actiontrail.GlobalEventsStorageRegion("foo", storage_region="cn-hangzhou")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new AliCloud.ActionTrail.GlobalEventsStorageRegion("foo", new()
 *     {
 *         StorageRegion = "cn-hangzhou",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := actiontrail.NewGlobalEventsStorageRegion(ctx, "foo", &actiontrail.GlobalEventsStorageRegionArgs{
 * 			StorageRegion: pulumi.String("cn-hangzhou"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegion;
 * import com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new GlobalEventsStorageRegion("foo", GlobalEventsStorageRegionArgs.builder()
 *             .storageRegion("cn-hangzhou")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:actiontrail:GlobalEventsStorageRegion
 *     properties:
 *       storageRegion: cn-hangzhou
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global events storage region not can be imported.
 */
public class GlobalEventsStorageRegion internal constructor(
    override val javaResource: com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegion,
) : KotlinCustomResource(javaResource, GlobalEventsStorageRegionMapper) {
    /**
     * Global Events Storage Region.
     */
    public val storageRegion: Output<String>
        get() = javaResource.storageRegion().applyValue({ args0 -> args0 })
}

public object GlobalEventsStorageRegionMapper : ResourceMapper<GlobalEventsStorageRegion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegion::class == javaResource::class

    override fun map(javaResource: Resource): GlobalEventsStorageRegion =
        GlobalEventsStorageRegion(
            javaResource as
                com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegion,
        )
}

/**
 * @see [GlobalEventsStorageRegion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GlobalEventsStorageRegion].
 */
public suspend fun globalEventsStorageRegion(
    name: String,
    block: suspend GlobalEventsStorageRegionResourceBuilder.() -> Unit,
): GlobalEventsStorageRegion {
    val builder = GlobalEventsStorageRegionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GlobalEventsStorageRegion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun globalEventsStorageRegion(name: String): GlobalEventsStorageRegion {
    val builder = GlobalEventsStorageRegionResourceBuilder()
    builder.name(name)
    return builder.build()
}
