@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin

import com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Global events storage region resource.
 * For information about global events storage region and how to use it, see [What is Global Events Storage Region](https://help.aliyun.com/zh/actiontrail/developer-reference/api-actiontrail-2020-07-06-updateglobaleventsstorageregion).
 * > **NOTE:** Available since v1.201.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = new alicloud.actiontrail.GlobalEventsStorageRegion("foo", {storageRegion: "cn-hangzhou"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.actiontrail.GlobalEventsStorageRegion("foo", storage_region="cn-hangzhou")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new AliCloud.ActionTrail.GlobalEventsStorageRegion("foo", new()
 *     {
 *         StorageRegion = "cn-hangzhou",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := actiontrail.NewGlobalEventsStorageRegion(ctx, "foo", &actiontrail.GlobalEventsStorageRegionArgs{
 * 			StorageRegion: pulumi.String("cn-hangzhou"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegion;
 * import com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new GlobalEventsStorageRegion("foo", GlobalEventsStorageRegionArgs.builder()
 *             .storageRegion("cn-hangzhou")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:actiontrail:GlobalEventsStorageRegion
 *     properties:
 *       storageRegion: cn-hangzhou
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Global events storage region not can be imported.
 * @property storageRegion Global Events Storage Region.
 */
public data class GlobalEventsStorageRegionArgs(
    public val storageRegion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegionArgs> {
    override fun toJava(): com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegionArgs =
        com.pulumi.alicloud.actiontrail.GlobalEventsStorageRegionArgs.builder()
            .storageRegion(storageRegion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GlobalEventsStorageRegionArgs].
 */
@PulumiTagMarker
public class GlobalEventsStorageRegionArgsBuilder internal constructor() {
    private var storageRegion: Output<String>? = null

    /**
     * @param value Global Events Storage Region.
     */
    @JvmName("iwloesnppekdbedg")
    public suspend fun storageRegion(`value`: Output<String>) {
        this.storageRegion = value
    }

    /**
     * @param value Global Events Storage Region.
     */
    @JvmName("sjplsebvwmbduypn")
    public suspend fun storageRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageRegion = mapped
    }

    internal fun build(): GlobalEventsStorageRegionArgs = GlobalEventsStorageRegionArgs(
        storageRegion = storageRegion,
    )
}
