@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin

import com.pulumi.alicloud.actiontrail.HistoryDeliveryJobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Actiontrail History Delivery Job resource.
 * For information about Actiontrail History Delivery Job and how to use it, see [What is History Delivery Job](https://www.alibabacloud.com/help/en/actiontrail/latest/api-actiontrail-2020-07-06-createdeliveryhistoryjob).
 * > **NOTE:** Available since v1.139.0.
 * > **NOTE:** You are authorized to use the historical event delivery task feature. To use this feature, [submit a ticket](https://workorder-intl.console.aliyun.com/?spm=a2c63.p38356.0.0.e29f552bb6odNZ#/ticket/createIndex) or ask the sales manager to add you to the whitelist.
 * > **NOTE:** Make sure that you have called the `alicloud.actiontrail.Trail` to create a single-account or multi-account trace that delivered to Log Service SLS.
 * > **NOTE:** An Alibaba cloud account can only have one running delivery history job at the same time.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = alicloud.getRegions({
 *     current: true,
 * });
 * const exampleGetAccount = alicloud.getAccount({});
 * const exampleProject = new alicloud.log.Project("example", {
 *     projectName: `${name}-${_default.result}`,
 *     description: "tf actiontrail example",
 * });
 * const exampleTrail = new alicloud.actiontrail.Trail("example", {
 *     trailName: `${name}-${_default.result}`,
 *     slsProjectArn: pulumi.all([example, exampleGetAccount, exampleProject&#46;name])&#46;apply(([example, exampleGetAccount, name]) => `acs:log:${example&#46;regions?&#46;[0]?.id}:${exampleGetAccount.id}:project/${name}`),
 * });
 * const exampleHistoryDeliveryJob = new alicloud.actiontrail.HistoryDeliveryJob("example", {trailName: exampleTrail.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.get_regions(current=True)
 * example_get_account = alicloud.get_account()
 * example_project = alicloud.log.Project("example",
 *     project_name=f"{name}-{default['result']}",
 *     description="tf actiontrail example")
 * example_trail = alicloud.actiontrail.Trail("example",
 *     trail_name=f"{name}-{default['result']}",
 *     sls_project_arn=example_project.name.apply(lambda name: f"acs:log:{example.regions[0].id}:{example_get_account.id}:project/{name}"))
 * example_history_delivery_job = alicloud.actiontrail.HistoryDeliveryJob("example", trail_name=example_trail.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var exampleGetAccount = AliCloud.GetAccount.Invoke();
 *     var exampleProject = new AliCloud.Log.Project("example", new()
 *     {
 *         ProjectName = $"{name}-{@default.Result}",
 *         Description = "tf actiontrail example",
 *     });
 *     var exampleTrail = new AliCloud.ActionTrail.Trail("example", new()
 *     {
 *         TrailName = $"{name}-{@default.Result}",
 *         SlsProjectArn = Output.Tuple(example, exampleGetAccount, exampleProject.Name).Apply(values =>
 *         {
 *             var example = values.Item1;
 *             var exampleGetAccount = values.Item2;
 *             var name = values.Item3;
 *             return $"acs:log:{example.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}:{exampleGetAccount.Apply(getAccountResult => getAccountResult.Id)}:project/{name}";
 *         }),
 *     });
 *     var exampleHistoryDeliveryJob = new AliCloud.ActionTrail.HistoryDeliveryJob("example", new()
 *     {
 *         TrailName = exampleTrail.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetAccount, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleProject, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			ProjectName: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Description: pulumi.String("tf actiontrail example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTrail, err := actiontrail.NewTrail(ctx, "example", &actiontrail.TrailArgs{
 * 			TrailName: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			SlsProjectArn: exampleProject.Name.ApplyT(func(name string) (string, error) {
 * 				return fmt.Sprintf("acs:log:%v:%v:project/%v", example.Regions[0].Id, exampleGetAccount.Id, name), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = actiontrail.NewHistoryDeliveryJob(ctx, "example", &actiontrail.HistoryDeliveryJobArgs{
 * 			TrailName: exampleTrail.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.actiontrail.Trail;
 * import com.pulumi.alicloud.actiontrail.TrailArgs;
 * import com.pulumi.alicloud.actiontrail.HistoryDeliveryJob;
 * import com.pulumi.alicloud.actiontrail.HistoryDeliveryJobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var example = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         final var exampleGetAccount = AlicloudFunctions.getAccount();
 *         var exampleProject = new Project("exampleProject", ProjectArgs.builder()
 *             .projectName(String.format("%s-%s", name,default_.result()))
 *             .description("tf actiontrail example")
 *             .build());
 *         var exampleTrail = new Trail("exampleTrail", TrailArgs.builder()
 *             .trailName(String.format("%s-%s", name,default_.result()))
 *             .slsProjectArn(exampleProject.name().applyValue(name -> String.format("acs:log:%s:%s:project/%s", example.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()),exampleGetAccount.applyValue(getAccountResult -> getAccountResult.id()),name)))
 *             .build());
 *         var exampleHistoryDeliveryJob = new HistoryDeliveryJob("exampleHistoryDeliveryJob", HistoryDeliveryJobArgs.builder()
 *             .trailName(exampleTrail.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   exampleProject:
 *     type: alicloud:log:Project
 *     name: example
 *     properties:
 *       projectName: ${name}-${default.result}
 *       description: tf actiontrail example
 *   exampleTrail:
 *     type: alicloud:actiontrail:Trail
 *     name: example
 *     properties:
 *       trailName: ${name}-${default.result}
 *       slsProjectArn: acs:log:${example.regions[0].id}:${exampleGetAccount.id}:project/${exampleProject.name}
 *   exampleHistoryDeliveryJob:
 *     type: alicloud:actiontrail:HistoryDeliveryJob
 *     name: example
 *     properties:
 *       trailName: ${exampleTrail.id}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 *   exampleGetAccount:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Actiontrail History Delivery Job can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:actiontrail/historyDeliveryJob:HistoryDeliveryJob example <id>
 * ```
 * @property trailName The name of the trail for which you want to create a historical event delivery task.
 */
public data class HistoryDeliveryJobArgs(
    public val trailName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.actiontrail.HistoryDeliveryJobArgs> {
    override fun toJava(): com.pulumi.alicloud.actiontrail.HistoryDeliveryJobArgs =
        com.pulumi.alicloud.actiontrail.HistoryDeliveryJobArgs.builder()
            .trailName(trailName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HistoryDeliveryJobArgs].
 */
@PulumiTagMarker
public class HistoryDeliveryJobArgsBuilder internal constructor() {
    private var trailName: Output<String>? = null

    /**
     * @param value The name of the trail for which you want to create a historical event delivery task.
     */
    @JvmName("hrdxioagvrwiybef")
    public suspend fun trailName(`value`: Output<String>) {
        this.trailName = value
    }

    /**
     * @param value The name of the trail for which you want to create a historical event delivery task.
     */
    @JvmName("fhvasyrhpgpcuxhx")
    public suspend fun trailName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trailName = mapped
    }

    internal fun build(): HistoryDeliveryJobArgs = HistoryDeliveryJobArgs(
        trailName = trailName,
    )
}
