@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Trail].
 */
@PulumiTagMarker
public class TrailResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrailArgs = TrailArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrailArgsBuilder.() -> Unit) {
        val builder = TrailArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Trail {
        val builtJavaResource = com.pulumi.alicloud.actiontrail.Trail(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Trail(builtJavaResource)
    }
}

/**
 * Provides a ActionTrail Trail resource. For information about alicloud actiontrail trail and how to use it, see [What is Resource Alicloud ActionTrail Trail](https://www.alibabacloud.com/help/en/actiontrail/latest/api-actiontrail-2020-07-06-createtrail).
 * > **NOTE:** Available since v1.95.0.
 * > **NOTE:** You can create a trail to deliver events to Log Service, Object Storage Service (OSS), or both. Before you call this operation to create a trail, make sure that the following requirements are met.
 * - Deliver events to Log Service: A project is created in Log Service.
 * - Deliver events to OSS: A bucket is created in OSS.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = alicloud.getRegions({
 *     current: true,
 * });
 * const exampleGetAccount = alicloud.getAccount({});
 * const exampleProject = new alicloud.log.Project("example", {
 *     projectName: `${name}-${_default.result}`,
 *     description: "tf actiontrail example",
 * });
 * const exampleGetRoles = alicloud.ram.getRoles({
 *     nameRegex: "AliyunServiceRoleForActionTrail",
 * });
 * const exampleTrail = new alicloud.actiontrail.Trail("example", {
 *     trailName: name,
 *     slsWriteRoleArn: exampleGetRoles.then(exampleGetRoles => exampleGetRoles.roles?.[0]?.arn),
 *     slsProjectArn: pulumi.all([example, exampleGetAccount, exampleProject&#46;name])&#46;apply(([example, exampleGetAccount, name]) => `acs:log:${example&#46;regions?&#46;[0]?.id}:${exampleGetAccount.id}:project/${name}`),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.get_regions(current=True)
 * example_get_account = alicloud.get_account()
 * example_project = alicloud.log.Project("example",
 *     project_name=f"{name}-{default['result']}",
 *     description="tf actiontrail example")
 * example_get_roles = alicloud.ram.get_roles(name_regex="AliyunServiceRoleForActionTrail")
 * example_trail = alicloud.actiontrail.Trail("example",
 *     trail_name=name,
 *     sls_write_role_arn=example_get_roles.roles[0].arn,
 *     sls_project_arn=example_project.name.apply(lambda name: f"acs:log:{example.regions[0].id}:{example_get_account.id}:project/{name}"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var exampleGetAccount = AliCloud.GetAccount.Invoke();
 *     var exampleProject = new AliCloud.Log.Project("example", new()
 *     {
 *         ProjectName = $"{name}-{@default.Result}",
 *         Description = "tf actiontrail example",
 *     });
 *     var exampleGetRoles = AliCloud.Ram.GetRoles.Invoke(new()
 *     {
 *         NameRegex = "AliyunServiceRoleForActionTrail",
 *     });
 *     var exampleTrail = new AliCloud.ActionTrail.Trail("example", new()
 *     {
 *         TrailName = name,
 *         SlsWriteRoleArn = exampleGetRoles.Apply(getRolesResult => getRolesResult.Roles[0]?.Arn),
 *         SlsProjectArn = Output.Tuple(example, exampleGetAccount, exampleProject.Name).Apply(values =>
 *         {
 *             var example = values.Item1;
 *             var exampleGetAccount = values.Item2;
 *             var name = values.Item3;
 *             return $"acs:log:{example.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}:{exampleGetAccount.Apply(getAccountResult => getAccountResult.Id)}:project/{name}";
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetAccount, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleProject, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			ProjectName: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Description: pulumi.String("tf actiontrail example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetRoles, err := ram.GetRoles(ctx, &ram.GetRolesArgs{
 * 			NameRegex: pulumi.StringRef("AliyunServiceRoleForActionTrail"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = actiontrail.NewTrail(ctx, "example", &actiontrail.TrailArgs{
 * 			TrailName:       pulumi.String(name),
 * 			SlsWriteRoleArn: pulumi.String(exampleGetRoles.Roles[0].Arn),
 * 			SlsProjectArn: exampleProject.Name.ApplyT(func(name string) (string, error) {
 * 				return fmt.Sprintf("acs:log:%v:%v:project/%v", example.Regions[0].Id, exampleGetAccount.Id, name), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.ram.RamFunctions;
 * import com.pulumi.alicloud.ram.inputs.GetRolesArgs;
 * import com.pulumi.alicloud.actiontrail.Trail;
 * import com.pulumi.alicloud.actiontrail.TrailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var example = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         final var exampleGetAccount = AlicloudFunctions.getAccount();
 *         var exampleProject = new Project("exampleProject", ProjectArgs.builder()
 *             .projectName(String.format("%s-%s", name,default_.result()))
 *             .description("tf actiontrail example")
 *             .build());
 *         final var exampleGetRoles = RamFunctions.getRoles(GetRolesArgs.builder()
 *             .nameRegex("AliyunServiceRoleForActionTrail")
 *             .build());
 *         var exampleTrail = new Trail("exampleTrail", TrailArgs.builder()
 *             .trailName(name)
 *             .slsWriteRoleArn(exampleGetRoles.applyValue(getRolesResult -> getRolesResult.roles()[0].arn()))
 *             .slsProjectArn(exampleProject.name().applyValue(name -> String.format("acs:log:%s:%s:project/%s", example.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()),exampleGetAccount.applyValue(getAccountResult -> getAccountResult.id()),name)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   exampleProject:
 *     type: alicloud:log:Project
 *     name: example
 *     properties:
 *       projectName: ${name}-${default.result}
 *       description: tf actiontrail example
 *   exampleTrail:
 *     type: alicloud:actiontrail:Trail
 *     name: example
 *     properties:
 *       trailName: ${name}
 *       slsWriteRoleArn: ${exampleGetRoles.roles[0].arn}
 *       slsProjectArn: acs:log:${example.regions[0].id}:${exampleGetAccount.id}:project/${exampleProject.name}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 *   exampleGetAccount:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 *   exampleGetRoles:
 *     fn::invoke:
 *       Function: alicloud:ram:getRoles
 *       Arguments:
 *         nameRegex: AliyunServiceRoleForActionTrail
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Action trail can be imported using the id or trail_name, e.g.
 * ```sh
 * $ pulumi import alicloud:actiontrail/trail:Trail default abc12345678
 * ```
 */
public class Trail internal constructor(
    override val javaResource: com.pulumi.alicloud.actiontrail.Trail,
) : KotlinCustomResource(javaResource, TrailMapper) {
    /**
     * Indicates whether the event is a read or a write event. Valid values: `Read`, `Write`, and `All`. Default to `Write`.
     */
    public val eventRw: Output<String>?
        get() = javaResource.eventRw().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether to create a multi-account trail. Valid values:`true`: Create a multi-account trail.`false`: Create a single-account trail. It is the default value.
     */
    public val isOrganizationTrail: Output<Boolean>?
        get() = javaResource.isOrganizationTrail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field `mns_topic_arn` has been deprecated from version 1.118.0.
     */
    @Deprecated(
        message = """
  Field 'mns_topic_arn' has been deprecated from version 1.118.0
  """,
    )
    public val mnsTopicArn: Output<String>?
        get() = javaResource.mnsTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field `name` has been deprecated from version 1.95.0. Use `trail_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.95.0. Use 'trail_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The OSS bucket to which the trail delivers logs. Ensure that this is an existing OSS bucket.
     */
    public val ossBucketName: Output<String>?
        get() = javaResource.ossBucketName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The prefix of the specified OSS bucket name. This parameter can be left empty.
     */
    public val ossKeyPrefix: Output<String>?
        get() = javaResource.ossKeyPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique ARN of the Oss role.
     */
    public val ossWriteRoleArn: Output<String>?
        get() = javaResource.ossWriteRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field `name` has been deprecated from version 1.118.0.
     */
    @Deprecated(
        message = """
  Field 'role_name' has been deprecated from version 1.118.0
  """,
    )
    public val roleName: Output<String>
        get() = javaResource.roleName().applyValue({ args0 -> args0 })

    /**
     * The unique ARN of the Log Service project. Ensure that `sls_project_arn` is valid .
     */
    public val slsProjectArn: Output<String>?
        get() = javaResource.slsProjectArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique ARN of the Log Service role.
     */
    public val slsWriteRoleArn: Output<String>
        get() = javaResource.slsWriteRoleArn().applyValue({ args0 -> args0 })

    /**
     * The status of ActionTrail Trail. After creation, tracking is turned on by default, and you can set the status value to `Disable` to turn off tracking. Valid values: `Enable`, `Disable`. Default to `Enable`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the trail to be created, which must be unique for an account.
     */
    public val trailName: Output<String>
        get() = javaResource.trailName().applyValue({ args0 -> args0 })

    /**
     * The regions to which the trail is applied. Default to `All`.
     */
    public val trailRegion: Output<String>
        get() = javaResource.trailRegion().applyValue({ args0 -> args0 })
}

public object TrailMapper : ResourceMapper<Trail> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.actiontrail.Trail::class == javaResource::class

    override fun map(javaResource: Resource): Trail = Trail(
        javaResource as
            com.pulumi.alicloud.actiontrail.Trail,
    )
}

/**
 * @see [Trail].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Trail].
 */
public suspend fun trail(name: String, block: suspend TrailResourceBuilder.() -> Unit): Trail {
    val builder = TrailResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Trail].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trail(name: String): Trail {
    val builder = TrailResourceBuilder()
    builder.name(name)
    return builder.build()
}
