@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin

import com.pulumi.alicloud.actiontrail.TrailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ActionTrail Trail resource. For information about alicloud actiontrail trail and how to use it, see [What is Resource Alicloud ActionTrail Trail](https://www.alibabacloud.com/help/en/actiontrail/latest/api-actiontrail-2020-07-06-createtrail).
 * > **NOTE:** Available since v1.95.0.
 * > **NOTE:** You can create a trail to deliver events to Log Service, Object Storage Service (OSS), or both. Before you call this operation to create a trail, make sure that the following requirements are met.
 * - Deliver events to Log Service: A project is created in Log Service.
 * - Deliver events to OSS: A bucket is created in OSS.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = alicloud.getRegions({
 *     current: true,
 * });
 * const exampleGetAccount = alicloud.getAccount({});
 * const exampleProject = new alicloud.log.Project("example", {
 *     projectName: `${name}-${_default.result}`,
 *     description: "tf actiontrail example",
 * });
 * const exampleGetRoles = alicloud.ram.getRoles({
 *     nameRegex: "AliyunServiceRoleForActionTrail",
 * });
 * const exampleTrail = new alicloud.actiontrail.Trail("example", {
 *     trailName: name,
 *     slsWriteRoleArn: exampleGetRoles.then(exampleGetRoles => exampleGetRoles.roles?.[0]?.arn),
 *     slsProjectArn: pulumi.all([example, exampleGetAccount, exampleProject&#46;name])&#46;apply(([example, exampleGetAccount, name]) => `acs:log:${example&#46;regions?&#46;[0]?.id}:${exampleGetAccount.id}:project/${name}`),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.get_regions(current=True)
 * example_get_account = alicloud.get_account()
 * example_project = alicloud.log.Project("example",
 *     project_name=f"{name}-{default['result']}",
 *     description="tf actiontrail example")
 * example_get_roles = alicloud.ram.get_roles(name_regex="AliyunServiceRoleForActionTrail")
 * example_trail = alicloud.actiontrail.Trail("example",
 *     trail_name=name,
 *     sls_write_role_arn=example_get_roles.roles[0].arn,
 *     sls_project_arn=example_project.name.apply(lambda name: f"acs:log:{example.regions[0].id}:{example_get_account.id}:project/{name}"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var exampleGetAccount = AliCloud.GetAccount.Invoke();
 *     var exampleProject = new AliCloud.Log.Project("example", new()
 *     {
 *         ProjectName = $"{name}-{@default.Result}",
 *         Description = "tf actiontrail example",
 *     });
 *     var exampleGetRoles = AliCloud.Ram.GetRoles.Invoke(new()
 *     {
 *         NameRegex = "AliyunServiceRoleForActionTrail",
 *     });
 *     var exampleTrail = new AliCloud.ActionTrail.Trail("example", new()
 *     {
 *         TrailName = name,
 *         SlsWriteRoleArn = exampleGetRoles.Apply(getRolesResult => getRolesResult.Roles[0]?.Arn),
 *         SlsProjectArn = Output.Tuple(example, exampleGetAccount, exampleProject.Name).Apply(values =>
 *         {
 *             var example = values.Item1;
 *             var exampleGetAccount = values.Item2;
 *             var name = values.Item3;
 *             return $"acs:log:{example.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}:{exampleGetAccount.Apply(getAccountResult => getAccountResult.Id)}:project/{name}";
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ram"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetAccount, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleProject, err := log.NewProject(ctx, "example", &log.ProjectArgs{
 * 			ProjectName: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 			Description: pulumi.String("tf actiontrail example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetRoles, err := ram.GetRoles(ctx, &ram.GetRolesArgs{
 * 			NameRegex: pulumi.StringRef("AliyunServiceRoleForActionTrail"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = actiontrail.NewTrail(ctx, "example", &actiontrail.TrailArgs{
 * 			TrailName:       pulumi.String(name),
 * 			SlsWriteRoleArn: pulumi.String(exampleGetRoles.Roles[0].Arn),
 * 			SlsProjectArn: exampleProject.Name.ApplyT(func(name string) (string, error) {
 * 				return fmt.Sprintf("acs:log:%v:%v:project/%v", example.Regions[0].Id, exampleGetAccount.Id, name), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.ram.RamFunctions;
 * import com.pulumi.alicloud.ram.inputs.GetRolesArgs;
 * import com.pulumi.alicloud.actiontrail.Trail;
 * import com.pulumi.alicloud.actiontrail.TrailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var example = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         final var exampleGetAccount = AlicloudFunctions.getAccount();
 *         var exampleProject = new Project("exampleProject", ProjectArgs.builder()
 *             .projectName(String.format("%s-%s", name,default_.result()))
 *             .description("tf actiontrail example")
 *             .build());
 *         final var exampleGetRoles = RamFunctions.getRoles(GetRolesArgs.builder()
 *             .nameRegex("AliyunServiceRoleForActionTrail")
 *             .build());
 *         var exampleTrail = new Trail("exampleTrail", TrailArgs.builder()
 *             .trailName(name)
 *             .slsWriteRoleArn(exampleGetRoles.applyValue(getRolesResult -> getRolesResult.roles()[0].arn()))
 *             .slsProjectArn(exampleProject.name().applyValue(name -> String.format("acs:log:%s:%s:project/%s", example.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()),exampleGetAccount.applyValue(getAccountResult -> getAccountResult.id()),name)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   exampleProject:
 *     type: alicloud:log:Project
 *     name: example
 *     properties:
 *       projectName: ${name}-${default.result}
 *       description: tf actiontrail example
 *   exampleTrail:
 *     type: alicloud:actiontrail:Trail
 *     name: example
 *     properties:
 *       trailName: ${name}
 *       slsWriteRoleArn: ${exampleGetRoles.roles[0].arn}
 *       slsProjectArn: acs:log:${example.regions[0].id}:${exampleGetAccount.id}:project/${exampleProject.name}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 *   exampleGetAccount:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 *   exampleGetRoles:
 *     fn::invoke:
 *       Function: alicloud:ram:getRoles
 *       Arguments:
 *         nameRegex: AliyunServiceRoleForActionTrail
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Action trail can be imported using the id or trail_name, e.g.
 * ```sh
 * $ pulumi import alicloud:actiontrail/trail:Trail default abc12345678
 * ```
 * @property eventRw Indicates whether the event is a read or a write event. Valid values: `Read`, `Write`, and `All`. Default to `Write`.
 * @property isOrganizationTrail Specifies whether to create a multi-account trail. Valid values:`true`: Create a multi-account trail.`false`: Create a single-account trail. It is the default value.
 * @property mnsTopicArn Field `mns_topic_arn` has been deprecated from version 1.118.0.
 * @property name Field `name` has been deprecated from version 1.95.0. Use `trail_name` instead.
 * @property ossBucketName The OSS bucket to which the trail delivers logs. Ensure that this is an existing OSS bucket.
 * @property ossKeyPrefix The prefix of the specified OSS bucket name. This parameter can be left empty.
 * @property ossWriteRoleArn The unique ARN of the Oss role.
 * @property roleName Field `name` has been deprecated from version 1.118.0.
 * @property slsProjectArn The unique ARN of the Log Service project. Ensure that `sls_project_arn` is valid .
 * @property slsWriteRoleArn The unique ARN of the Log Service role.
 * @property status The status of ActionTrail Trail. After creation, tracking is turned on by default, and you can set the status value to `Disable` to turn off tracking. Valid values: `Enable`, `Disable`. Default to `Enable`.
 * @property trailName The name of the trail to be created, which must be unique for an account.
 * @property trailRegion The regions to which the trail is applied. Default to `All`.
 */
public data class TrailArgs(
    public val eventRw: Output<String>? = null,
    public val isOrganizationTrail: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'mns_topic_arn' has been deprecated from version 1.118.0
  """,
    )
    public val mnsTopicArn: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.95.0. Use 'trail_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val ossBucketName: Output<String>? = null,
    public val ossKeyPrefix: Output<String>? = null,
    public val ossWriteRoleArn: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'role_name' has been deprecated from version 1.118.0
  """,
    )
    public val roleName: Output<String>? = null,
    public val slsProjectArn: Output<String>? = null,
    public val slsWriteRoleArn: Output<String>? = null,
    public val status: Output<String>? = null,
    public val trailName: Output<String>? = null,
    public val trailRegion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.actiontrail.TrailArgs> {
    override fun toJava(): com.pulumi.alicloud.actiontrail.TrailArgs =
        com.pulumi.alicloud.actiontrail.TrailArgs.builder()
            .eventRw(eventRw?.applyValue({ args0 -> args0 }))
            .isOrganizationTrail(isOrganizationTrail?.applyValue({ args0 -> args0 }))
            .mnsTopicArn(mnsTopicArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ossBucketName(ossBucketName?.applyValue({ args0 -> args0 }))
            .ossKeyPrefix(ossKeyPrefix?.applyValue({ args0 -> args0 }))
            .ossWriteRoleArn(ossWriteRoleArn?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .slsProjectArn(slsProjectArn?.applyValue({ args0 -> args0 }))
            .slsWriteRoleArn(slsWriteRoleArn?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .trailName(trailName?.applyValue({ args0 -> args0 }))
            .trailRegion(trailRegion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrailArgs].
 */
@PulumiTagMarker
public class TrailArgsBuilder internal constructor() {
    private var eventRw: Output<String>? = null

    private var isOrganizationTrail: Output<Boolean>? = null

    private var mnsTopicArn: Output<String>? = null

    private var name: Output<String>? = null

    private var ossBucketName: Output<String>? = null

    private var ossKeyPrefix: Output<String>? = null

    private var ossWriteRoleArn: Output<String>? = null

    private var roleName: Output<String>? = null

    private var slsProjectArn: Output<String>? = null

    private var slsWriteRoleArn: Output<String>? = null

    private var status: Output<String>? = null

    private var trailName: Output<String>? = null

    private var trailRegion: Output<String>? = null

    /**
     * @param value Indicates whether the event is a read or a write event. Valid values: `Read`, `Write`, and `All`. Default to `Write`.
     */
    @JvmName("mfxlnmqyrdoypbjs")
    public suspend fun eventRw(`value`: Output<String>) {
        this.eventRw = value
    }

    /**
     * @param value Specifies whether to create a multi-account trail. Valid values:`true`: Create a multi-account trail.`false`: Create a single-account trail. It is the default value.
     */
    @JvmName("ynewdaofqqykqqwi")
    public suspend fun isOrganizationTrail(`value`: Output<Boolean>) {
        this.isOrganizationTrail = value
    }

    /**
     * @param value Field `mns_topic_arn` has been deprecated from version 1.118.0.
     */
    @Deprecated(
        message = """
  Field 'mns_topic_arn' has been deprecated from version 1.118.0
  """,
    )
    @JvmName("aaolhnokesueseyf")
    public suspend fun mnsTopicArn(`value`: Output<String>) {
        this.mnsTopicArn = value
    }

    /**
     * @param value Field `name` has been deprecated from version 1.95.0. Use `trail_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.95.0. Use 'trail_name' instead.
  """,
    )
    @JvmName("kglgtkblrrvwjxmn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The OSS bucket to which the trail delivers logs. Ensure that this is an existing OSS bucket.
     */
    @JvmName("ngbbumlxctsxfvgt")
    public suspend fun ossBucketName(`value`: Output<String>) {
        this.ossBucketName = value
    }

    /**
     * @param value The prefix of the specified OSS bucket name. This parameter can be left empty.
     */
    @JvmName("ainuxeqqnvqsmmyp")
    public suspend fun ossKeyPrefix(`value`: Output<String>) {
        this.ossKeyPrefix = value
    }

    /**
     * @param value The unique ARN of the Oss role.
     */
    @JvmName("lihhmjhuyubursve")
    public suspend fun ossWriteRoleArn(`value`: Output<String>) {
        this.ossWriteRoleArn = value
    }

    /**
     * @param value Field `name` has been deprecated from version 1.118.0.
     */
    @Deprecated(
        message = """
  Field 'role_name' has been deprecated from version 1.118.0
  """,
    )
    @JvmName("mopejlecynpojods")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The unique ARN of the Log Service project. Ensure that `sls_project_arn` is valid .
     */
    @JvmName("imphhifxqtbjriwy")
    public suspend fun slsProjectArn(`value`: Output<String>) {
        this.slsProjectArn = value
    }

    /**
     * @param value The unique ARN of the Log Service role.
     */
    @JvmName("uskgvamrpsetolfk")
    public suspend fun slsWriteRoleArn(`value`: Output<String>) {
        this.slsWriteRoleArn = value
    }

    /**
     * @param value The status of ActionTrail Trail. After creation, tracking is turned on by default, and you can set the status value to `Disable` to turn off tracking. Valid values: `Enable`, `Disable`. Default to `Enable`.
     */
    @JvmName("uxfhaieupofciybg")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the trail to be created, which must be unique for an account.
     */
    @JvmName("igueanprojrpjfwp")
    public suspend fun trailName(`value`: Output<String>) {
        this.trailName = value
    }

    /**
     * @param value The regions to which the trail is applied. Default to `All`.
     */
    @JvmName("pdyifnlubswhsxkd")
    public suspend fun trailRegion(`value`: Output<String>) {
        this.trailRegion = value
    }

    /**
     * @param value Indicates whether the event is a read or a write event. Valid values: `Read`, `Write`, and `All`. Default to `Write`.
     */
    @JvmName("lwjffpaebxekcgxb")
    public suspend fun eventRw(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventRw = mapped
    }

    /**
     * @param value Specifies whether to create a multi-account trail. Valid values:`true`: Create a multi-account trail.`false`: Create a single-account trail. It is the default value.
     */
    @JvmName("ftodwdlqbpvflrbd")
    public suspend fun isOrganizationTrail(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOrganizationTrail = mapped
    }

    /**
     * @param value Field `mns_topic_arn` has been deprecated from version 1.118.0.
     */
    @Deprecated(
        message = """
  Field 'mns_topic_arn' has been deprecated from version 1.118.0
  """,
    )
    @JvmName("cbhlscpprqmotwom")
    public suspend fun mnsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mnsTopicArn = mapped
    }

    /**
     * @param value Field `name` has been deprecated from version 1.95.0. Use `trail_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.95.0. Use 'trail_name' instead.
  """,
    )
    @JvmName("gwajfdwpombqwfcc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The OSS bucket to which the trail delivers logs. Ensure that this is an existing OSS bucket.
     */
    @JvmName("ovqpjdqoqsmddmwe")
    public suspend fun ossBucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucketName = mapped
    }

    /**
     * @param value The prefix of the specified OSS bucket name. This parameter can be left empty.
     */
    @JvmName("twfkqrnuilkyvluv")
    public suspend fun ossKeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossKeyPrefix = mapped
    }

    /**
     * @param value The unique ARN of the Oss role.
     */
    @JvmName("eftekptxaxefgiav")
    public suspend fun ossWriteRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossWriteRoleArn = mapped
    }

    /**
     * @param value Field `name` has been deprecated from version 1.118.0.
     */
    @Deprecated(
        message = """
  Field 'role_name' has been deprecated from version 1.118.0
  """,
    )
    @JvmName("gywarcmljvsioqxw")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value The unique ARN of the Log Service project. Ensure that `sls_project_arn` is valid .
     */
    @JvmName("jvcihpbfbxxbvjlq")
    public suspend fun slsProjectArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsProjectArn = mapped
    }

    /**
     * @param value The unique ARN of the Log Service role.
     */
    @JvmName("vchjeysjmifboisr")
    public suspend fun slsWriteRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsWriteRoleArn = mapped
    }

    /**
     * @param value The status of ActionTrail Trail. After creation, tracking is turned on by default, and you can set the status value to `Disable` to turn off tracking. Valid values: `Enable`, `Disable`. Default to `Enable`.
     */
    @JvmName("xcvpftronyyfoitt")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The name of the trail to be created, which must be unique for an account.
     */
    @JvmName("suwvhplovmpudhgx")
    public suspend fun trailName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trailName = mapped
    }

    /**
     * @param value The regions to which the trail is applied. Default to `All`.
     */
    @JvmName("kghgldjtcvrqfvwv")
    public suspend fun trailRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trailRegion = mapped
    }

    internal fun build(): TrailArgs = TrailArgs(
        eventRw = eventRw,
        isOrganizationTrail = isOrganizationTrail,
        mnsTopicArn = mnsTopicArn,
        name = name,
        ossBucketName = ossBucketName,
        ossKeyPrefix = ossKeyPrefix,
        ossWriteRoleArn = ossWriteRoleArn,
        roleName = roleName,
        slsProjectArn = slsProjectArn,
        slsWriteRoleArn = slsWriteRoleArn,
        status = status,
        trailName = trailName,
        trailRegion = trailRegion,
    )
}
