@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TrailDeprecated].
 */
@PulumiTagMarker
@Deprecated(
    message = """
Resource renamed to `Trail`
""",
)
public class TrailDeprecatedResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrailDeprecatedArgs = TrailDeprecatedArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrailDeprecatedArgsBuilder.() -> Unit) {
        val builder = TrailDeprecatedArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrailDeprecated {
        val builtJavaResource = com.pulumi.alicloud.actiontrail.TrailDeprecated(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrailDeprecated(builtJavaResource)
    }
}

/**
 * > **DEPRECATED:**  This resource has been renamed to alicloud.actiontrail.Trail from version 1.95.0.
 * Provides a new resource to manage [Action Trail](https://www.alibabacloud.com/help/doc-detail/28804.htm).
 * > **NOTE:** Available in 1.35.0+
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new action trail.
 * const foo = new alicloud.actiontrail.TrailDeprecated("foo", {
 *     name: "action-trail",
 *     eventRw: "Write-test",
 *     ossBucketName: bucket.id,
 *     roleName: attach.roleName,
 *     ossKeyPrefix: "at-product-account-audit-B",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new action trail.
 * foo = alicloud.actiontrail.TrailDeprecated("foo",
 *     name="action-trail",
 *     event_rw="Write-test",
 *     oss_bucket_name=bucket["id"],
 *     role_name=attach["roleName"],
 *     oss_key_prefix="at-product-account-audit-B")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new action trail.
 *     var foo = new AliCloud.ActionTrail.TrailDeprecated("foo", new()
 *     {
 *         Name = "action-trail",
 *         EventRw = "Write-test",
 *         OssBucketName = bucket.Id,
 *         RoleName = attach.RoleName,
 *         OssKeyPrefix = "at-product-account-audit-B",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new action trail.
 * 		_, err := actiontrail.NewTrailDeprecated(ctx, "foo", &actiontrail.TrailDeprecatedArgs{
 * 			Name:          pulumi.String("action-trail"),
 * 			EventRw:       pulumi.String("Write-test"),
 * 			OssBucketName: pulumi.Any(bucket.Id),
 * 			RoleName:      pulumi.Any(attach.RoleName),
 * 			OssKeyPrefix:  pulumi.String("at-product-account-audit-B"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.actiontrail.TrailDeprecated;
 * import com.pulumi.alicloud.actiontrail.TrailDeprecatedArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new action trail.
 *         var foo = new TrailDeprecated("foo", TrailDeprecatedArgs.builder()
 *             .name("action-trail")
 *             .eventRw("Write-test")
 *             .ossBucketName(bucket.id())
 *             .roleName(attach.roleName())
 *             .ossKeyPrefix("at-product-account-audit-B")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new action trail.
 *   foo:
 *     type: alicloud:actiontrail:TrailDeprecated
 *     properties:
 *       name: action-trail
 *       eventRw: Write-test
 *       ossBucketName: ${bucket.id}
 *       roleName: ${attach.roleName}
 *       ossKeyPrefix: at-product-account-audit-B
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Action trail can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:actiontrail/trailDeprecated:TrailDeprecated foo abc12345678
 * ```
 */
@Deprecated(
    message = """
Resource renamed to `Trail`
""",
)
public class TrailDeprecated internal constructor(
    override val javaResource: com.pulumi.alicloud.actiontrail.TrailDeprecated,
) : KotlinCustomResource(javaResource, TrailDeprecatedMapper) {
    /**
     * Indicates whether the event is a read or a write event. Valid values: Read, Write, and All. Default value: Write.
     */
    public val eventRw: Output<String>?
        get() = javaResource.eventRw().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val isOrganizationTrail: Output<Boolean>?
        get() = javaResource.isOrganizationTrail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Field 'mns_topic_arn' has been deprecated from version 1.118.0
  """,
    )
    public val mnsTopicArn: Output<String>?
        get() = javaResource.mnsTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the trail to be created, which must be unique for an account.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.95.0. Use 'trail_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The OSS bucket to which the trail delivers logs. Ensure that this is an existing OSS bucket.
     */
    public val ossBucketName: Output<String>?
        get() = javaResource.ossBucketName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The prefix of the specified OSS bucket name. This parameter can be left empty.
     */
    public val ossKeyPrefix: Output<String>?
        get() = javaResource.ossKeyPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val ossWriteRoleArn: Output<String>?
        get() = javaResource.ossWriteRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The RAM role in ActionTrail permitted by the user.
     */
    @Deprecated(
        message = """
  Field 'role_name' has been deprecated from version 1.118.0
  """,
    )
    public val roleName: Output<String>
        get() = javaResource.roleName().applyValue({ args0 -> args0 })

    /**
     * The unique ARN of the Log Service project.
     */
    public val slsProjectArn: Output<String>?
        get() = javaResource.slsProjectArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique ARN of the Log Service role.
     * > **NOTE:** `sls_project_arn` and `sls_write_role_arn` should be set or not set at the same time when actiontrail delivers logs.
     */
    public val slsWriteRoleArn: Output<String>
        get() = javaResource.slsWriteRoleArn().applyValue({ args0 -> args0 })

    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val trailName: Output<String>
        get() = javaResource.trailName().applyValue({ args0 -> args0 })

    public val trailRegion: Output<String>
        get() = javaResource.trailRegion().applyValue({ args0 -> args0 })
}

public object TrailDeprecatedMapper : ResourceMapper<TrailDeprecated> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.actiontrail.TrailDeprecated::class == javaResource::class

    override fun map(javaResource: Resource): TrailDeprecated = TrailDeprecated(
        javaResource as
            com.pulumi.alicloud.actiontrail.TrailDeprecated,
    )
}

/**
 * @see [TrailDeprecated].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrailDeprecated].
 */
@Deprecated(
    message = """
Resource renamed to `Trail`
""",
)
public suspend fun trailDeprecated(
    name: String,
    block: suspend TrailDeprecatedResourceBuilder.() -> Unit,
): TrailDeprecated {
    val builder = TrailDeprecatedResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrailDeprecated].
 * @param name The _unique_ name of the resulting resource.
 */
@Deprecated(
    message = """
Resource renamed to `Trail`
""",
)
public fun trailDeprecated(name: String): TrailDeprecated {
    val builder = TrailDeprecatedResourceBuilder()
    builder.name(name)
    return builder.build()
}
