@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin

import com.pulumi.alicloud.actiontrail.TrailDeprecatedArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:**  This resource has been renamed to alicloud.actiontrail.Trail from version 1.95.0.
 * Provides a new resource to manage [Action Trail](https://www.alibabacloud.com/help/doc-detail/28804.htm).
 * > **NOTE:** Available in 1.35.0+
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new action trail.
 * const foo = new alicloud.actiontrail.TrailDeprecated("foo", {
 *     name: "action-trail",
 *     eventRw: "Write-test",
 *     ossBucketName: bucket.id,
 *     roleName: attach.roleName,
 *     ossKeyPrefix: "at-product-account-audit-B",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new action trail.
 * foo = alicloud.actiontrail.TrailDeprecated("foo",
 *     name="action-trail",
 *     event_rw="Write-test",
 *     oss_bucket_name=bucket["id"],
 *     role_name=attach["roleName"],
 *     oss_key_prefix="at-product-account-audit-B")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new action trail.
 *     var foo = new AliCloud.ActionTrail.TrailDeprecated("foo", new()
 *     {
 *         Name = "action-trail",
 *         EventRw = "Write-test",
 *         OssBucketName = bucket.Id,
 *         RoleName = attach.RoleName,
 *         OssKeyPrefix = "at-product-account-audit-B",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/actiontrail"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new action trail.
 * 		_, err := actiontrail.NewTrailDeprecated(ctx, "foo", &actiontrail.TrailDeprecatedArgs{
 * 			Name:          pulumi.String("action-trail"),
 * 			EventRw:       pulumi.String("Write-test"),
 * 			OssBucketName: pulumi.Any(bucket.Id),
 * 			RoleName:      pulumi.Any(attach.RoleName),
 * 			OssKeyPrefix:  pulumi.String("at-product-account-audit-B"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.actiontrail.TrailDeprecated;
 * import com.pulumi.alicloud.actiontrail.TrailDeprecatedArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new action trail.
 *         var foo = new TrailDeprecated("foo", TrailDeprecatedArgs.builder()
 *             .name("action-trail")
 *             .eventRw("Write-test")
 *             .ossBucketName(bucket.id())
 *             .roleName(attach.roleName())
 *             .ossKeyPrefix("at-product-account-audit-B")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new action trail.
 *   foo:
 *     type: alicloud:actiontrail:TrailDeprecated
 *     properties:
 *       name: action-trail
 *       eventRw: Write-test
 *       ossBucketName: ${bucket.id}
 *       roleName: ${attach.roleName}
 *       ossKeyPrefix: at-product-account-audit-B
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Action trail can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:actiontrail/trailDeprecated:TrailDeprecated foo abc12345678
 * ```
 * @property eventRw Indicates whether the event is a read or a write event. Valid values: Read, Write, and All. Default value: Write.
 * @property isOrganizationTrail
 * @property mnsTopicArn
 * @property name The name of the trail to be created, which must be unique for an account.
 * @property ossBucketName The OSS bucket to which the trail delivers logs. Ensure that this is an existing OSS bucket.
 * @property ossKeyPrefix The prefix of the specified OSS bucket name. This parameter can be left empty.
 * @property ossWriteRoleArn
 * @property roleName The RAM role in ActionTrail permitted by the user.
 * @property slsProjectArn The unique ARN of the Log Service project.
 * @property slsWriteRoleArn The unique ARN of the Log Service role.
 * > **NOTE:** `sls_project_arn` and `sls_write_role_arn` should be set or not set at the same time when actiontrail delivers logs.
 * @property status
 * @property trailName
 * @property trailRegion
 */
public data class TrailDeprecatedArgs
@Deprecated(
    message = """
Resource renamed to `Trail`
""",
)
constructor(
    public val eventRw: Output<String>? = null,
    public val isOrganizationTrail: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field 'mns_topic_arn' has been deprecated from version 1.118.0
  """,
    )
    public val mnsTopicArn: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.95.0. Use 'trail_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val ossBucketName: Output<String>? = null,
    public val ossKeyPrefix: Output<String>? = null,
    public val ossWriteRoleArn: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'role_name' has been deprecated from version 1.118.0
  """,
    )
    public val roleName: Output<String>? = null,
    public val slsProjectArn: Output<String>? = null,
    public val slsWriteRoleArn: Output<String>? = null,
    public val status: Output<String>? = null,
    public val trailName: Output<String>? = null,
    public val trailRegion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.actiontrail.TrailDeprecatedArgs> {
    override fun toJava(): com.pulumi.alicloud.actiontrail.TrailDeprecatedArgs =
        com.pulumi.alicloud.actiontrail.TrailDeprecatedArgs.builder()
            .eventRw(eventRw?.applyValue({ args0 -> args0 }))
            .isOrganizationTrail(isOrganizationTrail?.applyValue({ args0 -> args0 }))
            .mnsTopicArn(mnsTopicArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ossBucketName(ossBucketName?.applyValue({ args0 -> args0 }))
            .ossKeyPrefix(ossKeyPrefix?.applyValue({ args0 -> args0 }))
            .ossWriteRoleArn(ossWriteRoleArn?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .slsProjectArn(slsProjectArn?.applyValue({ args0 -> args0 }))
            .slsWriteRoleArn(slsWriteRoleArn?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .trailName(trailName?.applyValue({ args0 -> args0 }))
            .trailRegion(trailRegion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrailDeprecatedArgs].
 */
@PulumiTagMarker
@Deprecated(
    message = """
Resource renamed to `Trail`
""",
)
public class TrailDeprecatedArgsBuilder internal constructor() {
    private var eventRw: Output<String>? = null

    private var isOrganizationTrail: Output<Boolean>? = null

    private var mnsTopicArn: Output<String>? = null

    private var name: Output<String>? = null

    private var ossBucketName: Output<String>? = null

    private var ossKeyPrefix: Output<String>? = null

    private var ossWriteRoleArn: Output<String>? = null

    private var roleName: Output<String>? = null

    private var slsProjectArn: Output<String>? = null

    private var slsWriteRoleArn: Output<String>? = null

    private var status: Output<String>? = null

    private var trailName: Output<String>? = null

    private var trailRegion: Output<String>? = null

    /**
     * @param value Indicates whether the event is a read or a write event. Valid values: Read, Write, and All. Default value: Write.
     */
    @JvmName("xfubpasdxpukvfxp")
    public suspend fun eventRw(`value`: Output<String>) {
        this.eventRw = value
    }

    /**
     * @param value
     */
    @JvmName("yhpcqreinrwpfjaj")
    public suspend fun isOrganizationTrail(`value`: Output<Boolean>) {
        this.isOrganizationTrail = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'mns_topic_arn' has been deprecated from version 1.118.0
  """,
    )
    @JvmName("iaqbxjeposcwarkd")
    public suspend fun mnsTopicArn(`value`: Output<String>) {
        this.mnsTopicArn = value
    }

    /**
     * @param value The name of the trail to be created, which must be unique for an account.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.95.0. Use 'trail_name' instead.
  """,
    )
    @JvmName("herclaoiuycxgefs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The OSS bucket to which the trail delivers logs. Ensure that this is an existing OSS bucket.
     */
    @JvmName("edpxarokrrlvryub")
    public suspend fun ossBucketName(`value`: Output<String>) {
        this.ossBucketName = value
    }

    /**
     * @param value The prefix of the specified OSS bucket name. This parameter can be left empty.
     */
    @JvmName("pcsvytvyujimekpl")
    public suspend fun ossKeyPrefix(`value`: Output<String>) {
        this.ossKeyPrefix = value
    }

    /**
     * @param value
     */
    @JvmName("ogofrolbmpdsfudm")
    public suspend fun ossWriteRoleArn(`value`: Output<String>) {
        this.ossWriteRoleArn = value
    }

    /**
     * @param value The RAM role in ActionTrail permitted by the user.
     */
    @Deprecated(
        message = """
  Field 'role_name' has been deprecated from version 1.118.0
  """,
    )
    @JvmName("qbsdovajgumonssd")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The unique ARN of the Log Service project.
     */
    @JvmName("odxnosvehdatylbt")
    public suspend fun slsProjectArn(`value`: Output<String>) {
        this.slsProjectArn = value
    }

    /**
     * @param value The unique ARN of the Log Service role.
     * > **NOTE:** `sls_project_arn` and `sls_write_role_arn` should be set or not set at the same time when actiontrail delivers logs.
     */
    @JvmName("oyoexernjunpeqbt")
    public suspend fun slsWriteRoleArn(`value`: Output<String>) {
        this.slsWriteRoleArn = value
    }

    /**
     * @param value
     */
    @JvmName("vbvgkpkenoamcjct")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value
     */
    @JvmName("ljgggpjnptqsvhcu")
    public suspend fun trailName(`value`: Output<String>) {
        this.trailName = value
    }

    /**
     * @param value
     */
    @JvmName("mqfkwdwarsysumrj")
    public suspend fun trailRegion(`value`: Output<String>) {
        this.trailRegion = value
    }

    /**
     * @param value Indicates whether the event is a read or a write event. Valid values: Read, Write, and All. Default value: Write.
     */
    @JvmName("nodusfkubnhpoxga")
    public suspend fun eventRw(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventRw = mapped
    }

    /**
     * @param value
     */
    @JvmName("vhaekxwkanempmyd")
    public suspend fun isOrganizationTrail(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOrganizationTrail = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Field 'mns_topic_arn' has been deprecated from version 1.118.0
  """,
    )
    @JvmName("ueuvmonamihnfkwp")
    public suspend fun mnsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mnsTopicArn = mapped
    }

    /**
     * @param value The name of the trail to be created, which must be unique for an account.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.95.0. Use 'trail_name' instead.
  """,
    )
    @JvmName("vygujumgnaqsdnjl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The OSS bucket to which the trail delivers logs. Ensure that this is an existing OSS bucket.
     */
    @JvmName("eqxxpajukkhcqiiw")
    public suspend fun ossBucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucketName = mapped
    }

    /**
     * @param value The prefix of the specified OSS bucket name. This parameter can be left empty.
     */
    @JvmName("saflxqiyfydeypty")
    public suspend fun ossKeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossKeyPrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("fasksbkttpulhbtn")
    public suspend fun ossWriteRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossWriteRoleArn = mapped
    }

    /**
     * @param value The RAM role in ActionTrail permitted by the user.
     */
    @Deprecated(
        message = """
  Field 'role_name' has been deprecated from version 1.118.0
  """,
    )
    @JvmName("psfkvuaagfqlpvpk")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value The unique ARN of the Log Service project.
     */
    @JvmName("ouyuhqjjvhokrnib")
    public suspend fun slsProjectArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsProjectArn = mapped
    }

    /**
     * @param value The unique ARN of the Log Service role.
     * > **NOTE:** `sls_project_arn` and `sls_write_role_arn` should be set or not set at the same time when actiontrail delivers logs.
     */
    @JvmName("fwjhnuhsjlgbqoeu")
    public suspend fun slsWriteRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsWriteRoleArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("odrdkrfpmiginpyq")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("isblwtqcsdpgglnh")
    public suspend fun trailName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trailName = mapped
    }

    /**
     * @param value
     */
    @JvmName("vnenpreanfdjboka")
    public suspend fun trailRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trailRegion = mapped
    }

    internal fun build(): TrailDeprecatedArgs = TrailDeprecatedArgs(
        eventRw = eventRw,
        isOrganizationTrail = isOrganizationTrail,
        mnsTopicArn = mnsTopicArn,
        name = name,
        ossBucketName = ossBucketName,
        ossKeyPrefix = ossKeyPrefix,
        ossWriteRoleArn = ossWriteRoleArn,
        roleName = roleName,
        slsProjectArn = slsProjectArn,
        slsWriteRoleArn = slsWriteRoleArn,
        status = status,
        trailName = trailName,
        trailRegion = trailRegion,
    )
}
