@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.inputs

import com.pulumi.alicloud.actiontrail.inputs.GetConsumerGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConsumerGroups.
 * @property consumerIdRegex A regex string to filter results by the consumer group id.
 * @property ids A list of ALIKAFKA Consumer Groups IDs, It is formatted to `<instance_id>:<consumer_id>`.
 * @property instanceId ID of the ALIKAFKA Instance that owns the consumer groups.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetConsumerGroupsPlainArgs(
    public val consumerIdRegex: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.actiontrail.inputs.GetConsumerGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.actiontrail.inputs.GetConsumerGroupsPlainArgs =
        com.pulumi.alicloud.actiontrail.inputs.GetConsumerGroupsPlainArgs.builder()
            .consumerIdRegex(consumerIdRegex?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConsumerGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetConsumerGroupsPlainArgsBuilder internal constructor() {
    private var consumerIdRegex: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    /**
     * @param value A regex string to filter results by the consumer group id.
     */
    @JvmName("cdyfvofspclgydld")
    public suspend fun consumerIdRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.consumerIdRegex = mapped
    }

    /**
     * @param value A list of ALIKAFKA Consumer Groups IDs, It is formatted to `<instance_id>:<consumer_id>`.
     */
    @JvmName("cojrxgpafvpjsfer")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ALIKAFKA Consumer Groups IDs, It is formatted to `<instance_id>:<consumer_id>`.
     */
    @JvmName("vqssfkeibxlhbkvl")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of the ALIKAFKA Instance that owns the consumer groups.
     */
    @JvmName("riurbvososucvloi")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("srfpbvpdfbimdejd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetConsumerGroupsPlainArgs = GetConsumerGroupsPlainArgs(
        consumerIdRegex = consumerIdRegex,
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
    )
}
