@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.inputs

import com.pulumi.alicloud.actiontrail.inputs.GetHistoryDeliveryJobsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHistoryDeliveryJobs.
 * @property enableDetails
 * @property ids A list of History Delivery Job IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the task. Valid values: `0`, `1`, `2`, `3`. `0`: The task is initializing. `1`: The task is delivering historical events. `2`: The delivery of historical events is complete. `3`: The task fails.
 */
public data class GetHistoryDeliveryJobsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.actiontrail.inputs.GetHistoryDeliveryJobsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.actiontrail.inputs.GetHistoryDeliveryJobsPlainArgs =
        com.pulumi.alicloud.actiontrail.inputs.GetHistoryDeliveryJobsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHistoryDeliveryJobsPlainArgs].
 */
@PulumiTagMarker
public class GetHistoryDeliveryJobsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: Int? = null

    /**
     * @param value
     */
    @JvmName("qlydpxrfepfwwrle")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of History Delivery Job IDs.
     */
    @JvmName("pmjtproctfovdnie")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of History Delivery Job IDs.
     */
    @JvmName("lvxdubujplosaigy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ucgmcpcxivoqkptd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the task. Valid values: `0`, `1`, `2`, `3`. `0`: The task is initializing. `1`: The task is delivering historical events. `2`: The delivery of historical events is complete. `3`: The task fails.
     */
    @JvmName("kyiiieiworikpcql")
    public suspend fun status(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetHistoryDeliveryJobsPlainArgs = GetHistoryDeliveryJobsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
