@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.inputs

import com.pulumi.alicloud.actiontrail.inputs.GetSaslAclsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSaslAcls.
 * @property aclResourceName Get results for the specified resource name.
 * @property aclResourceType Get results for the specified resource type.
 * @property instanceId ID of the ALIKAFKA Instance that owns the sasl acls.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property username Get results for the specified username.
 */
public data class GetSaslAclsPlainArgs(
    public val aclResourceName: String,
    public val aclResourceType: String,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val username: String,
) : ConvertibleToJava<com.pulumi.alicloud.actiontrail.inputs.GetSaslAclsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.actiontrail.inputs.GetSaslAclsPlainArgs =
        com.pulumi.alicloud.actiontrail.inputs.GetSaslAclsPlainArgs.builder()
            .aclResourceName(aclResourceName.let({ args0 -> args0 }))
            .aclResourceType(aclResourceType.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .username(username.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSaslAclsPlainArgs].
 */
@PulumiTagMarker
public class GetSaslAclsPlainArgsBuilder internal constructor() {
    private var aclResourceName: String? = null

    private var aclResourceType: String? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    private var username: String? = null

    /**
     * @param value Get results for the specified resource name.
     */
    @JvmName("udwyvxfuvirpfjhc")
    public suspend fun aclResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.aclResourceName = mapped
    }

    /**
     * @param value Get results for the specified resource type.
     */
    @JvmName("gipdgiowavyjfkpu")
    public suspend fun aclResourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.aclResourceType = mapped
    }

    /**
     * @param value ID of the ALIKAFKA Instance that owns the sasl acls.
     */
    @JvmName("imqtbcswhihbgooq")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("oedojujnryqyvdlg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Get results for the specified username.
     */
    @JvmName("yevqibkmmatldkcq")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.username = mapped
    }

    internal fun build(): GetSaslAclsPlainArgs = GetSaslAclsPlainArgs(
        aclResourceName = aclResourceName ?: throw PulumiNullFieldException("aclResourceName"),
        aclResourceType = aclResourceType ?: throw PulumiNullFieldException("aclResourceType"),
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
