@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.inputs

import com.pulumi.alicloud.actiontrail.inputs.GetSaslUsersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSaslUsers.
 * @property instanceId ID of the ALIKAFKA Instance that owns the sasl users.
 * @property nameRegex A regex string to filter results by the username.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetSaslUsersPlainArgs(
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.actiontrail.inputs.GetSaslUsersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.actiontrail.inputs.GetSaslUsersPlainArgs =
        com.pulumi.alicloud.actiontrail.inputs.GetSaslUsersPlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSaslUsersPlainArgs].
 */
@PulumiTagMarker
public class GetSaslUsersPlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value ID of the ALIKAFKA Instance that owns the sasl users.
     */
    @JvmName("lvdqsadtbeqcqaam")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by the username.
     */
    @JvmName("tgvlcsxmnjvbowmu")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("klfosriamqeygkwa")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetSaslUsersPlainArgs = GetSaslUsersPlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
