@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.inputs

import com.pulumi.alicloud.actiontrail.inputs.GetTopicsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTopics.
 * @property ids A list of ALIKAFKA Topics IDs, It is formatted to `<instance_id>:<topic>`.
 * @property instanceId ID of the instance.
 * @property nameRegex A regex string to filter results by the topic name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property topic A topic to filter results by the topic name.
 */
public data class GetTopicsPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val topic: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.actiontrail.inputs.GetTopicsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.actiontrail.inputs.GetTopicsPlainArgs =
        com.pulumi.alicloud.actiontrail.inputs.GetTopicsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .topic(topic?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTopicsPlainArgs].
 */
@PulumiTagMarker
public class GetTopicsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var topic: String? = null

    /**
     * @param value A list of ALIKAFKA Topics IDs, It is formatted to `<instance_id>:<topic>`.
     */
    @JvmName("csdetlhafjpabojc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ALIKAFKA Topics IDs, It is formatted to `<instance_id>:<topic>`.
     */
    @JvmName("navxnehgbfrytrvv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value ID of the instance.
     */
    @JvmName("dvadqembklqhnxeo")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by the topic name.
     */
    @JvmName("pbapsktqcnkbruot")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tcsqlvvlrhksibhw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("jacnegynrgeqqsaj")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("jktuspbdvmlgsgcg")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value A topic to filter results by the topic name.
     */
    @JvmName("ykxllnywbfaexnbp")
    public suspend fun topic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.topic = mapped
    }

    internal fun build(): GetTopicsPlainArgs = GetTopicsPlainArgs(
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        topic = topic,
    )
}
