@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.inputs

import com.pulumi.alicloud.actiontrail.inputs.GetTrailsDeprecatedPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTrailsDeprecated.
 * @property ids
 * @property includeOrganizationTrail
 * @property includeShadowTrails
 * @property nameRegex A regex string to filter results action trail name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status
 */
public data class GetTrailsDeprecatedPlainArgs(
    public val ids: List<String>? = null,
    public val includeOrganizationTrail: Boolean? = null,
    public val includeShadowTrails: Boolean? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.actiontrail.inputs.GetTrailsDeprecatedPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.actiontrail.inputs.GetTrailsDeprecatedPlainArgs =
        com.pulumi.alicloud.actiontrail.inputs.GetTrailsDeprecatedPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeOrganizationTrail(includeOrganizationTrail?.let({ args0 -> args0 }))
            .includeShadowTrails(includeShadowTrails?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrailsDeprecatedPlainArgs].
 */
@PulumiTagMarker
public class GetTrailsDeprecatedPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var includeOrganizationTrail: Boolean? = null

    private var includeShadowTrails: Boolean? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value
     */
    @JvmName("rnybckoneggpwagh")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("acloxvlrgqrbprum")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("lcayryleybuhsfyx")
    public suspend fun includeOrganizationTrail(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeOrganizationTrail = mapped
    }

    /**
     * @param value
     */
    @JvmName("fuyblqnpfvsimoay")
    public suspend fun includeShadowTrails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeShadowTrails = mapped
    }

    /**
     * @param value A regex string to filter results action trail name.
     */
    @JvmName("qavjbfxjgdkauael")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wqlcttkepudqefou")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("uvwgqaipvhsugokw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetTrailsDeprecatedPlainArgs = GetTrailsDeprecatedPlainArgs(
        ids = ids,
        includeOrganizationTrail = includeOrganizationTrail,
        includeShadowTrails = includeShadowTrails,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
