@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.inputs

import com.pulumi.alicloud.actiontrail.inputs.GetTrailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTrails.
 * @property ids A list of ActionTrail Trail IDs. It is the same as trail name.
 * @property includeOrganizationTrail Whether to show organization tracking. Default to `false`.
 * @property includeShadowTrails Whether to show shadow tracking. Default to `false`.
 * @property nameRegex A regex string to filter results by trail name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status Filter the results by status of the ActionTrail Trail. Valid values: `Disable`, `Enable`, `Fresh`.
 */
public data class GetTrailsPlainArgs(
    public val ids: List<String>? = null,
    public val includeOrganizationTrail: Boolean? = null,
    public val includeShadowTrails: Boolean? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.actiontrail.inputs.GetTrailsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.actiontrail.inputs.GetTrailsPlainArgs =
        com.pulumi.alicloud.actiontrail.inputs.GetTrailsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeOrganizationTrail(includeOrganizationTrail?.let({ args0 -> args0 }))
            .includeShadowTrails(includeShadowTrails?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrailsPlainArgs].
 */
@PulumiTagMarker
public class GetTrailsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var includeOrganizationTrail: Boolean? = null

    private var includeShadowTrails: Boolean? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of ActionTrail Trail IDs. It is the same as trail name.
     */
    @JvmName("wklbfqlchgewofvl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of ActionTrail Trail IDs. It is the same as trail name.
     */
    @JvmName("susdppqhageknxvi")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Whether to show organization tracking. Default to `false`.
     */
    @JvmName("ikbhiixmycsabuuw")
    public suspend fun includeOrganizationTrail(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeOrganizationTrail = mapped
    }

    /**
     * @param value Whether to show shadow tracking. Default to `false`.
     */
    @JvmName("msjeuvldamjenpdr")
    public suspend fun includeShadowTrails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeShadowTrails = mapped
    }

    /**
     * @param value A regex string to filter results by trail name.
     */
    @JvmName("qcoqahsskooibgwv")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ytxglnqalmwrwrsh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter the results by status of the ActionTrail Trail. Valid values: `Disable`, `Enable`, `Fresh`.
     */
    @JvmName("cebmxhpvyuxuchil")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetTrailsPlainArgs = GetTrailsPlainArgs(
        ids = ids,
        includeOrganizationTrail = includeOrganizationTrail,
        includeShadowTrails = includeShadowTrails,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
