@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property consumerId The name of the consumer group.
 * @property id The ID of the consumer group, It is formatted to `<instance_id>:<consumer_id>`.
 * @property instanceId ID of the ALIKAFKA Instance that owns the consumer groups.
 * @property remark The remark of the consumer group.
 * @property tags A mapping of tags to assign to the consumer group.
 */
public data class GetConsumerGroupsGroup(
    public val consumerId: String,
    public val id: String,
    public val instanceId: String,
    public val remark: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetConsumerGroupsGroup): GetConsumerGroupsGroup = GetConsumerGroupsGroup(
            consumerId = javaType.consumerId(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            remark = javaType.remark(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
