@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getConsumerGroups.
 * @property consumerIdRegex
 * @property consumerIds
 * @property groups A list of consumer group. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId The instance_id of the instance.
 * @property names A list of consumer group names.
 * @property outputFile
 */
public data class GetConsumerGroupsResult(
    public val consumerIdRegex: String? = null,
    public val consumerIds: List<String>,
    public val groups: List<GetConsumerGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetConsumerGroupsResult): GetConsumerGroupsResult = GetConsumerGroupsResult(
            consumerIdRegex = javaType.consumerIdRegex().map({ args0 -> args0 }).orElse(null),
            consumerIds = javaType.consumerIds().map({ args0 -> args0 }),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetConsumerGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
