@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The time when the task was created.
 * @property endTime The time when the task ended.
 * @property historyDeliveryJobId
 * @property homeRegion The home region of the trail.
 * @property id The ID of the History Delivery Job.
 * @property jobStatuses Detail status of delivery job.
 * @property startTime The time when the task started.
 * @property status The status of the task. Valid values: `0`, `1`, `2`, `3`. `0`: The task is initializing. `1`: The task is delivering historical events. `2`: The delivery of historical events is complete. `3`: The task fails.
 * @property trailName The name of the trail.
 * @property updatedTime The time when the task was updated.
 */
public data class GetHistoryDeliveryJobsJob(
    public val createTime: String,
    public val endTime: String,
    public val historyDeliveryJobId: String,
    public val homeRegion: String,
    public val id: String,
    public val jobStatuses: List<GetHistoryDeliveryJobsJobJobStatus>,
    public val startTime: String,
    public val status: Int,
    public val trailName: String,
    public val updatedTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetHistoryDeliveryJobsJob): GetHistoryDeliveryJobsJob = GetHistoryDeliveryJobsJob(
            createTime = javaType.createTime(),
            endTime = javaType.endTime(),
            historyDeliveryJobId = javaType.historyDeliveryJobId(),
            homeRegion = javaType.homeRegion(),
            id = javaType.id(),
            jobStatuses = javaType.jobStatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetHistoryDeliveryJobsJobJobStatus.Companion.toKotlin(args0)
                })
            }),
            startTime = javaType.startTime(),
            status = javaType.status(),
            trailName = javaType.trailName(),
            updatedTime = javaType.updatedTime(),
        )
    }
}
