@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHistoryDeliveryJobs.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property jobs
 * @property outputFile
 * @property status
 */
public data class GetHistoryDeliveryJobsResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val jobs: List<GetHistoryDeliveryJobsJob>,
    public val outputFile: String? = null,
    public val status: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetHistoryDeliveryJobsResult): GetHistoryDeliveryJobsResult = GetHistoryDeliveryJobsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            jobs = javaType.jobs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetHistoryDeliveryJobsJob.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
