@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property allowedLists The allowed list of the instance.
 * @property config The config the instance.
 * @property createTime The create time of the instance.
 * @property deployType The deployed type of the instance.
 * @property diskSize The disk size of the instance.
 * @property diskType The disk type of the instance. 0: efficient cloud disk , 1: SSD.
 * @property domainEndpoint The domain point of the instance.
 * @property eipMax The peak bandwidth of the instance.
 * @property endPoint The endPoint to access the instance.
 * @property expiredTime The expired time  of the instance.
 * @property id ID of the instance.
 * @property ioMax The peak value of io of the instance.
 * @property msgRetain The msg retain of the instance.
 * @property name Name of the instance.
 * @property paidType The paid type of the instance.
 * @property partitionNum (Available in 1.194.0+) The number of partitions.
 * @property saslDomainEndpoint The SASL domain point of the instance.
 * @property securityGroup The security group of the instance.
 * @property serviceStatus The current status of the instance. -1: unknown status, 0: wait deploy, 1: initializing, 2: preparing, 3 starting, 5: in service, 7: wait upgrade, 8: upgrading, 10: released, 15: freeze, 101: deploy error, 102: upgrade error.
 * @property serviceVersion The kafka openSource version of the instance.
 * @property specType The spec type of the instance.
 * @property sslDomainEndpoint The SSL domain point of the instance.
 * @property sslEndPoint The SSL end point of the instance.
 * @property tags A mapping of tags to assign to the instance.
 * @property topicQuota The max num of topic can be create of the instance.
 * @property upgradeServiceDetailInfos The UpgradeServiceDetailInfo List.
 * @property vpcId The ID of attaching VPC to instance.
 * @property vswitchId The ID of attaching vswitch to instance.
 * @property zoneId The ID of attaching zone to instance.
 */
public data class GetInstancesInstance(
    public val allowedLists: List<GetInstancesInstanceAllowedList>,
    public val config: String,
    public val createTime: String,
    public val deployType: Int,
    public val diskSize: Int,
    public val diskType: Int,
    public val domainEndpoint: String,
    public val eipMax: Int,
    public val endPoint: String,
    public val expiredTime: Int,
    public val id: String,
    public val ioMax: Int,
    public val msgRetain: Int,
    public val name: String,
    public val paidType: String,
    public val partitionNum: Int,
    public val saslDomainEndpoint: String,
    public val securityGroup: String,
    public val serviceStatus: Int,
    public val serviceVersion: String,
    public val specType: String,
    public val sslDomainEndpoint: String,
    public val sslEndPoint: String,
    public val tags: Map<String, String>? = null,
    public val topicQuota: Int,
    public val upgradeServiceDetailInfos: List<GetInstancesInstanceUpgradeServiceDetailInfo>,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            allowedLists = javaType.allowedLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetInstancesInstanceAllowedList.Companion.toKotlin(args0)
                })
            }),
            config = javaType.config(),
            createTime = javaType.createTime(),
            deployType = javaType.deployType(),
            diskSize = javaType.diskSize(),
            diskType = javaType.diskType(),
            domainEndpoint = javaType.domainEndpoint(),
            eipMax = javaType.eipMax(),
            endPoint = javaType.endPoint(),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            ioMax = javaType.ioMax(),
            msgRetain = javaType.msgRetain(),
            name = javaType.name(),
            paidType = javaType.paidType(),
            partitionNum = javaType.partitionNum(),
            saslDomainEndpoint = javaType.saslDomainEndpoint(),
            securityGroup = javaType.securityGroup(),
            serviceStatus = javaType.serviceStatus(),
            serviceVersion = javaType.serviceVersion(),
            specType = javaType.specType(),
            sslDomainEndpoint = javaType.sslDomainEndpoint(),
            sslEndPoint = javaType.sslEndPoint(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            topicQuota = javaType.topicQuota(),
            upgradeServiceDetailInfos = javaType.upgradeServiceDetailInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetInstancesInstanceUpgradeServiceDetailInfo.Companion.toKotlin(args0)
                })
            }),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
