@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property deployType The deployed type of the instance.
 * @property internetLists The internet list of the instance.
 * @property vpcLists The vpc list of the instance.
 */
public data class GetInstancesInstanceAllowedList(
    public val deployType: String,
    public val internetLists: List<GetInstancesInstanceAllowedListInternetList>,
    public val vpcLists: List<GetInstancesInstanceAllowedListVpcList>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetInstancesInstanceAllowedList): GetInstancesInstanceAllowedList = GetInstancesInstanceAllowedList(
            deployType = javaType.deployType(),
            internetLists = javaType.internetLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetInstancesInstanceAllowedListInternetList.Companion.toKotlin(args0)
                })
            }),
            vpcLists = javaType.vpcLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetInstancesInstanceAllowedListVpcList.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
