@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aclOperationType The operation type of the sasl acl.
 * @property aclResourceName Get results for the specified resource name.
 * @property aclResourcePatternType The resource pattern type of the sasl acl.
 * @property aclResourceType Get results for the specified resource type.
 * @property host The host of the sasl acl.
 * @property username Get results for the specified username.
 */
public data class GetSaslAclsAcl(
    public val aclOperationType: String,
    public val aclResourceName: String,
    public val aclResourcePatternType: String,
    public val aclResourceType: String,
    public val host: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetSaslAclsAcl): GetSaslAclsAcl = GetSaslAclsAcl(
            aclOperationType = javaType.aclOperationType(),
            aclResourceName = javaType.aclResourceName(),
            aclResourcePatternType = javaType.aclResourcePatternType(),
            aclResourceType = javaType.aclResourceType(),
            host = javaType.host(),
            username = javaType.username(),
        )
    }
}
