@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSaslAcls.
 * @property aclResourceName The resource name of the sasl acl.
 * @property aclResourceType The resource type of the sasl acl.
 * @property acls A list of sasl acls. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property outputFile
 * @property username The username of the sasl acl.
 */
public data class GetSaslAclsResult(
    public val aclResourceName: String,
    public val aclResourceType: String,
    public val acls: List<GetSaslAclsAcl>,
    public val id: String,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetSaslAclsResult): GetSaslAclsResult = GetSaslAclsResult(
            aclResourceName = javaType.aclResourceName(),
            aclResourceType = javaType.aclResourceType(),
            acls = javaType.acls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetSaslAclsAcl.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            username = javaType.username(),
        )
    }
}
