@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSaslUsers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property nameRegex
 * @property names A list of sasl usernames.
 * @property outputFile
 * @property users A list of sasl users. Each element contains the following attributes:
 */
public data class GetSaslUsersResult(
    public val id: String,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val users: List<GetSaslUsersUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetSaslUsersResult): GetSaslUsersResult = GetSaslUsersResult(
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            users = javaType.users().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetSaslUsersUser.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
