@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTopics.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId The instance_id of the instance.
 * @property nameRegex
 * @property names A list of topic names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property topic The name of the topic.
 * @property topics A list of topics. Each element contains the following attributes:
 * @property totalCount
 */
public data class GetTopicsResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val topic: String? = null,
    public val topics: List<GetTopicsTopic>,
    public val totalCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetTopicsResult): GetTopicsResult = GetTopicsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            topic = javaType.topic().map({ args0 -> args0 }).orElse(null),
            topics = javaType.topics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetTopicsTopic.Companion.toKotlin(args0)
                })
            }),
            totalCount = javaType.totalCount(),
        )
    }
}
