@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property compactTopic whether the current topic is kafka compact topic or not.
 * @property createTime Time of creation.
 * @property id The ID of the topic, It is formatted to `<instance_id>:<topic>`.
 * @property instanceId ID of the instance.
 * @property localTopic whether the current topic is kafka local topic or not.
 * @property partitionNum Partition number of the topic.
 * @property remark Remark of the topic.
 * @property status The current status code of the topic. There are three values to describe the topic status: 0 stands for the topic is in service, 1 stands for freezing and 2 stands for pause.
 * @property statusName The status_name of the topic.
 * @property tags A mapping of tags to assign to the topic.
 * @property topic A topic to filter results by the topic name.
 */
public data class GetTopicsTopic(
    public val compactTopic: Boolean,
    public val createTime: String,
    public val id: String,
    public val instanceId: String,
    public val localTopic: Boolean,
    public val partitionNum: Int,
    public val remark: String,
    public val status: Int,
    public val statusName: String,
    public val tags: Map<String, String>? = null,
    public val topic: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetTopicsTopic): GetTopicsTopic = GetTopicsTopic(
            compactTopic = javaType.compactTopic(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            localTopic = javaType.localTopic(),
            partitionNum = javaType.partitionNum(),
            remark = javaType.remark(),
            status = javaType.status(),
            statusName = javaType.statusName(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            topic = javaType.topic(),
        )
    }
}
