@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property eventRw Indicates whether the event is a read or a write event.
 * @property id
 * @property isOrganizationTrail
 * @property ossBucketName The name of the specified OSS bucket.
 * @property ossKeyPrefix The prefix of the specified OSS bucket name.
 * @property ossWriteRoleArn
 * @property slsProjectArn The unique ARN of the Log Service project.
 * @property slsWriteRoleArn The unique ARN of the Log Service role.
 * @property status
 * @property trailName
 * @property trailRegion
 */
public data class GetTrailsDeprecatedActiontrail(
    public val eventRw: String,
    public val id: String,
    public val isOrganizationTrail: Boolean,
    public val ossBucketName: String,
    public val ossKeyPrefix: String,
    public val ossWriteRoleArn: String,
    public val slsProjectArn: String,
    public val slsWriteRoleArn: String,
    public val status: String,
    public val trailName: String,
    public val trailRegion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetTrailsDeprecatedActiontrail): GetTrailsDeprecatedActiontrail = GetTrailsDeprecatedActiontrail(
            eventRw = javaType.eventRw(),
            id = javaType.id(),
            isOrganizationTrail = javaType.isOrganizationTrail(),
            ossBucketName = javaType.ossBucketName(),
            ossKeyPrefix = javaType.ossKeyPrefix(),
            ossWriteRoleArn = javaType.ossWriteRoleArn(),
            slsProjectArn = javaType.slsProjectArn(),
            slsWriteRoleArn = javaType.slsWriteRoleArn(),
            status = javaType.status(),
            trailName = javaType.trailName(),
            trailRegion = javaType.trailRegion(),
        )
    }
}
