@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTrailsDeprecated.
 * @property actiontrails A list of actiontrails. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property includeOrganizationTrail
 * @property includeShadowTrails
 * @property nameRegex
 * @property names A list of trail names.
 * @property outputFile
 * @property status
 * @property trails
 */
public data class GetTrailsDeprecatedResult(
    @Deprecated(
        message = """
  Field 'actiontrails' has been deprecated from version 1.95.0. Use 'trails' instead.
  """,
    )
    public val actiontrails: List<GetTrailsDeprecatedActiontrail>,
    public val id: String,
    public val ids: List<String>,
    public val includeOrganizationTrail: Boolean? = null,
    public val includeShadowTrails: Boolean? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val trails: List<GetTrailsDeprecatedTrail>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetTrailsDeprecatedResult): GetTrailsDeprecatedResult = GetTrailsDeprecatedResult(
            actiontrails = javaType.actiontrails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetTrailsDeprecatedActiontrail.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            includeOrganizationTrail = javaType.includeOrganizationTrail().map({ args0 -> args0 }).orElse(null),
            includeShadowTrails = javaType.includeShadowTrails().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            trails = javaType.trails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetTrailsDeprecatedTrail.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
