@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.actiontrail.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTrails.
 * @property actiontrails Field `actiontrails` has been deprecated from version 1.95.0. Use `trails` instead."
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of ActionTrail Trail ids. It is the same as trail name.
 * @property includeOrganizationTrail
 * @property includeShadowTrails
 * @property nameRegex
 * @property names A list of trail names.
 * @property outputFile
 * @property status The status of the ActionTrail Trail.
 * @property trails A list of ActionTrail Trails. Each element contains the following attributes:
 */
public data class GetTrailsResult(
    @Deprecated(
        message = """
  Field 'actiontrails' has been deprecated from version 1.95.0. Use 'trails' instead.
  """,
    )
    public val actiontrails: List<GetTrailsActiontrail>,
    public val id: String,
    public val ids: List<String>,
    public val includeOrganizationTrail: Boolean? = null,
    public val includeShadowTrails: Boolean? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val trails: List<GetTrailsTrail>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.actiontrail.outputs.GetTrailsResult): GetTrailsResult = GetTrailsResult(
            actiontrails = javaType.actiontrails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetTrailsActiontrail.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            includeOrganizationTrail = javaType.includeOrganizationTrail().map({ args0 -> args0 }).orElse(null),
            includeShadowTrails = javaType.includeShadowTrails().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            trails = javaType.trails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.actiontrail.kotlin.outputs.GetTrailsTrail.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
