@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource = com.pulumi.alicloud.adb.Account(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Account(builtJavaResource)
    }
}

/**
 * Provides a [ADB](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/latest/api-doc-adb-2019-03-15-api-doc-createaccount) account resource and used to manage databases.
 * > **NOTE:** Available since v1.71.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const creation = config.get("creation") || "ADB";
 * const name = config.get("name") || "tfexample";
 * const default = alicloud.adb.getZones({});
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[0],
 * }));
 * const vswitchId = defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]);
 * const cluster = new alicloud.adb.DBCluster("cluster", {
 *     dbClusterCategory: "MixedStorage",
 *     mode: "flexible",
 *     computeResource: "8Core32GB",
 *     vswitchId: vswitchId,
 *     description: name,
 * });
 * const defaultAccount = new alicloud.adb.Account("default", {
 *     dbClusterId: cluster.id,
 *     accountName: name,
 *     accountPassword: "tf_example123",
 *     accountDescription: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * creation = config.get("creation")
 * if creation is None:
 *     creation = "ADB"
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * default = alicloud.adb.get_zones()
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[0])
 * vswitch_id = default_get_switches.ids[0]
 * cluster = alicloud.adb.DBCluster("cluster",
 *     db_cluster_category="MixedStorage",
 *     mode="flexible",
 *     compute_resource="8Core32GB",
 *     vswitch_id=vswitch_id,
 *     description=name)
 * default_account = alicloud.adb.Account("default",
 *     db_cluster_id=cluster.id,
 *     account_name=name,
 *     account_password="tf_example123",
 *     account_description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var creation = config.Get("creation") ?? "ADB";
 *     var name = config.Get("name") ?? "tfexample";
 *     var @default = AliCloud.Adb.GetZones.Invoke();
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[0]),
 *     });
 *     var vswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]);
 *     var cluster = new AliCloud.Adb.DBCluster("cluster", new()
 *     {
 *         DbClusterCategory = "MixedStorage",
 *         Mode = "flexible",
 *         ComputeResource = "8Core32GB",
 *         VswitchId = vswitchId,
 *         Description = name,
 *     });
 *     var defaultAccount = new AliCloud.Adb.Account("default", new()
 *     {
 *         DbClusterId = cluster.Id,
 *         AccountName = name,
 *         AccountPassword = "tf_example123",
 *         AccountDescription = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		creation := "ADB"
 * 		if param := cfg.Get("creation"); param != "" {
 * 			creation = param
 * 		}
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := adb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vswitchId := defaultGetSwitches.Ids[0]
 * 		cluster, err := adb.NewDBCluster(ctx, "cluster", &adb.DBClusterArgs{
 * 			DbClusterCategory: pulumi.String("MixedStorage"),
 * 			Mode:              pulumi.String("flexible"),
 * 			ComputeResource:   pulumi.String("8Core32GB"),
 * 			VswitchId:         pulumi.String(vswitchId),
 * 			Description:       pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = adb.NewAccount(ctx, "default", &adb.AccountArgs{
 * 			DbClusterId:        cluster.ID(),
 * 			AccountName:        pulumi.String(name),
 * 			AccountPassword:    pulumi.String("tf_example123"),
 * 			AccountDescription: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.adb.AdbFunctions;
 * import com.pulumi.alicloud.adb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.adb.DBCluster;
 * import com.pulumi.alicloud.adb.DBClusterArgs;
 * import com.pulumi.alicloud.adb.Account;
 * import com.pulumi.alicloud.adb.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var creation = config.get("creation").orElse("ADB");
 *         final var name = config.get("name").orElse("tfexample");
 *         final var default = AdbFunctions.getZones();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[0])
 *             .build());
 *         final var vswitchId = defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]);
 *         var cluster = new DBCluster("cluster", DBClusterArgs.builder()
 *             .dbClusterCategory("MixedStorage")
 *             .mode("flexible")
 *             .computeResource("8Core32GB")
 *             .vswitchId(vswitchId)
 *             .description(name)
 *             .build());
 *         var defaultAccount = new Account("defaultAccount", AccountArgs.builder()
 *             .dbClusterId(cluster.id())
 *             .accountName(name)
 *             .accountPassword("tf_example123")
 *             .accountDescription(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   creation:
 *     type: string
 *     default: ADB
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   cluster:
 *     type: alicloud:adb:DBCluster
 *     properties:
 *       dbClusterCategory: MixedStorage
 *       mode: flexible
 *       computeResource: 8Core32GB
 *       vswitchId: ${vswitchId}
 *       description: ${name}
 *   defaultAccount:
 *     type: alicloud:adb:Account
 *     name: default
 *     properties:
 *       dbClusterId: ${cluster.id}
 *       accountName: ${name}
 *       accountPassword: tf_example123
 *       accountDescription: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:adb:getZones
 *       Arguments: {}
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[0]}
 *   vswitchId: ${defaultGetSwitches.ids[0]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ADB account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/account:Account example am-12345:tf_account
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.alicloud.adb.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * Account description. It cannot begin with https://. It must start with a Chinese character or English letter. It can include Chinese and English characters, underlines (_), hyphens (-), and numbers. The length may be 2-256 characters.
     */
    public val accountDescription: Output<String>?
        get() = javaResource.accountDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Operation account requiring a uniqueness check. It may consist of lower case letters, numbers, and underlines, and must start with a letter and have no more than 16 characters.
     */
    public val accountName: Output<String>
        get() = javaResource.accountName().applyValue({ args0 -> args0 })

    /**
     * Operation password. It may consist of letters, digits, or underlines, with a length of 6 to 32 characters. You have to specify one of `account_password` and `kms_encrypted_password` fields.
     */
    public val accountPassword: Output<String>?
        get() = javaResource.accountPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Id of cluster in which account belongs.
     */
    public val dbClusterId: Output<String>
        get() = javaResource.dbClusterId().applyValue({ args0 -> args0 })

    /**
     * An KMS encrypts password used to a db account. If the `account_password` is filled in, this field will be ignored.
     */
    public val kmsEncryptedPassword: Output<String>?
        get() = javaResource.kmsEncryptedPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    public val kmsEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.kmsEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.adb.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.alicloud.adb.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
