@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.alicloud.adb.AdbFunctions.getClustersPlain
import com.pulumi.alicloud.adb.AdbFunctions.getDBClusterLakeVersionsPlain
import com.pulumi.alicloud.adb.AdbFunctions.getDBClustersPlain
import com.pulumi.alicloud.adb.AdbFunctions.getResourceGroupsPlain
import com.pulumi.alicloud.adb.AdbFunctions.getZonesPlain
import com.pulumi.alicloud.adb.kotlin.inputs.GetClustersPlainArgs
import com.pulumi.alicloud.adb.kotlin.inputs.GetClustersPlainArgsBuilder
import com.pulumi.alicloud.adb.kotlin.inputs.GetDBClusterLakeVersionsPlainArgs
import com.pulumi.alicloud.adb.kotlin.inputs.GetDBClusterLakeVersionsPlainArgsBuilder
import com.pulumi.alicloud.adb.kotlin.inputs.GetDBClustersPlainArgs
import com.pulumi.alicloud.adb.kotlin.inputs.GetDBClustersPlainArgsBuilder
import com.pulumi.alicloud.adb.kotlin.inputs.GetResourceGroupsPlainArgs
import com.pulumi.alicloud.adb.kotlin.inputs.GetResourceGroupsPlainArgsBuilder
import com.pulumi.alicloud.adb.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.adb.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.adb.kotlin.outputs.GetClustersResult
import com.pulumi.alicloud.adb.kotlin.outputs.GetDBClusterLakeVersionsResult
import com.pulumi.alicloud.adb.kotlin.outputs.GetDBClustersResult
import com.pulumi.alicloud.adb.kotlin.outputs.GetResourceGroupsResult
import com.pulumi.alicloud.adb.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.adb.kotlin.outputs.GetClustersResult.Companion.toKotlin as getClustersResultToKotlin
import com.pulumi.alicloud.adb.kotlin.outputs.GetDBClusterLakeVersionsResult.Companion.toKotlin as getDBClusterLakeVersionsResultToKotlin
import com.pulumi.alicloud.adb.kotlin.outputs.GetDBClustersResult.Companion.toKotlin as getDBClustersResultToKotlin
import com.pulumi.alicloud.adb.kotlin.outputs.GetResourceGroupsResult.Companion.toKotlin as getResourceGroupsResultToKotlin
import com.pulumi.alicloud.adb.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object AdbFunctions {
    /**
     * The `alicloud.adb.getClusters` data source provides a collection of ADB clusters available in Alibaba Cloud account.
     * Filters support regular expression for the cluster description, searches by tags, and other filters which are listed below.
     * > **DEPRECATED:**  This resource  has been deprecated from version `1.121.0`. Please use new datasource alicloud_adb_db_clusters.
     * > **NOTE:** Available in v1.71.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const adbClustersDs = alicloud.adb.getClusters({
     *     descriptionRegex: "am-\\w+",
     *     status: "Running",
     * });
     * export const firstAdbClusterId = adbClustersDs.then(adbClustersDs => adbClustersDs.clusters?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * adb_clusters_ds = alicloud.adb.get_clusters(description_regex="am-\\w+",
     *     status="Running")
     * pulumi.export("firstAdbClusterId", adb_clusters_ds.clusters[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var adbClustersDs = AliCloud.Adb.GetClusters.Invoke(new()
     *     {
     *         DescriptionRegex = "am-\\w+",
     *         Status = "Running",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstAdbClusterId"] = adbClustersDs&#46;Apply(getClustersResult => getClustersResult&#46;Clusters[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		adbClustersDs, err := adb.GetClusters(ctx, &adb.GetClustersArgs{
     * 			DescriptionRegex: pulumi.StringRef("am-\\w+"),
     * 			Status:           pulumi.StringRef("Running"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstAdbClusterId", adbClustersDs.Clusters[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.adb.AdbFunctions;
     * import com.pulumi.alicloud.adb.inputs.GetClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var adbClustersDs = AdbFunctions.getClusters(GetClustersArgs.builder()
     *             .descriptionRegex("am-\\w+")
     *             .status("Running")
     *             .build());
     *         ctx.export("firstAdbClusterId", adbClustersDs.applyValue(getClustersResult -> getClustersResult.clusters()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   adbClustersDs:
     *     fn::invoke:
     *       Function: alicloud:adb:getClusters
     *       Arguments:
     *         descriptionRegex: am-\w+
     *         status: Running
     * outputs:
     *   firstAdbClusterId: ${adbClustersDs.clusters[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusters.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: GetClustersPlainArgs): GetClustersResult =
        getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())

    /**
     * @see [getClusters].
     * @param description The description of the ADB cluster.
     * @param descriptionRegex A regex string to filter results by cluster description.
     * @param enableDetails
     * @param ids A list of ADB cluster IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param resourceGroupId
     * @param status The status of the cluster. Valid values: `Preparing`, `Creating`, `Restoring`, `Running`, `Deleting`, `ClassChanging`, `NetAddressCreating`, `NetAddressDeleting`. For more information, see [Cluster status](https://www.alibabacloud.com/help/doc-detail/143075.htm).
     * @param tags A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(
        description: String? = null,
        descriptionRegex: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetClustersResult {
        val argument = GetClustersPlainArgs(
            description = description,
            descriptionRegex = descriptionRegex,
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
        )
        return getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;adb&#46;kotlin&#46;inputs&#46;GetClustersPlainArgs].
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: suspend GetClustersPlainArgsBuilder.() -> Unit): GetClustersResult {
        val builder = GetClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClustersResultToKotlin(getClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Adb DBCluster Lake Versions of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.190.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.adb.getDBClusterLakeVersions({
     *     ids: ["example_id"],
     * });
     * export const adbDbClusterLakeVersionId1 = ids.then(ids => ids.versions?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.adb.get_db_cluster_lake_versions(ids=["example_id"])
     * pulumi.export("adbDbClusterLakeVersionId1", ids.versions[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Adb.GetDBClusterLakeVersions.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["adbDbClusterLakeVersionId1"] = ids&#46;Apply(getDBClusterLakeVersionsResult => getDBClusterLakeVersionsResult&#46;Versions[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := adb.GetDBClusterLakeVersions(ctx, &adb.GetDBClusterLakeVersionsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("adbDbClusterLakeVersionId1", ids.Versions[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.adb.AdbFunctions;
     * import com.pulumi.alicloud.adb.inputs.GetDBClusterLakeVersionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = AdbFunctions.getDBClusterLakeVersions(GetDBClusterLakeVersionsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("adbDbClusterLakeVersionId1", ids.applyValue(getDBClusterLakeVersionsResult -> getDBClusterLakeVersionsResult.versions()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:adb:getDBClusterLakeVersions
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   adbDbClusterLakeVersionId1: ${ids.versions[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDBClusterLakeVersions.
     * @return A collection of values returned by getDBClusterLakeVersions.
     */
    public suspend fun getDBClusterLakeVersions(argument: GetDBClusterLakeVersionsPlainArgs): GetDBClusterLakeVersionsResult =
        getDBClusterLakeVersionsResultToKotlin(getDBClusterLakeVersionsPlain(argument.toJava()).await())

    /**
     * @see [getDBClusterLakeVersions].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of DBCluster IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param resourceGroupId The ID of the resource group.
     * @param status The status of the resource. Valid values: `Preparing`, `Creating`, `Restoring`, `Running`, `Deleting`, `ClassChanging`, `NetAddressCreating`, `NetAddressDeleting`.
     * @return A collection of values returned by getDBClusterLakeVersions.
     */
    public suspend fun getDBClusterLakeVersions(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        resourceGroupId: String? = null,
        status: String? = null,
    ): GetDBClusterLakeVersionsResult {
        val argument = GetDBClusterLakeVersionsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            resourceGroupId = resourceGroupId,
            status = status,
        )
        return getDBClusterLakeVersionsResultToKotlin(getDBClusterLakeVersionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDBClusterLakeVersions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;adb&#46;kotlin&#46;inputs&#46;GetDBClusterLakeVersionsPlainArgs].
     * @return A collection of values returned by getDBClusterLakeVersions.
     */
    public suspend fun getDBClusterLakeVersions(argument: suspend GetDBClusterLakeVersionsPlainArgsBuilder.() -> Unit): GetDBClusterLakeVersionsResult {
        val builder = GetDBClusterLakeVersionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDBClusterLakeVersionsResultToKotlin(getDBClusterLakeVersionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Adb DBClusters of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.121.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.adb.getDBClusters({
     *     descriptionRegex: "example",
     * });
     * export const firstAdbDbClusterId = example.then(example => example.clusters?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.adb.get_db_clusters(description_regex="example")
     * pulumi.export("firstAdbDbClusterId", example.clusters[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Adb.GetDBClusters.Invoke(new()
     *     {
     *         DescriptionRegex = "example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstAdbDbClusterId"] = example&#46;Apply(getDBClustersResult => getDBClustersResult&#46;Clusters[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := adb.GetDBClusters(ctx, &adb.GetDBClustersArgs{
     * 			DescriptionRegex: pulumi.StringRef("example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstAdbDbClusterId", example.Clusters[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.adb.AdbFunctions;
     * import com.pulumi.alicloud.adb.inputs.GetDBClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AdbFunctions.getDBClusters(GetDBClustersArgs.builder()
     *             .descriptionRegex("example")
     *             .build());
     *         ctx.export("firstAdbDbClusterId", example.applyValue(getDBClustersResult -> getDBClustersResult.clusters()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:adb:getDBClusters
     *       Arguments:
     *         descriptionRegex: example
     * outputs:
     *   firstAdbDbClusterId: ${example.clusters[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDBClusters.
     * @return A collection of values returned by getDBClusters.
     */
    public suspend fun getDBClusters(argument: GetDBClustersPlainArgs): GetDBClustersResult =
        getDBClustersResultToKotlin(getDBClustersPlain(argument.toJava()).await())

    /**
     * @see [getDBClusters].
     * @param description The description of DBCluster.
     * @param descriptionRegex A regex string to filter results by DBCluster description.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of DBCluster IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param resourceGroupId The ID of the resource group.
     * @param status The status of the resource.
     * @param tags A map of tags assigned to the cluster.
     * @return A collection of values returned by getDBClusters.
     */
    public suspend fun getDBClusters(
        description: String? = null,
        descriptionRegex: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        resourceGroupId: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetDBClustersResult {
        val argument = GetDBClustersPlainArgs(
            description = description,
            descriptionRegex = descriptionRegex,
            enableDetails = enableDetails,
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            resourceGroupId = resourceGroupId,
            status = status,
            tags = tags,
        )
        return getDBClustersResultToKotlin(getDBClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getDBClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;adb&#46;kotlin&#46;inputs&#46;GetDBClustersPlainArgs].
     * @return A collection of values returned by getDBClusters.
     */
    public suspend fun getDBClusters(argument: suspend GetDBClustersPlainArgsBuilder.() -> Unit): GetDBClustersResult {
        val builder = GetDBClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDBClustersResultToKotlin(getDBClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Adb Resource Group available to the user.[What is Resource Group](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2019-03-15-describedbresourcegroup)
     * > **NOTE:** Available since v1.195.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.adb.getResourceGroups({
     *     dbClusterId: "am-bp1a16357gty69185",
     *     groupName: "TESTOPENAPI",
     * });
     * export const alicloudAdbResourceGroupExampleId = _default.then(_default => _default.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.adb.get_resource_groups(db_cluster_id="am-bp1a16357gty69185",
     *     group_name="TESTOPENAPI")
     * pulumi.export("alicloudAdbResourceGroupExampleId", default.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Adb.GetResourceGroups.Invoke(new()
     *     {
     *         DbClusterId = "am-bp1a16357gty69185",
     *         GroupName = "TESTOPENAPI",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudAdbResourceGroupExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getResourceGroupsResult => getResourceGroupsResult&#46;Groups[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := adb.GetResourceGroups(ctx, &adb.GetResourceGroupsArgs{
     * 			DbClusterId: "am-bp1a16357gty69185",
     * 			GroupName:   pulumi.StringRef("TESTOPENAPI"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudAdbResourceGroupExampleId", _default.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.adb.AdbFunctions;
     * import com.pulumi.alicloud.adb.inputs.GetResourceGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = AdbFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
     *             .dbClusterId("am-bp1a16357gty69185")
     *             .groupName("TESTOPENAPI")
     *             .build());
     *         ctx.export("alicloudAdbResourceGroupExampleId", default_.groups()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:adb:getResourceGroups
     *       Arguments:
     *         dbClusterId: am-bp1a16357gty69185
     *         groupName: TESTOPENAPI
     * outputs:
     *   alicloudAdbResourceGroupExampleId: ${default.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResourceGroups.
     * @return A collection of values returned by getResourceGroups.
     */
    public suspend fun getResourceGroups(argument: GetResourceGroupsPlainArgs): GetResourceGroupsResult =
        getResourceGroupsResultToKotlin(getResourceGroupsPlain(argument.toJava()).await())

    /**
     * @see [getResourceGroups].
     * @param dbClusterId DBClusterId
     * @param groupName The name of the resource pool, which cannot exceed 64 bytes in length.
     * @param ids A list of AnalyticDB for MySQL (ADB) Resource Group IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getResourceGroups.
     */
    public suspend fun getResourceGroups(
        dbClusterId: String,
        groupName: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
    ): GetResourceGroupsResult {
        val argument = GetResourceGroupsPlainArgs(
            dbClusterId = dbClusterId,
            groupName = groupName,
            ids = ids,
            outputFile = outputFile,
        )
        return getResourceGroupsResultToKotlin(getResourceGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;adb&#46;kotlin&#46;inputs&#46;GetResourceGroupsPlainArgs].
     * @return A collection of values returned by getResourceGroups.
     */
    public suspend fun getResourceGroups(argument: suspend GetResourceGroupsPlainArgsBuilder.() -> Unit): GetResourceGroupsResult {
        val builder = GetResourceGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceGroupsResultToKotlin(getResourceGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones for ADB that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available in v1.73.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const zonesIds = alicloud.adb.getZones({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * zones_ids = alicloud.adb.get_zones()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var zonesIds = AliCloud.Adb.GetZones.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		_, err := adb.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.adb.AdbFunctions;
     * import com.pulumi.alicloud.adb.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var zonesIds = AdbFunctions.getZones();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   zonesIds:
     *     fn::invoke:
     *       Function: alicloud:adb:getZones
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param multi Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch ADB instances.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(multi: Boolean? = null, outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            multi = multi,
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;adb&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
