@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BackupPolicy].
 */
@PulumiTagMarker
public class BackupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupPolicyArgs = BackupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupPolicyArgsBuilder.() -> Unit) {
        val builder = BackupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BackupPolicy {
        val builtJavaResource = com.pulumi.alicloud.adb.BackupPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BackupPolicy(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * ADB backup policy can be imported using the id or cluster id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/backupPolicy:BackupPolicy example "am-12345678"
 * ```
 */
public class BackupPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.adb.BackupPolicy,
) : KotlinCustomResource(javaResource, BackupPolicyMapper) {
    /**
     * Cluster backup retention days, Fixed for 7 days, not modified.
     */
    public val backupRetentionPeriod: Output<String>
        get() = javaResource.backupRetentionPeriod().applyValue({ args0 -> args0 })

    /**
     * The Id of cluster that can run database.
     */
    public val dbClusterId: Output<String>
        get() = javaResource.dbClusterId().applyValue({ args0 -> args0 })

    /**
     * ADB Cluster backup period. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    public val preferredBackupPeriods: Output<List<String>>
        get() = javaResource.preferredBackupPeriods().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ADB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. China time is 8 hours behind it.
     */
    public val preferredBackupTime: Output<String>
        get() = javaResource.preferredBackupTime().applyValue({ args0 -> args0 })
}

public object BackupPolicyMapper : ResourceMapper<BackupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.adb.BackupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BackupPolicy = BackupPolicy(
        javaResource as
            com.pulumi.alicloud.adb.BackupPolicy,
    )
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupPolicy].
 */
public suspend fun backupPolicy(
    name: String,
    block: suspend BackupPolicyResourceBuilder.() -> Unit,
): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupPolicy(name: String): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
