@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.alicloud.adb.BackupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * ADB backup policy can be imported using the id or cluster id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/backupPolicy:BackupPolicy example "am-12345678"
 * ```
 * @property dbClusterId The Id of cluster that can run database.
 * @property preferredBackupPeriods ADB Cluster backup period. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
 * @property preferredBackupTime ADB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. China time is 8 hours behind it.
 */
public data class BackupPolicyArgs(
    public val dbClusterId: Output<String>? = null,
    public val preferredBackupPeriods: Output<List<String>>? = null,
    public val preferredBackupTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.adb.BackupPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.adb.BackupPolicyArgs =
        com.pulumi.alicloud.adb.BackupPolicyArgs.builder()
            .dbClusterId(dbClusterId?.applyValue({ args0 -> args0 }))
            .preferredBackupPeriods(
                preferredBackupPeriods?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .preferredBackupTime(preferredBackupTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupPolicyArgs].
 */
@PulumiTagMarker
public class BackupPolicyArgsBuilder internal constructor() {
    private var dbClusterId: Output<String>? = null

    private var preferredBackupPeriods: Output<List<String>>? = null

    private var preferredBackupTime: Output<String>? = null

    /**
     * @param value The Id of cluster that can run database.
     */
    @JvmName("cidgujhbeoyyvatc")
    public suspend fun dbClusterId(`value`: Output<String>) {
        this.dbClusterId = value
    }

    /**
     * @param value ADB Cluster backup period. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("djlosrljeibjbddw")
    public suspend fun preferredBackupPeriods(`value`: Output<List<String>>) {
        this.preferredBackupPeriods = value
    }

    @JvmName("niiicubhwlesqjct")
    public suspend fun preferredBackupPeriods(vararg values: Output<String>) {
        this.preferredBackupPeriods = Output.all(values.asList())
    }

    /**
     * @param values ADB Cluster backup period. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("nmfiexsurnplbwky")
    public suspend fun preferredBackupPeriods(values: List<Output<String>>) {
        this.preferredBackupPeriods = Output.all(values)
    }

    /**
     * @param value ADB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. China time is 8 hours behind it.
     */
    @JvmName("nluxfomluteyvloo")
    public suspend fun preferredBackupTime(`value`: Output<String>) {
        this.preferredBackupTime = value
    }

    /**
     * @param value The Id of cluster that can run database.
     */
    @JvmName("ehdaccgwrqntcgpo")
    public suspend fun dbClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterId = mapped
    }

    /**
     * @param value ADB Cluster backup period. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("pdemeokrawbwnyno")
    public suspend fun preferredBackupPeriods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupPeriods = mapped
    }

    /**
     * @param values ADB Cluster backup period. Valid values: [Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday].
     */
    @JvmName("qhhtodmufdmfdjfg")
    public suspend fun preferredBackupPeriods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredBackupPeriods = mapped
    }

    /**
     * @param value ADB Cluster backup time, in the format of HH:mmZ- HH:mmZ. Time setting interval is one hour. China time is 8 hours behind it.
     */
    @JvmName("tfafixelparbbtqg")
    public suspend fun preferredBackupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupTime = mapped
    }

    internal fun build(): BackupPolicyArgs = BackupPolicyArgs(
        dbClusterId = dbClusterId,
        preferredBackupPeriods = preferredBackupPeriods,
        preferredBackupTime = preferredBackupTime,
    )
}
