@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.alicloud.adb.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Provides a ADB cluster resource. An ADB cluster is an isolated database
 * environment in the cloud. An ADB cluster can contain multiple user-created
 * databases.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.121.0`. Please use new resource alicloud_adb_db_cluster.
 * > **NOTE:** Available in v1.71.0+.
 * ## Example Usage
 * ### Create a ADB MySQL cluster
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "adbClusterconfig";
 * const creation = config.get("creation") || "ADB";
 * const default = alicloud.getZones({
 *     availableResourceCreation: creation,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultCluster = new alicloud.adb.Cluster("default", {
 *     dbClusterVersion: "3.0",
 *     dbClusterCategory: "Cluster",
 *     dbNodeClass: "C8",
 *     dbNodeCount: 2,
 *     dbNodeStorage: 200,
 *     payType: "PostPaid",
 *     description: name,
 *     vswitchId: defaultSwitch.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "adbClusterconfig"
 * creation = config.get("creation")
 * if creation is None:
 *     creation = "ADB"
 * default = alicloud.get_zones(available_resource_creation=creation)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_cluster = alicloud.adb.Cluster("default",
 *     db_cluster_version="3.0",
 *     db_cluster_category="Cluster",
 *     db_node_class="C8",
 *     db_node_count=2,
 *     db_node_storage=200,
 *     pay_type="PostPaid",
 *     description=name,
 *     vswitch_id=default_switch.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "adbClusterconfig";
 *     var creation = config.Get("creation") ?? "ADB";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = creation,
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultCluster = new AliCloud.Adb.Cluster("default", new()
 *     {
 *         DbClusterVersion = "3.0",
 *         DbClusterCategory = "Cluster",
 *         DbNodeClass = "C8",
 *         DbNodeCount = 2,
 *         DbNodeStorage = 200,
 *         PayType = "PostPaid",
 *         Description = name,
 *         VswitchId = defaultSwitch.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "adbClusterconfig"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		creation := "ADB"
 * 		if param := cfg.Get("creation"); param != "" {
 * 			creation = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef(creation),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = adb.NewCluster(ctx, "default", &adb.ClusterArgs{
 * 			DbClusterVersion:  pulumi.String("3.0"),
 * 			DbClusterCategory: pulumi.String("Cluster"),
 * 			DbNodeClass:       pulumi.String("C8"),
 * 			DbNodeCount:       pulumi.Int(2),
 * 			DbNodeStorage:     pulumi.Int(200),
 * 			PayType:           pulumi.String("PostPaid"),
 * 			Description:       pulumi.String(name),
 * 			VswitchId:         defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.adb.Cluster;
 * import com.pulumi.alicloud.adb.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("adbClusterconfig");
 *         final var creation = config.get("creation").orElse("ADB");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation(creation)
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .dbClusterVersion("3.0")
 *             .dbClusterCategory("Cluster")
 *             .dbNodeClass("C8")
 *             .dbNodeCount(2)
 *             .dbNodeStorage(200)
 *             .payType("PostPaid")
 *             .description(name)
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: adbClusterconfig
 *   creation:
 *     type: string
 *     default: ADB
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultCluster:
 *     type: alicloud:adb:Cluster
 *     name: default
 *     properties:
 *       dbClusterVersion: '3.0'
 *       dbClusterCategory: Cluster
 *       dbNodeClass: C8
 *       dbNodeCount: 2
 *       dbNodeStorage: 200
 *       payType: PostPaid
 *       description: ${name}
 *       vswitchId: ${defaultSwitch.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: ${creation}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ADB cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/cluster:Cluster example am-abc12345678
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.alicloud.adb.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
     */
    public val autoRenewPeriod: Output<Int>
        get() = javaResource.autoRenewPeriod().applyValue({ args0 -> args0 })

    public val computeResource: Output<String>?
        get() = javaResource.computeResource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * (Available in 1.93.0+) The connection string of the ADB cluster.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * Cluster category. Value options: `Basic`, `Cluster`.
     */
    public val dbClusterCategory: Output<String>
        get() = javaResource.dbClusterCategory().applyValue({ args0 -> args0 })

    @Deprecated(
        message = """
  It duplicates with attribute db_node_class and is deprecated from 1.121.2.
  """,
    )
    public val dbClusterClass: Output<String>?
        get() = javaResource.dbClusterClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Cluster version. Value options: `3.0`, Default to `3.0`.
     */
    public val dbClusterVersion: Output<String>?
        get() = javaResource.dbClusterVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The db_node_class of cluster node.
     */
    public val dbNodeClass: Output<String>
        get() = javaResource.dbNodeClass().applyValue({ args0 -> args0 })

    /**
     * The db_node_count of cluster node.
     */
    public val dbNodeCount: Output<Int>
        get() = javaResource.dbNodeCount().applyValue({ args0 -> args0 })

    /**
     * The db_node_storage of cluster node.
     */
    public val dbNodeStorage: Output<Int>
        get() = javaResource.dbNodeStorage().applyValue({ args0 -> args0 })

    /**
     * The description of cluster.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    public val diskEncryption: Output<Boolean>?
        get() = javaResource.diskEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val diskPerformanceLevel: Output<String>
        get() = javaResource.diskPerformanceLevel().applyValue({ args0 -> args0 })

    public val elasticIoResource: Output<Int>
        get() = javaResource.elasticIoResource().applyValue({ args0 -> args0 })

    public val elasticIoResourceSize: Output<String>
        get() = javaResource.elasticIoResourceSize().applyValue({ args0 -> args0 })

    public val kmsId: Output<String>?
        get() = javaResource.kmsId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
     */
    public val maintainTime: Output<String>
        get() = javaResource.maintainTime().applyValue({ args0 -> args0 })

    public val mode: Output<String>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    public val modifyType: Output<String>?
        get() = javaResource.modifyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field `pay_type` has been deprecated. New field `payment_type` instead.
     */
    @Deprecated(
        message = """
  Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove
      in the future version. Please use the new attribute 'payment_type' instead.
  """,
    )
    public val payType: Output<String>
        get() = javaResource.payType().applyValue({ args0 -> args0 })

    /**
     * The payment type of the resource. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * (Available in 1.196.0+) The connection port of the ADB cluster.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
     */
    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    public val securityIps: Output<List<String>>
        get() = javaResource.securityIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The virtual switch ID to launch DB instances in one VPC.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Zone to launch the DB cluster.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.adb.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.alicloud.adb.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
