@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.alicloud.adb.ClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ADB cluster resource. An ADB cluster is an isolated database
 * environment in the cloud. An ADB cluster can contain multiple user-created
 * databases.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.121.0`. Please use new resource alicloud_adb_db_cluster.
 * > **NOTE:** Available in v1.71.0+.
 * ## Example Usage
 * ### Create a ADB MySQL cluster
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "adbClusterconfig";
 * const creation = config.get("creation") || "ADB";
 * const default = alicloud.getZones({
 *     availableResourceCreation: creation,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultCluster = new alicloud.adb.Cluster("default", {
 *     dbClusterVersion: "3.0",
 *     dbClusterCategory: "Cluster",
 *     dbNodeClass: "C8",
 *     dbNodeCount: 2,
 *     dbNodeStorage: 200,
 *     payType: "PostPaid",
 *     description: name,
 *     vswitchId: defaultSwitch.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "adbClusterconfig"
 * creation = config.get("creation")
 * if creation is None:
 *     creation = "ADB"
 * default = alicloud.get_zones(available_resource_creation=creation)
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_cluster = alicloud.adb.Cluster("default",
 *     db_cluster_version="3.0",
 *     db_cluster_category="Cluster",
 *     db_node_class="C8",
 *     db_node_count=2,
 *     db_node_storage=200,
 *     pay_type="PostPaid",
 *     description=name,
 *     vswitch_id=default_switch.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "adbClusterconfig";
 *     var creation = config.Get("creation") ?? "ADB";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = creation,
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultCluster = new AliCloud.Adb.Cluster("default", new()
 *     {
 *         DbClusterVersion = "3.0",
 *         DbClusterCategory = "Cluster",
 *         DbNodeClass = "C8",
 *         DbNodeCount = 2,
 *         DbNodeStorage = 200,
 *         PayType = "PostPaid",
 *         Description = name,
 *         VswitchId = defaultSwitch.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "adbClusterconfig"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		creation := "ADB"
 * 		if param := cfg.Get("creation"); param != "" {
 * 			creation = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef(creation),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = adb.NewCluster(ctx, "default", &adb.ClusterArgs{
 * 			DbClusterVersion:  pulumi.String("3.0"),
 * 			DbClusterCategory: pulumi.String("Cluster"),
 * 			DbNodeClass:       pulumi.String("C8"),
 * 			DbNodeCount:       pulumi.Int(2),
 * 			DbNodeStorage:     pulumi.Int(200),
 * 			PayType:           pulumi.String("PostPaid"),
 * 			Description:       pulumi.String(name),
 * 			VswitchId:         defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.adb.Cluster;
 * import com.pulumi.alicloud.adb.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("adbClusterconfig");
 *         final var creation = config.get("creation").orElse("ADB");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation(creation)
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultCluster = new Cluster("defaultCluster", ClusterArgs.builder()
 *             .dbClusterVersion("3.0")
 *             .dbClusterCategory("Cluster")
 *             .dbNodeClass("C8")
 *             .dbNodeCount(2)
 *             .dbNodeStorage(200)
 *             .payType("PostPaid")
 *             .description(name)
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: adbClusterconfig
 *   creation:
 *     type: string
 *     default: ADB
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultCluster:
 *     type: alicloud:adb:Cluster
 *     name: default
 *     properties:
 *       dbClusterVersion: '3.0'
 *       dbClusterCategory: Cluster
 *       dbNodeClass: C8
 *       dbNodeCount: 2
 *       dbNodeStorage: 200
 *       payType: PostPaid
 *       description: ${name}
 *       vswitchId: ${defaultSwitch.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: ${creation}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ADB cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/cluster:Cluster example am-abc12345678
 * ```
 * @property autoRenewPeriod Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
 * @property computeResource
 * @property dbClusterCategory Cluster category. Value options: `Basic`, `Cluster`.
 * @property dbClusterClass
 * @property dbClusterVersion Cluster version. Value options: `3.0`, Default to `3.0`.
 * @property dbNodeClass The db_node_class of cluster node.
 * @property dbNodeCount The db_node_count of cluster node.
 * @property dbNodeStorage The db_node_storage of cluster node.
 * @property description The description of cluster.
 * @property diskEncryption
 * @property diskPerformanceLevel
 * @property elasticIoResource
 * @property elasticIoResourceSize
 * @property kmsId
 * @property maintainTime Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
 * @property mode
 * @property modifyType
 * @property payType Field `pay_type` has been deprecated. New field `payment_type` instead.
 * @property paymentType The payment type of the resource. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
 * @property period The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1.
 * @property renewalStatus Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
 * @property resourceGroupId
 * @property securityIps List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
 * @property vpcId
 * @property vswitchId The virtual switch ID to launch DB instances in one VPC.
 * @property zoneId The Zone to launch the DB cluster.
 */
public data class ClusterArgs(
    public val autoRenewPeriod: Output<Int>? = null,
    public val computeResource: Output<String>? = null,
    public val dbClusterCategory: Output<String>? = null,
    @Deprecated(
        message = """
  It duplicates with attribute db_node_class and is deprecated from 1.121.2.
  """,
    )
    public val dbClusterClass: Output<String>? = null,
    public val dbClusterVersion: Output<String>? = null,
    public val dbNodeClass: Output<String>? = null,
    public val dbNodeCount: Output<Int>? = null,
    public val dbNodeStorage: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val diskEncryption: Output<Boolean>? = null,
    public val diskPerformanceLevel: Output<String>? = null,
    public val elasticIoResource: Output<Int>? = null,
    public val elasticIoResourceSize: Output<String>? = null,
    public val kmsId: Output<String>? = null,
    public val maintainTime: Output<String>? = null,
    public val mode: Output<String>? = null,
    public val modifyType: Output<String>? = null,
    @Deprecated(
        message = """
  Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove
      in the future version. Please use the new attribute 'payment_type' instead.
  """,
    )
    public val payType: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val renewalStatus: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityIps: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.adb.ClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.adb.ClusterArgs =
        com.pulumi.alicloud.adb.ClusterArgs.builder()
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .computeResource(computeResource?.applyValue({ args0 -> args0 }))
            .dbClusterCategory(dbClusterCategory?.applyValue({ args0 -> args0 }))
            .dbClusterClass(dbClusterClass?.applyValue({ args0 -> args0 }))
            .dbClusterVersion(dbClusterVersion?.applyValue({ args0 -> args0 }))
            .dbNodeClass(dbNodeClass?.applyValue({ args0 -> args0 }))
            .dbNodeCount(dbNodeCount?.applyValue({ args0 -> args0 }))
            .dbNodeStorage(dbNodeStorage?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .diskEncryption(diskEncryption?.applyValue({ args0 -> args0 }))
            .diskPerformanceLevel(diskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .elasticIoResource(elasticIoResource?.applyValue({ args0 -> args0 }))
            .elasticIoResourceSize(elasticIoResourceSize?.applyValue({ args0 -> args0 }))
            .kmsId(kmsId?.applyValue({ args0 -> args0 }))
            .maintainTime(maintainTime?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .modifyType(modifyType?.applyValue({ args0 -> args0 }))
            .payType(payType?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityIps(securityIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var autoRenewPeriod: Output<Int>? = null

    private var computeResource: Output<String>? = null

    private var dbClusterCategory: Output<String>? = null

    private var dbClusterClass: Output<String>? = null

    private var dbClusterVersion: Output<String>? = null

    private var dbNodeClass: Output<String>? = null

    private var dbNodeCount: Output<Int>? = null

    private var dbNodeStorage: Output<Int>? = null

    private var description: Output<String>? = null

    private var diskEncryption: Output<Boolean>? = null

    private var diskPerformanceLevel: Output<String>? = null

    private var elasticIoResource: Output<Int>? = null

    private var elasticIoResourceSize: Output<String>? = null

    private var kmsId: Output<String>? = null

    private var maintainTime: Output<String>? = null

    private var mode: Output<String>? = null

    private var modifyType: Output<String>? = null

    private var payType: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var renewalStatus: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityIps: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
     */
    @JvmName("vwlcqfrjeedlxxht")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value
     */
    @JvmName("nivfcmjhsdlkourj")
    public suspend fun computeResource(`value`: Output<String>) {
        this.computeResource = value
    }

    /**
     * @param value Cluster category. Value options: `Basic`, `Cluster`.
     */
    @JvmName("pjykhxrwctbenobj")
    public suspend fun dbClusterCategory(`value`: Output<String>) {
        this.dbClusterCategory = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  It duplicates with attribute db_node_class and is deprecated from 1.121.2.
  """,
    )
    @JvmName("kmftdufvojudihku")
    public suspend fun dbClusterClass(`value`: Output<String>) {
        this.dbClusterClass = value
    }

    /**
     * @param value Cluster version. Value options: `3.0`, Default to `3.0`.
     */
    @JvmName("kmauapupnabmhbvk")
    public suspend fun dbClusterVersion(`value`: Output<String>) {
        this.dbClusterVersion = value
    }

    /**
     * @param value The db_node_class of cluster node.
     */
    @JvmName("ahnkavigawjukrlo")
    public suspend fun dbNodeClass(`value`: Output<String>) {
        this.dbNodeClass = value
    }

    /**
     * @param value The db_node_count of cluster node.
     */
    @JvmName("tkjqaiagtfnbneuj")
    public suspend fun dbNodeCount(`value`: Output<Int>) {
        this.dbNodeCount = value
    }

    /**
     * @param value The db_node_storage of cluster node.
     */
    @JvmName("ggspoblrmtpgmxay")
    public suspend fun dbNodeStorage(`value`: Output<Int>) {
        this.dbNodeStorage = value
    }

    /**
     * @param value The description of cluster.
     */
    @JvmName("hkedtvwddorqeovi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("blfrmexnajghpute")
    public suspend fun diskEncryption(`value`: Output<Boolean>) {
        this.diskEncryption = value
    }

    /**
     * @param value
     */
    @JvmName("ahrrohmuspnopesf")
    public suspend fun diskPerformanceLevel(`value`: Output<String>) {
        this.diskPerformanceLevel = value
    }

    /**
     * @param value
     */
    @JvmName("dpavprknwqulckle")
    public suspend fun elasticIoResource(`value`: Output<Int>) {
        this.elasticIoResource = value
    }

    /**
     * @param value
     */
    @JvmName("bvkcbvwpwmqerdkf")
    public suspend fun elasticIoResourceSize(`value`: Output<String>) {
        this.elasticIoResourceSize = value
    }

    /**
     * @param value
     */
    @JvmName("iahayjxlkmfeyhyj")
    public suspend fun kmsId(`value`: Output<String>) {
        this.kmsId = value
    }

    /**
     * @param value Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
     */
    @JvmName("socavauhdowygmwl")
    public suspend fun maintainTime(`value`: Output<String>) {
        this.maintainTime = value
    }

    /**
     * @param value
     */
    @JvmName("lpmopyccmlcjgcih")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value
     */
    @JvmName("xjqfdfdtmorcirbh")
    public suspend fun modifyType(`value`: Output<String>) {
        this.modifyType = value
    }

    /**
     * @param value Field `pay_type` has been deprecated. New field `payment_type` instead.
     */
    @Deprecated(
        message = """
  Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove
      in the future version. Please use the new attribute 'payment_type' instead.
  """,
    )
    @JvmName("ljqpaghvwgsckmty")
    public suspend fun payType(`value`: Output<String>) {
        this.payType = value
    }

    /**
     * @param value The payment type of the resource. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
     */
    @JvmName("arafpdvfwjgrtwbc")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1.
     */
    @JvmName("xctjxcwvmeraypun")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
     */
    @JvmName("majixrdfpbhwkbii")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value
     */
    @JvmName("awqkbyxgxjgsaupf")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("hvfaajwoynxecvrt")
    public suspend fun securityIps(`value`: Output<List<String>>) {
        this.securityIps = value
    }

    @JvmName("mmtaijnabdsiwfaa")
    public suspend fun securityIps(vararg values: Output<String>) {
        this.securityIps = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("keorkdhftrdaqkjn")
    public suspend fun securityIps(values: List<Output<String>>) {
        this.securityIps = Output.all(values)
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
     */
    @JvmName("aktwmisxblytxhef")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("vmgheonsnrprnmac")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC.
     */
    @JvmName("qtplrggngiltspwg")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Zone to launch the DB cluster.
     */
    @JvmName("wdnhktjivlprpcgp")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Auto-renewal period of an cluster, in the unit of the month. It is valid when pay_type is `PrePaid`. Valid value:1, 2, 3, 6, 12, 24, 36, Default to 1.
     */
    @JvmName("qvwxblkwsskierua")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value
     */
    @JvmName("vcomxloinlqlkbfh")
    public suspend fun computeResource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeResource = mapped
    }

    /**
     * @param value Cluster category. Value options: `Basic`, `Cluster`.
     */
    @JvmName("tngpstscmhmifeho")
    public suspend fun dbClusterCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterCategory = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  It duplicates with attribute db_node_class and is deprecated from 1.121.2.
  """,
    )
    @JvmName("bewpbldfmuanunei")
    public suspend fun dbClusterClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterClass = mapped
    }

    /**
     * @param value Cluster version. Value options: `3.0`, Default to `3.0`.
     */
    @JvmName("gbbqhclrqinrepeg")
    public suspend fun dbClusterVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterVersion = mapped
    }

    /**
     * @param value The db_node_class of cluster node.
     */
    @JvmName("vgipmpwchpjiiitk")
    public suspend fun dbNodeClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeClass = mapped
    }

    /**
     * @param value The db_node_count of cluster node.
     */
    @JvmName("bqdekpakvtrohpom")
    public suspend fun dbNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeCount = mapped
    }

    /**
     * @param value The db_node_storage of cluster node.
     */
    @JvmName("ovubvrscekfndrlf")
    public suspend fun dbNodeStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeStorage = mapped
    }

    /**
     * @param value The description of cluster.
     */
    @JvmName("oruvciiobhdchrqu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("ypjlufsvjsxsmeot")
    public suspend fun diskEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryption = mapped
    }

    /**
     * @param value
     */
    @JvmName("xwegbuiceswyfuwm")
    public suspend fun diskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskPerformanceLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("tyxumktsbvqwvffv")
    public suspend fun elasticIoResource(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticIoResource = mapped
    }

    /**
     * @param value
     */
    @JvmName("gxpyhfpsaciqumpf")
    public suspend fun elasticIoResourceSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticIoResourceSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("yvtuupohjjdcmaax")
    public suspend fun kmsId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsId = mapped
    }

    /**
     * @param value Maintainable time period format of the instance: HH:MMZ-HH:MMZ (UTC time)
     */
    @JvmName("dftvionvesebstah")
    public suspend fun maintainTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("ypvjqhsqneqmqjyi")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value
     */
    @JvmName("wgucewuhvxwwmhwd")
    public suspend fun modifyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifyType = mapped
    }

    /**
     * @param value Field `pay_type` has been deprecated. New field `payment_type` instead.
     */
    @Deprecated(
        message = """
  Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove
      in the future version. Please use the new attribute 'payment_type' instead.
  """,
    )
    @JvmName("qyrdedjslenxbeyu")
    public suspend fun payType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payType = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
     */
    @JvmName("kitcpqinokixuqiu")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The duration that you will buy DB cluster (in month). It is valid when pay_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1.
     */
    @JvmName("ejdtnofawfkvqlce")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
     */
    @JvmName("rdgbivaoyflsxieu")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value
     */
    @JvmName("wycjojtwkqicwjtk")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("wifpnkhxxfokpjoi")
    public suspend fun securityIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("hfgxoedkvsejlciw")
    public suspend fun securityIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
     */
    @JvmName("hcvodayminaadqxc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
     */
    @JvmName("efshjngycchuleau")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("nahvpunlppyivrcn")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The virtual switch ID to launch DB instances in one VPC.
     */
    @JvmName("rswbcftgiduohvgt")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Zone to launch the DB cluster.
     */
    @JvmName("ufrjhtjfymvrfwxd")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        autoRenewPeriod = autoRenewPeriod,
        computeResource = computeResource,
        dbClusterCategory = dbClusterCategory,
        dbClusterClass = dbClusterClass,
        dbClusterVersion = dbClusterVersion,
        dbNodeClass = dbNodeClass,
        dbNodeCount = dbNodeCount,
        dbNodeStorage = dbNodeStorage,
        description = description,
        diskEncryption = diskEncryption,
        diskPerformanceLevel = diskPerformanceLevel,
        elasticIoResource = elasticIoResource,
        elasticIoResourceSize = elasticIoResourceSize,
        kmsId = kmsId,
        maintainTime = maintainTime,
        mode = mode,
        modifyType = modifyType,
        payType = payType,
        paymentType = paymentType,
        period = period,
        renewalStatus = renewalStatus,
        resourceGroupId = resourceGroupId,
        securityIps = securityIps,
        tags = tags,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
