@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Connection].
 */
@PulumiTagMarker
public class ConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionArgs = ConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionArgsBuilder.() -> Unit) {
        val builder = ConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Connection {
        val builtJavaResource = com.pulumi.alicloud.adb.Connection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connection(builtJavaResource)
    }
}

/**
 * Provides an ADB connection resource to allocate an Internet connection string for ADB cluster.
 * > **NOTE:** Each ADB instance will allocate a intranet connnection string automatically and its prifix is ADB instance ID.
 *  To avoid unnecessary conflict, please specified a internet connection prefix before applying the resource.
 * > **NOTE:** Available since v1.81.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.adb.getZones({});
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[0],
 * }));
 * const vswitchId = defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]);
 * const cluster = new alicloud.adb.DBCluster("cluster", {
 *     dbClusterCategory: "MixedStorage",
 *     mode: "flexible",
 *     computeResource: "8Core32GB",
 *     vswitchId: vswitchId,
 *     description: name,
 * });
 * const defaultConnection = new alicloud.adb.Connection("default", {
 *     dbClusterId: cluster.id,
 *     connectionPrefix: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.adb.get_zones()
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[0])
 * vswitch_id = default_get_switches.ids[0]
 * cluster = alicloud.adb.DBCluster("cluster",
 *     db_cluster_category="MixedStorage",
 *     mode="flexible",
 *     compute_resource="8Core32GB",
 *     vswitch_id=vswitch_id,
 *     description=name)
 * default_connection = alicloud.adb.Connection("default",
 *     db_cluster_id=cluster.id,
 *     connection_prefix="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Adb.GetZones.Invoke();
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[0]),
 *     });
 *     var vswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]);
 *     var cluster = new AliCloud.Adb.DBCluster("cluster", new()
 *     {
 *         DbClusterCategory = "MixedStorage",
 *         Mode = "flexible",
 *         ComputeResource = "8Core32GB",
 *         VswitchId = vswitchId,
 *         Description = name,
 *     });
 *     var defaultConnection = new AliCloud.Adb.Connection("default", new()
 *     {
 *         DbClusterId = cluster.Id,
 *         ConnectionPrefix = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := adb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vswitchId := defaultGetSwitches.Ids[0]
 * 		cluster, err := adb.NewDBCluster(ctx, "cluster", &adb.DBClusterArgs{
 * 			DbClusterCategory: pulumi.String("MixedStorage"),
 * 			Mode:              pulumi.String("flexible"),
 * 			ComputeResource:   pulumi.String("8Core32GB"),
 * 			VswitchId:         pulumi.String(vswitchId),
 * 			Description:       pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = adb.NewConnection(ctx, "default", &adb.ConnectionArgs{
 * 			DbClusterId:      cluster.ID(),
 * 			ConnectionPrefix: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.adb.AdbFunctions;
 * import com.pulumi.alicloud.adb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.adb.DBCluster;
 * import com.pulumi.alicloud.adb.DBClusterArgs;
 * import com.pulumi.alicloud.adb.Connection;
 * import com.pulumi.alicloud.adb.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AdbFunctions.getZones();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[0])
 *             .build());
 *         final var vswitchId = defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]);
 *         var cluster = new DBCluster("cluster", DBClusterArgs.builder()
 *             .dbClusterCategory("MixedStorage")
 *             .mode("flexible")
 *             .computeResource("8Core32GB")
 *             .vswitchId(vswitchId)
 *             .description(name)
 *             .build());
 *         var defaultConnection = new Connection("defaultConnection", ConnectionArgs.builder()
 *             .dbClusterId(cluster.id())
 *             .connectionPrefix("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   cluster:
 *     type: alicloud:adb:DBCluster
 *     properties:
 *       dbClusterCategory: MixedStorage
 *       mode: flexible
 *       computeResource: 8Core32GB
 *       vswitchId: ${vswitchId}
 *       description: ${name}
 *   defaultConnection:
 *     type: alicloud:adb:Connection
 *     name: default
 *     properties:
 *       dbClusterId: ${cluster.id}
 *       connectionPrefix: example
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:adb:getZones
 *       Arguments: {}
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[0]}
 *   vswitchId: ${defaultGetSwitches.ids[0]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ADB connection can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/connection:Connection example am-12345678
 * ```
 */
public class Connection internal constructor(
    override val javaResource: com.pulumi.alicloud.adb.Connection,
) : KotlinCustomResource(javaResource, ConnectionMapper) {
    /**
     * Prefix of the cluster public endpoint. The prefix must be 6 to 30 characters in length, and can contain lowercase letters, digits, and hyphens (-), must start with a letter and end with a digit or letter. Default to `<db_cluster_id> + tf`.
     */
    public val connectionPrefix: Output<String>
        get() = javaResource.connectionPrefix().applyValue({ args0 -> args0 })

    /**
     * Connection cluster string.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * The Id of cluster that can run database.
     */
    public val dbClusterId: Output<String>
        get() = javaResource.dbClusterId().applyValue({ args0 -> args0 })

    /**
     * The ip address of connection string.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * Connection cluster port.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })
}

public object ConnectionMapper : ResourceMapper<Connection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.adb.Connection::class == javaResource::class

    override fun map(javaResource: Resource): Connection = Connection(
        javaResource as
            com.pulumi.alicloud.adb.Connection,
    )
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connection].
 */
public suspend fun connection(name: String, block: suspend ConnectionResourceBuilder.() -> Unit): Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connection(name: String): Connection {
    val builder = ConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
