@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [DBCluster].
 */
@PulumiTagMarker
public class DBClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DBClusterArgs = DBClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DBClusterArgsBuilder.() -> Unit) {
        val builder = DBClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DBCluster {
        val builtJavaResource = com.pulumi.alicloud.adb.DBCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DBCluster(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * AnalyticDB for MySQL (ADB) DBCluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/dBCluster:DBCluster example <id>
 * ```
 */
public class DBCluster internal constructor(
    override val javaResource: com.pulumi.alicloud.adb.DBCluster,
) : KotlinCustomResource(javaResource, DBClusterMapper) {
    /**
     * Auto-renewal period of an cluster, in the unit of the month. It is valid when `payment_type` is `Subscription`. Valid values: `1`, `2`, `3`, `6`, `12`, `24`, `36`. Default Value: `1`.
     */
    public val autoRenewPeriod: Output<Int>
        get() = javaResource.autoRenewPeriod().applyValue({ args0 -> args0 })

    /**
     * The specifications of computing resources in elastic mode. The increase of resources can speed up queries. AnalyticDB for MySQL automatically scales computing resources. For more information, see [ComputeResource](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2019-03-15-describecomputeresource)
     */
    public val computeResource: Output<String>?
        get() = javaResource.computeResource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The connection string of the cluster.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * The db cluster category. Valid values: `Basic`, `Cluster`, `MixedStorage`.
     */
    public val dbClusterCategory: Output<String>
        get() = javaResource.dbClusterCategory().applyValue({ args0 -> args0 })

    /**
     * It duplicates with attribute db_node_class and is deprecated from 1.121.2.
     */
    @Deprecated(
        message = """
  It duplicates with attribute db_node_class and is deprecated from 1.121.2.
  """,
    )
    public val dbClusterClass: Output<String>?
        get() = javaResource.dbClusterClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The db cluster version. Valid values: `3.0`. Default Value: `3.0`.
     */
    public val dbClusterVersion: Output<String>?
        get() = javaResource.dbClusterVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The db node class. For more information, see [DBClusterClass](https://help.aliyun.com/document_detail/190519.html)
     */
    public val dbNodeClass: Output<String>
        get() = javaResource.dbNodeClass().applyValue({ args0 -> args0 })

    /**
     * The db node count.
     */
    public val dbNodeCount: Output<Int>
        get() = javaResource.dbNodeCount().applyValue({ args0 -> args0 })

    /**
     * The db node storage.
     */
    public val dbNodeStorage: Output<Int>
        get() = javaResource.dbNodeStorage().applyValue({ args0 -> args0 })

    /**
     * The description of DBCluster.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable disk encryption. Default Value: `false`. Valid values: `true`, `false`.
     */
    public val diskEncryption: Output<Boolean>?
        get() = javaResource.diskEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ESSD performance level. Default Value: `PL1`. Valid values: `PL1`, `PL2`, `PL3`.
     */
    public val diskPerformanceLevel: Output<String>
        get() = javaResource.diskPerformanceLevel().applyValue({ args0 -> args0 })

    /**
     * The elastic io resource.
     */
    public val elasticIoResource: Output<Int>
        get() = javaResource.elasticIoResource().applyValue({ args0 -> args0 })

    /**
     * The specifications of a single elastic resource node. Default Value: `8Core64GB`. Valid values:
     * - `8Core64GB`: If you set `elastic_io_resource_size` to `8Core64GB`, the specifications of an EIU are 24 cores and 192 GB memory.
     * - `12Core96GB`: If you set `elastic_io_resource_size` to `12Core96GB`, the specifications of an EIU are 36 cores and 288 GB memory.
     */
    public val elasticIoResourceSize: Output<String>
        get() = javaResource.elasticIoResourceSize().applyValue({ args0 -> args0 })

    /**
     * The Key Management Service (KMS) ID that is used for disk encryption. `kms_id` is valid only when `disk_encryption` is set to `true`.
     */
    public val kmsId: Output<String>?
        get() = javaResource.kmsId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maintenance window of the cluster. Format: hh:mmZ-hh:mmZ.
     */
    public val maintainTime: Output<String>
        get() = javaResource.maintainTime().applyValue({ args0 -> args0 })

    /**
     * The mode of the cluster. Valid values: `reserver`, `flexible`.
     */
    public val mode: Output<String>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    /**
     * The modify type.
     */
    public val modifyType: Output<String>?
        get() = javaResource.modifyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field `pay_type` has been deprecated. New field `payment_type` instead.
     */
    @Deprecated(
        message = """
  Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove
      in the future version. Please use the new attribute 'payment_type' instead.
  """,
    )
    public val payType: Output<String>
        get() = javaResource.payType().applyValue({ args0 -> args0 })

    /**
     * The payment type of the resource. Valid values: `PayAsYouGo` and `Subscription`. Default Value: `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The duration that you will buy DB cluster (in month). It is valid when `payment_type` is `Subscription`. Valid values: [1~9], 12, 24, 36.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * (Available since v1.196.0) The connection port of the ADB cluster.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
     */
    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    public val securityIps: Output<List<String>>
        get() = javaResource.securityIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The vpc ID of the resource.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The vswitch id.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The zone ID of the resource.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object DBClusterMapper : ResourceMapper<DBCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.adb.DBCluster::class == javaResource::class

    override fun map(javaResource: Resource): DBCluster = DBCluster(
        javaResource as
            com.pulumi.alicloud.adb.DBCluster,
    )
}

/**
 * @see [DBCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DBCluster].
 */
public suspend fun dbCluster(name: String, block: suspend DBClusterResourceBuilder.() -> Unit): DBCluster {
    val builder = DBClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DBCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dbCluster(name: String): DBCluster {
    val builder = DBClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
