@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.alicloud.adb.DBClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * AnalyticDB for MySQL (ADB) DBCluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/dBCluster:DBCluster example <id>
 * ```
 * @property autoRenewPeriod Auto-renewal period of an cluster, in the unit of the month. It is valid when `payment_type` is `Subscription`. Valid values: `1`, `2`, `3`, `6`, `12`, `24`, `36`. Default Value: `1`.
 * @property computeResource The specifications of computing resources in elastic mode. The increase of resources can speed up queries. AnalyticDB for MySQL automatically scales computing resources. For more information, see [ComputeResource](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2019-03-15-describecomputeresource)
 * @property dbClusterCategory The db cluster category. Valid values: `Basic`, `Cluster`, `MixedStorage`.
 * @property dbClusterClass It duplicates with attribute db_node_class and is deprecated from 1.121.2.
 * @property dbClusterVersion The db cluster version. Valid values: `3.0`. Default Value: `3.0`.
 * @property dbNodeClass The db node class. For more information, see [DBClusterClass](https://help.aliyun.com/document_detail/190519.html)
 * @property dbNodeCount The db node count.
 * @property dbNodeStorage The db node storage.
 * @property description The description of DBCluster.
 * @property diskEncryption Specifies whether to enable disk encryption. Default Value: `false`. Valid values: `true`, `false`.
 * @property diskPerformanceLevel The ESSD performance level. Default Value: `PL1`. Valid values: `PL1`, `PL2`, `PL3`.
 * @property elasticIoResource The elastic io resource.
 * @property elasticIoResourceSize The specifications of a single elastic resource node. Default Value: `8Core64GB`. Valid values:
 * - `8Core64GB`: If you set `elastic_io_resource_size` to `8Core64GB`, the specifications of an EIU are 24 cores and 192 GB memory.
 * - `12Core96GB`: If you set `elastic_io_resource_size` to `12Core96GB`, the specifications of an EIU are 36 cores and 288 GB memory.
 * @property kmsId The Key Management Service (KMS) ID that is used for disk encryption. `kms_id` is valid only when `disk_encryption` is set to `true`.
 * @property maintainTime The maintenance window of the cluster. Format: hh:mmZ-hh:mmZ.
 * @property mode The mode of the cluster. Valid values: `reserver`, `flexible`.
 * @property modifyType The modify type.
 * @property payType Field `pay_type` has been deprecated. New field `payment_type` instead.
 * @property paymentType The payment type of the resource. Valid values: `PayAsYouGo` and `Subscription`. Default Value: `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
 * @property period The duration that you will buy DB cluster (in month). It is valid when `payment_type` is `Subscription`. Valid values: [1~9], 12, 24, 36.
 * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
 * @property renewalStatus Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
 * @property resourceGroupId The ID of the resource group.
 * @property securityIps List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
 * @property vpcId The vpc ID of the resource.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone ID of the resource.
 */
public data class DBClusterArgs(
    public val autoRenewPeriod: Output<Int>? = null,
    public val computeResource: Output<String>? = null,
    public val dbClusterCategory: Output<String>? = null,
    @Deprecated(
        message = """
  It duplicates with attribute db_node_class and is deprecated from 1.121.2.
  """,
    )
    public val dbClusterClass: Output<String>? = null,
    public val dbClusterVersion: Output<String>? = null,
    public val dbNodeClass: Output<String>? = null,
    public val dbNodeCount: Output<Int>? = null,
    public val dbNodeStorage: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val diskEncryption: Output<Boolean>? = null,
    public val diskPerformanceLevel: Output<String>? = null,
    public val elasticIoResource: Output<Int>? = null,
    public val elasticIoResourceSize: Output<String>? = null,
    public val kmsId: Output<String>? = null,
    public val maintainTime: Output<String>? = null,
    public val mode: Output<String>? = null,
    public val modifyType: Output<String>? = null,
    @Deprecated(
        message = """
  Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove
      in the future version. Please use the new attribute 'payment_type' instead.
  """,
    )
    public val payType: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val renewalStatus: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityIps: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.adb.DBClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.adb.DBClusterArgs =
        com.pulumi.alicloud.adb.DBClusterArgs.builder()
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .computeResource(computeResource?.applyValue({ args0 -> args0 }))
            .dbClusterCategory(dbClusterCategory?.applyValue({ args0 -> args0 }))
            .dbClusterClass(dbClusterClass?.applyValue({ args0 -> args0 }))
            .dbClusterVersion(dbClusterVersion?.applyValue({ args0 -> args0 }))
            .dbNodeClass(dbNodeClass?.applyValue({ args0 -> args0 }))
            .dbNodeCount(dbNodeCount?.applyValue({ args0 -> args0 }))
            .dbNodeStorage(dbNodeStorage?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .diskEncryption(diskEncryption?.applyValue({ args0 -> args0 }))
            .diskPerformanceLevel(diskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .elasticIoResource(elasticIoResource?.applyValue({ args0 -> args0 }))
            .elasticIoResourceSize(elasticIoResourceSize?.applyValue({ args0 -> args0 }))
            .kmsId(kmsId?.applyValue({ args0 -> args0 }))
            .maintainTime(maintainTime?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .modifyType(modifyType?.applyValue({ args0 -> args0 }))
            .payType(payType?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityIps(securityIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DBClusterArgs].
 */
@PulumiTagMarker
public class DBClusterArgsBuilder internal constructor() {
    private var autoRenewPeriod: Output<Int>? = null

    private var computeResource: Output<String>? = null

    private var dbClusterCategory: Output<String>? = null

    private var dbClusterClass: Output<String>? = null

    private var dbClusterVersion: Output<String>? = null

    private var dbNodeClass: Output<String>? = null

    private var dbNodeCount: Output<Int>? = null

    private var dbNodeStorage: Output<Int>? = null

    private var description: Output<String>? = null

    private var diskEncryption: Output<Boolean>? = null

    private var diskPerformanceLevel: Output<String>? = null

    private var elasticIoResource: Output<Int>? = null

    private var elasticIoResourceSize: Output<String>? = null

    private var kmsId: Output<String>? = null

    private var maintainTime: Output<String>? = null

    private var mode: Output<String>? = null

    private var modifyType: Output<String>? = null

    private var payType: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var renewalStatus: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityIps: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Auto-renewal period of an cluster, in the unit of the month. It is valid when `payment_type` is `Subscription`. Valid values: `1`, `2`, `3`, `6`, `12`, `24`, `36`. Default Value: `1`.
     */
    @JvmName("uoyxowajfvecowto")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The specifications of computing resources in elastic mode. The increase of resources can speed up queries. AnalyticDB for MySQL automatically scales computing resources. For more information, see [ComputeResource](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2019-03-15-describecomputeresource)
     */
    @JvmName("hwxfasfdppcuutwd")
    public suspend fun computeResource(`value`: Output<String>) {
        this.computeResource = value
    }

    /**
     * @param value The db cluster category. Valid values: `Basic`, `Cluster`, `MixedStorage`.
     */
    @JvmName("lptoyxntlrtpwtes")
    public suspend fun dbClusterCategory(`value`: Output<String>) {
        this.dbClusterCategory = value
    }

    /**
     * @param value It duplicates with attribute db_node_class and is deprecated from 1.121.2.
     */
    @Deprecated(
        message = """
  It duplicates with attribute db_node_class and is deprecated from 1.121.2.
  """,
    )
    @JvmName("itkqwglhksiycpfn")
    public suspend fun dbClusterClass(`value`: Output<String>) {
        this.dbClusterClass = value
    }

    /**
     * @param value The db cluster version. Valid values: `3.0`. Default Value: `3.0`.
     */
    @JvmName("imhayupqebmdexan")
    public suspend fun dbClusterVersion(`value`: Output<String>) {
        this.dbClusterVersion = value
    }

    /**
     * @param value The db node class. For more information, see [DBClusterClass](https://help.aliyun.com/document_detail/190519.html)
     */
    @JvmName("aduxdglpgjjnoaqb")
    public suspend fun dbNodeClass(`value`: Output<String>) {
        this.dbNodeClass = value
    }

    /**
     * @param value The db node count.
     */
    @JvmName("cupkalsoriwermob")
    public suspend fun dbNodeCount(`value`: Output<Int>) {
        this.dbNodeCount = value
    }

    /**
     * @param value The db node storage.
     */
    @JvmName("muymconxoujrnyse")
    public suspend fun dbNodeStorage(`value`: Output<Int>) {
        this.dbNodeStorage = value
    }

    /**
     * @param value The description of DBCluster.
     */
    @JvmName("ivecbytfyghdxcuf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to enable disk encryption. Default Value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("hupluobortqqeptg")
    public suspend fun diskEncryption(`value`: Output<Boolean>) {
        this.diskEncryption = value
    }

    /**
     * @param value The ESSD performance level. Default Value: `PL1`. Valid values: `PL1`, `PL2`, `PL3`.
     */
    @JvmName("ukukjwssulebegim")
    public suspend fun diskPerformanceLevel(`value`: Output<String>) {
        this.diskPerformanceLevel = value
    }

    /**
     * @param value The elastic io resource.
     */
    @JvmName("wequeyyebjmoqmsd")
    public suspend fun elasticIoResource(`value`: Output<Int>) {
        this.elasticIoResource = value
    }

    /**
     * @param value The specifications of a single elastic resource node. Default Value: `8Core64GB`. Valid values:
     * - `8Core64GB`: If you set `elastic_io_resource_size` to `8Core64GB`, the specifications of an EIU are 24 cores and 192 GB memory.
     * - `12Core96GB`: If you set `elastic_io_resource_size` to `12Core96GB`, the specifications of an EIU are 36 cores and 288 GB memory.
     */
    @JvmName("knhhbnboohlfgmqp")
    public suspend fun elasticIoResourceSize(`value`: Output<String>) {
        this.elasticIoResourceSize = value
    }

    /**
     * @param value The Key Management Service (KMS) ID that is used for disk encryption. `kms_id` is valid only when `disk_encryption` is set to `true`.
     */
    @JvmName("gqdvqdrrjqwdffkb")
    public suspend fun kmsId(`value`: Output<String>) {
        this.kmsId = value
    }

    /**
     * @param value The maintenance window of the cluster. Format: hh:mmZ-hh:mmZ.
     */
    @JvmName("sauviysplbtuoxeq")
    public suspend fun maintainTime(`value`: Output<String>) {
        this.maintainTime = value
    }

    /**
     * @param value The mode of the cluster. Valid values: `reserver`, `flexible`.
     */
    @JvmName("trjhjmxbuebajfli")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The modify type.
     */
    @JvmName("aewyqtcntkhyqibs")
    public suspend fun modifyType(`value`: Output<String>) {
        this.modifyType = value
    }

    /**
     * @param value Field `pay_type` has been deprecated. New field `payment_type` instead.
     */
    @Deprecated(
        message = """
  Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove
      in the future version. Please use the new attribute 'payment_type' instead.
  """,
    )
    @JvmName("xesfmonvvxawbcsu")
    public suspend fun payType(`value`: Output<String>) {
        this.payType = value
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo` and `Subscription`. Default Value: `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
     */
    @JvmName("svpvqqmdtlrtgibd")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The duration that you will buy DB cluster (in month). It is valid when `payment_type` is `Subscription`. Valid values: [1~9], 12, 24, 36.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
     */
    @JvmName("orguqpjvarbwdbqu")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
     */
    @JvmName("pesbnlflkuxgwkmg")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("cffhnmaegdvlqffa")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("bddxlogmxiumoybr")
    public suspend fun securityIps(`value`: Output<List<String>>) {
        this.securityIps = value
    }

    @JvmName("uogkoghtvqyspexk")
    public suspend fun securityIps(vararg values: Output<String>) {
        this.securityIps = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("pexxkfndjrkxvqag")
    public suspend fun securityIps(values: List<Output<String>>) {
        this.securityIps = Output.all(values)
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
     */
    @JvmName("ukoyuatlrlydeula")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The vpc ID of the resource.
     */
    @JvmName("gfjvglqopdlktuci")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("xhyhyaqepegdqckx")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the resource.
     */
    @JvmName("hwxoqxswhifjbpkg")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Auto-renewal period of an cluster, in the unit of the month. It is valid when `payment_type` is `Subscription`. Valid values: `1`, `2`, `3`, `6`, `12`, `24`, `36`. Default Value: `1`.
     */
    @JvmName("cyhavafikqwjmuvd")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The specifications of computing resources in elastic mode. The increase of resources can speed up queries. AnalyticDB for MySQL automatically scales computing resources. For more information, see [ComputeResource](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2019-03-15-describecomputeresource)
     */
    @JvmName("bfpnayqjfwlliggp")
    public suspend fun computeResource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeResource = mapped
    }

    /**
     * @param value The db cluster category. Valid values: `Basic`, `Cluster`, `MixedStorage`.
     */
    @JvmName("dkagnhdoxqdqjphw")
    public suspend fun dbClusterCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterCategory = mapped
    }

    /**
     * @param value It duplicates with attribute db_node_class and is deprecated from 1.121.2.
     */
    @Deprecated(
        message = """
  It duplicates with attribute db_node_class and is deprecated from 1.121.2.
  """,
    )
    @JvmName("vyunveudbuxrafiv")
    public suspend fun dbClusterClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterClass = mapped
    }

    /**
     * @param value The db cluster version. Valid values: `3.0`. Default Value: `3.0`.
     */
    @JvmName("pxcdoyllsujrslip")
    public suspend fun dbClusterVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterVersion = mapped
    }

    /**
     * @param value The db node class. For more information, see [DBClusterClass](https://help.aliyun.com/document_detail/190519.html)
     */
    @JvmName("hibiiiaaqfrnaehu")
    public suspend fun dbNodeClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeClass = mapped
    }

    /**
     * @param value The db node count.
     */
    @JvmName("ycnqtpxsmyvosqwl")
    public suspend fun dbNodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeCount = mapped
    }

    /**
     * @param value The db node storage.
     */
    @JvmName("xfkdasaychdchmar")
    public suspend fun dbNodeStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbNodeStorage = mapped
    }

    /**
     * @param value The description of DBCluster.
     */
    @JvmName("rhmxdtrwdldscfae")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to enable disk encryption. Default Value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("ggeoyvnyvxmqpwra")
    public suspend fun diskEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryption = mapped
    }

    /**
     * @param value The ESSD performance level. Default Value: `PL1`. Valid values: `PL1`, `PL2`, `PL3`.
     */
    @JvmName("qqvutjjemgvxjmmb")
    public suspend fun diskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskPerformanceLevel = mapped
    }

    /**
     * @param value The elastic io resource.
     */
    @JvmName("fndrpqewhdvjulum")
    public suspend fun elasticIoResource(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticIoResource = mapped
    }

    /**
     * @param value The specifications of a single elastic resource node. Default Value: `8Core64GB`. Valid values:
     * - `8Core64GB`: If you set `elastic_io_resource_size` to `8Core64GB`, the specifications of an EIU are 24 cores and 192 GB memory.
     * - `12Core96GB`: If you set `elastic_io_resource_size` to `12Core96GB`, the specifications of an EIU are 36 cores and 288 GB memory.
     */
    @JvmName("dsaunndqhquohfcm")
    public suspend fun elasticIoResourceSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticIoResourceSize = mapped
    }

    /**
     * @param value The Key Management Service (KMS) ID that is used for disk encryption. `kms_id` is valid only when `disk_encryption` is set to `true`.
     */
    @JvmName("bdcuvthjwkvribcc")
    public suspend fun kmsId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsId = mapped
    }

    /**
     * @param value The maintenance window of the cluster. Format: hh:mmZ-hh:mmZ.
     */
    @JvmName("nqkmtekccrrvjtot")
    public suspend fun maintainTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainTime = mapped
    }

    /**
     * @param value The mode of the cluster. Valid values: `reserver`, `flexible`.
     */
    @JvmName("evgaffxsjjkaibay")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The modify type.
     */
    @JvmName("krikasieygktvjmt")
    public suspend fun modifyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifyType = mapped
    }

    /**
     * @param value Field `pay_type` has been deprecated. New field `payment_type` instead.
     */
    @Deprecated(
        message = """
  Attribute 'pay_type' has been deprecated from the provider version 1.166.0 and it will be remove
      in the future version. Please use the new attribute 'payment_type' instead.
  """,
    )
    @JvmName("jdolcjagjiflnlwl")
    public suspend fun payType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payType = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo` and `Subscription`. Default Value: `PayAsYouGo`. **Note:** The `payment_type` supports updating from v1.166.0+.
     */
    @JvmName("xlmhcsmpsrpdxbeo")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The duration that you will buy DB cluster (in month). It is valid when `payment_type` is `Subscription`. Valid values: [1~9], 12, 24, 36.
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not affect the resource.
     */
    @JvmName("ixsgljrmncdsqitb")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Valid values are `AutoRenewal`, `Normal`, `NotRenewal`, Default to `NotRenewal`.
     */
    @JvmName("qwgjygtyusmcdnjb")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("jekynbnrngodqswo")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("wehqntgsnrjgcxey")
    public suspend fun securityIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param values List of IP addresses allowed to access all databases of an cluster. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
     */
    @JvmName("nknrkyocygvnxomf")
    public suspend fun securityIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
     */
    @JvmName("saebishdddffvlmg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     * > **NOTE:** Because of data backup and migration, change DB cluster type and storage would cost 15~30 minutes. Please make full preparation before changing them.
     */
    @JvmName("pebrqasdobfbfpuv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The vpc ID of the resource.
     */
    @JvmName("mopvguyycedogclt")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("baxyjrulbnciwbim")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the resource.
     */
    @JvmName("roxbswmkglxochfq")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DBClusterArgs = DBClusterArgs(
        autoRenewPeriod = autoRenewPeriod,
        computeResource = computeResource,
        dbClusterCategory = dbClusterCategory,
        dbClusterClass = dbClusterClass,
        dbClusterVersion = dbClusterVersion,
        dbNodeClass = dbNodeClass,
        dbNodeCount = dbNodeCount,
        dbNodeStorage = dbNodeStorage,
        description = description,
        diskEncryption = diskEncryption,
        diskPerformanceLevel = diskPerformanceLevel,
        elasticIoResource = elasticIoResource,
        elasticIoResourceSize = elasticIoResourceSize,
        kmsId = kmsId,
        maintainTime = maintainTime,
        mode = mode,
        modifyType = modifyType,
        payType = payType,
        paymentType = paymentType,
        period = period,
        renewalStatus = renewalStatus,
        resourceGroupId = resourceGroupId,
        securityIps = securityIps,
        tags = tags,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
