@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DBClusterLakeVersion].
 */
@PulumiTagMarker
public class DBClusterLakeVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DBClusterLakeVersionArgs = DBClusterLakeVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DBClusterLakeVersionArgsBuilder.() -> Unit) {
        val builder = DBClusterLakeVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DBClusterLakeVersion {
        val builtJavaResource = com.pulumi.alicloud.adb.DBClusterLakeVersion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DBClusterLakeVersion(builtJavaResource)
    }
}

/**
 * Provides a AnalyticDB for MySQL (ADB) DB Cluster Lake Version resource.
 * For information about AnalyticDB for MySQL (ADB) DB Cluster Lake Version and how to use it, see [What is DB Cluster Lake Version](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2021-12-01-createdbcluster).
 * > **NOTE:** Available since v1.190.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.adb.getZones({});
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[0],
 * }));
 * const defaultDBClusterLakeVersion = new alicloud.adb.DBClusterLakeVersion("default", {
 *     dbClusterVersion: "5.0",
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     zoneId: _default.then(_default => _default.ids?.[0]),
 *     computeResource: "16ACU",
 *     storageResource: "0ACU",
 *     paymentType: "PayAsYouGo",
 *     enableDefaultResourceGroup: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.adb.get_zones()
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[0])
 * default_db_cluster_lake_version = alicloud.adb.DBClusterLakeVersion("default",
 *     db_cluster_version="5.0",
 *     vpc_id=default_get_networks.ids[0],
 *     vswitch_id=default_get_switches.ids[0],
 *     zone_id=default.ids[0],
 *     compute_resource="16ACU",
 *     storage_resource="0ACU",
 *     payment_type="PayAsYouGo",
 *     enable_default_resource_group=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Adb.GetZones.Invoke();
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[0]),
 *     });
 *     var defaultDBClusterLakeVersion = new AliCloud.Adb.DBClusterLakeVersion("default", new()
 *     {
 *         DbClusterVersion = "5.0",
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids[0])),
 *         ComputeResource = "16ACU",
 *         StorageResource = "0ACU",
 *         PaymentType = "PayAsYouGo",
 *         EnableDefaultResourceGroup = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := adb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = adb.NewDBClusterLakeVersion(ctx, "default", &adb.DBClusterLakeVersionArgs{
 * 			DbClusterVersion:           pulumi.String("5.0"),
 * 			VpcId:                      pulumi.String(defaultGetNetworks.Ids[0]),
 * 			VswitchId:                  pulumi.String(defaultGetSwitches.Ids[0]),
 * 			ZoneId:                     pulumi.String(_default.Ids[0]),
 * 			ComputeResource:            pulumi.String("16ACU"),
 * 			StorageResource:            pulumi.String("0ACU"),
 * 			PaymentType:                pulumi.String("PayAsYouGo"),
 * 			EnableDefaultResourceGroup: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.adb.AdbFunctions;
 * import com.pulumi.alicloud.adb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.adb.DBClusterLakeVersion;
 * import com.pulumi.alicloud.adb.DBClusterLakeVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AdbFunctions.getZones();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[0])
 *             .build());
 *         var defaultDBClusterLakeVersion = new DBClusterLakeVersion("defaultDBClusterLakeVersion", DBClusterLakeVersionArgs.builder()
 *             .dbClusterVersion("5.0")
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .zoneId(default_.ids()[0])
 *             .computeResource("16ACU")
 *             .storageResource("0ACU")
 *             .paymentType("PayAsYouGo")
 *             .enableDefaultResourceGroup(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultDBClusterLakeVersion:
 *     type: alicloud:adb:DBClusterLakeVersion
 *     name: default
 *     properties:
 *       dbClusterVersion: '5.0'
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       zoneId: ${default.ids[0]}
 *       computeResource: 16ACU
 *       storageResource: 0ACU
 *       paymentType: PayAsYouGo
 *       enableDefaultResourceGroup: false
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:adb:getZones
 *       Arguments: {}
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[0]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * AnalyticDB for MySQL (ADB) DB Cluster Lake Version can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/dBClusterLakeVersion:DBClusterLakeVersion example <id>
 * ```
 */
public class DBClusterLakeVersion internal constructor(
    override val javaResource: com.pulumi.alicloud.adb.DBClusterLakeVersion,
) : KotlinCustomResource(javaResource, DBClusterLakeVersionMapper) {
    /**
     * The ID of the backup set that you want to use to restore data.
     */
    public val backupSetId: Output<String>?
        get() = javaResource.backupSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the service.
     */
    public val commodityCode: Output<String>
        get() = javaResource.commodityCode().applyValue({ args0 -> args0 })

    /**
     * The computing resources of the cluster.
     */
    public val computeResource: Output<String>
        get() = javaResource.computeResource().applyValue({ args0 -> args0 })

    /**
     * The endpoint of the cluster.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * The createTime of the cluster.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the cluster.
     */
    public val dbClusterDescription: Output<String>
        get() = javaResource.dbClusterDescription().applyValue({ args0 -> args0 })

    /**
     * The version of the cluster. Valid values: `5.0`.
     */
    public val dbClusterVersion: Output<String>
        get() = javaResource.dbClusterVersion().applyValue({ args0 -> args0 })

    /**
     * Whether to enable default allocation of resources to user_default resource groups.
     */
    public val enableDefaultResourceGroup: Output<Boolean>?
        get() = javaResource.enableDefaultResourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The engine of the database.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The engine version of the database.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The time when the cluster expires.
     */
    public val expireTime: Output<String>
        get() = javaResource.expireTime().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the cluster has expired.
     */
    public val expired: Output<String>
        get() = javaResource.expired().applyValue({ args0 -> args0 })

    /**
     * The lock mode of the cluster.
     */
    public val lockMode: Output<String>
        get() = javaResource.lockMode().applyValue({ args0 -> args0 })

    /**
     * The reason why the cluster is locked.
     */
    public val lockReason: Output<String>
        get() = javaResource.lockReason().applyValue({ args0 -> args0 })

    /**
     * The payment type of the resource. Valid values: `PayAsYouGo`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The port that is used to access the cluster.
     */
    public val port: Output<String>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The point in time to which you want to restore data from the backup set.
     */
    public val restoreToTime: Output<String>?
        get() = javaResource.restoreToTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The method that you want to use to restore data. Valid values:
     */
    public val restoreType: Output<String>?
        get() = javaResource.restoreType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
     * - IP addresses, such as 10.23.XX.XX.
     * - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
     */
    public val securityIps: Output<String>
        get() = javaResource.securityIps().applyValue({ args0 -> args0 })

    /**
     * The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
     */
    public val sourceDbClusterId: Output<String>?
        get() = javaResource.sourceDbClusterId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The storage resources of the cluster.
     */
    public val storageResource: Output<String>
        get() = javaResource.storageResource().applyValue({ args0 -> args0 })

    /**
     * The vpc ID of the resource.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of the vSwitch.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The zone ID of the resource.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object DBClusterLakeVersionMapper : ResourceMapper<DBClusterLakeVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.adb.DBClusterLakeVersion::class == javaResource::class

    override fun map(javaResource: Resource): DBClusterLakeVersion = DBClusterLakeVersion(
        javaResource
            as com.pulumi.alicloud.adb.DBClusterLakeVersion,
    )
}

/**
 * @see [DBClusterLakeVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DBClusterLakeVersion].
 */
public suspend fun dbClusterLakeVersion(
    name: String,
    block: suspend DBClusterLakeVersionResourceBuilder.() -> Unit,
): DBClusterLakeVersion {
    val builder = DBClusterLakeVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DBClusterLakeVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dbClusterLakeVersion(name: String): DBClusterLakeVersion {
    val builder = DBClusterLakeVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
