@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.alicloud.adb.DBClusterLakeVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a AnalyticDB for MySQL (ADB) DB Cluster Lake Version resource.
 * For information about AnalyticDB for MySQL (ADB) DB Cluster Lake Version and how to use it, see [What is DB Cluster Lake Version](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2021-12-01-createdbcluster).
 * > **NOTE:** Available since v1.190.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.adb.getZones({});
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.ids?.[0],
 * }));
 * const defaultDBClusterLakeVersion = new alicloud.adb.DBClusterLakeVersion("default", {
 *     dbClusterVersion: "5.0",
 *     vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0]),
 *     vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *     zoneId: _default.then(_default => _default.ids?.[0]),
 *     computeResource: "16ACU",
 *     storageResource: "0ACU",
 *     paymentType: "PayAsYouGo",
 *     enableDefaultResourceGroup: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.adb.get_zones()
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
 *     zone_id=default.ids[0])
 * default_db_cluster_lake_version = alicloud.adb.DBClusterLakeVersion("default",
 *     db_cluster_version="5.0",
 *     vpc_id=default_get_networks.ids[0],
 *     vswitch_id=default_get_switches.ids[0],
 *     zone_id=default.ids[0],
 *     compute_resource="16ACU",
 *     storage_resource="0ACU",
 *     payment_type="PayAsYouGo",
 *     enable_default_resource_group=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Adb.GetZones.Invoke();
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Ids[0]),
 *     });
 *     var defaultDBClusterLakeVersion = new AliCloud.Adb.DBClusterLakeVersion("default", new()
 *     {
 *         DbClusterVersion = "5.0",
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Ids[0])),
 *         ComputeResource = "16ACU",
 *         StorageResource = "0ACU",
 *         PaymentType = "PayAsYouGo",
 *         EnableDefaultResourceGroup = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := adb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId: pulumi.StringRef(_default.Ids[0]),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = adb.NewDBClusterLakeVersion(ctx, "default", &adb.DBClusterLakeVersionArgs{
 * 			DbClusterVersion:           pulumi.String("5.0"),
 * 			VpcId:                      pulumi.String(defaultGetNetworks.Ids[0]),
 * 			VswitchId:                  pulumi.String(defaultGetSwitches.Ids[0]),
 * 			ZoneId:                     pulumi.String(_default.Ids[0]),
 * 			ComputeResource:            pulumi.String("16ACU"),
 * 			StorageResource:            pulumi.String("0ACU"),
 * 			PaymentType:                pulumi.String("PayAsYouGo"),
 * 			EnableDefaultResourceGroup: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.adb.AdbFunctions;
 * import com.pulumi.alicloud.adb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.adb.DBClusterLakeVersion;
 * import com.pulumi.alicloud.adb.DBClusterLakeVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AdbFunctions.getZones();
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.ids()[0])
 *             .build());
 *         var defaultDBClusterLakeVersion = new DBClusterLakeVersion("defaultDBClusterLakeVersion", DBClusterLakeVersionArgs.builder()
 *             .dbClusterVersion("5.0")
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .zoneId(default_.ids()[0])
 *             .computeResource("16ACU")
 *             .storageResource("0ACU")
 *             .paymentType("PayAsYouGo")
 *             .enableDefaultResourceGroup(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultDBClusterLakeVersion:
 *     type: alicloud:adb:DBClusterLakeVersion
 *     name: default
 *     properties:
 *       dbClusterVersion: '5.0'
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       zoneId: ${default.ids[0]}
 *       computeResource: 16ACU
 *       storageResource: 0ACU
 *       paymentType: PayAsYouGo
 *       enableDefaultResourceGroup: false
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:adb:getZones
 *       Arguments: {}
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.ids[0]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * AnalyticDB for MySQL (ADB) DB Cluster Lake Version can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/dBClusterLakeVersion:DBClusterLakeVersion example <id>
 * ```
 * @property backupSetId The ID of the backup set that you want to use to restore data.
 * @property computeResource The computing resources of the cluster.
 * @property dbClusterDescription The description of the cluster.
 * @property dbClusterVersion The version of the cluster. Valid values: `5.0`.
 * @property enableDefaultResourceGroup Whether to enable default allocation of resources to user_default resource groups.
 * @property paymentType The payment type of the resource. Valid values: `PayAsYouGo`.
 * @property resourceGroupId The ID of the resource group.
 * @property restoreToTime The point in time to which you want to restore data from the backup set.
 * @property restoreType The method that you want to use to restore data. Valid values:
 * @property securityIps The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
 * - IP addresses, such as 10.23.XX.XX.
 * - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
 * @property sourceDbClusterId The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
 * @property storageResource The storage resources of the cluster.
 * @property vpcId The vpc ID of the resource.
 * @property vswitchId The ID of the vSwitch.
 * @property zoneId The zone ID of the resource.
 */
public data class DBClusterLakeVersionArgs(
    public val backupSetId: Output<String>? = null,
    public val computeResource: Output<String>? = null,
    public val dbClusterDescription: Output<String>? = null,
    public val dbClusterVersion: Output<String>? = null,
    public val enableDefaultResourceGroup: Output<Boolean>? = null,
    public val paymentType: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val restoreToTime: Output<String>? = null,
    public val restoreType: Output<String>? = null,
    public val securityIps: Output<String>? = null,
    public val sourceDbClusterId: Output<String>? = null,
    public val storageResource: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.adb.DBClusterLakeVersionArgs> {
    override fun toJava(): com.pulumi.alicloud.adb.DBClusterLakeVersionArgs =
        com.pulumi.alicloud.adb.DBClusterLakeVersionArgs.builder()
            .backupSetId(backupSetId?.applyValue({ args0 -> args0 }))
            .computeResource(computeResource?.applyValue({ args0 -> args0 }))
            .dbClusterDescription(dbClusterDescription?.applyValue({ args0 -> args0 }))
            .dbClusterVersion(dbClusterVersion?.applyValue({ args0 -> args0 }))
            .enableDefaultResourceGroup(enableDefaultResourceGroup?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .restoreToTime(restoreToTime?.applyValue({ args0 -> args0 }))
            .restoreType(restoreType?.applyValue({ args0 -> args0 }))
            .securityIps(securityIps?.applyValue({ args0 -> args0 }))
            .sourceDbClusterId(sourceDbClusterId?.applyValue({ args0 -> args0 }))
            .storageResource(storageResource?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DBClusterLakeVersionArgs].
 */
@PulumiTagMarker
public class DBClusterLakeVersionArgsBuilder internal constructor() {
    private var backupSetId: Output<String>? = null

    private var computeResource: Output<String>? = null

    private var dbClusterDescription: Output<String>? = null

    private var dbClusterVersion: Output<String>? = null

    private var enableDefaultResourceGroup: Output<Boolean>? = null

    private var paymentType: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var restoreToTime: Output<String>? = null

    private var restoreType: Output<String>? = null

    private var securityIps: Output<String>? = null

    private var sourceDbClusterId: Output<String>? = null

    private var storageResource: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The ID of the backup set that you want to use to restore data.
     */
    @JvmName("wfwmcjkuksoudafl")
    public suspend fun backupSetId(`value`: Output<String>) {
        this.backupSetId = value
    }

    /**
     * @param value The computing resources of the cluster.
     */
    @JvmName("ubbxemjjcjykkvxp")
    public suspend fun computeResource(`value`: Output<String>) {
        this.computeResource = value
    }

    /**
     * @param value The description of the cluster.
     */
    @JvmName("coqkrpeypiwksldg")
    public suspend fun dbClusterDescription(`value`: Output<String>) {
        this.dbClusterDescription = value
    }

    /**
     * @param value The version of the cluster. Valid values: `5.0`.
     */
    @JvmName("faahrfcctuervrwq")
    public suspend fun dbClusterVersion(`value`: Output<String>) {
        this.dbClusterVersion = value
    }

    /**
     * @param value Whether to enable default allocation of resources to user_default resource groups.
     */
    @JvmName("vrixdllcmabtanpw")
    public suspend fun enableDefaultResourceGroup(`value`: Output<Boolean>) {
        this.enableDefaultResourceGroup = value
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo`.
     */
    @JvmName("lnhhlpikprbojixq")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("ssnnmiynbtbecivs")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The point in time to which you want to restore data from the backup set.
     */
    @JvmName("ijfwphiveslxxovy")
    public suspend fun restoreToTime(`value`: Output<String>) {
        this.restoreToTime = value
    }

    /**
     * @param value The method that you want to use to restore data. Valid values:
     */
    @JvmName("etwlqxxebengplxu")
    public suspend fun restoreType(`value`: Output<String>) {
        this.restoreType = value
    }

    /**
     * @param value The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
     * - IP addresses, such as 10.23.XX.XX.
     * - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
     */
    @JvmName("rrwsjhuutoejanwo")
    public suspend fun securityIps(`value`: Output<String>) {
        this.securityIps = value
    }

    /**
     * @param value The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
     */
    @JvmName("pdsutpexnlurgcks")
    public suspend fun sourceDbClusterId(`value`: Output<String>) {
        this.sourceDbClusterId = value
    }

    /**
     * @param value The storage resources of the cluster.
     */
    @JvmName("bvdcwguwmihbxwoq")
    public suspend fun storageResource(`value`: Output<String>) {
        this.storageResource = value
    }

    /**
     * @param value The vpc ID of the resource.
     */
    @JvmName("dxneholmkffeppet")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the vSwitch.
     */
    @JvmName("euuhoodlivyvstdi")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the resource.
     */
    @JvmName("epfuqnrfhospdosj")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The ID of the backup set that you want to use to restore data.
     */
    @JvmName("utltwfjhbjsmvnle")
    public suspend fun backupSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupSetId = mapped
    }

    /**
     * @param value The computing resources of the cluster.
     */
    @JvmName("koxybktvhkvitjyu")
    public suspend fun computeResource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeResource = mapped
    }

    /**
     * @param value The description of the cluster.
     */
    @JvmName("wvhuxpxnvogqeahi")
    public suspend fun dbClusterDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterDescription = mapped
    }

    /**
     * @param value The version of the cluster. Valid values: `5.0`.
     */
    @JvmName("vgvtongoywlclbmt")
    public suspend fun dbClusterVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterVersion = mapped
    }

    /**
     * @param value Whether to enable default allocation of resources to user_default resource groups.
     */
    @JvmName("hsgxebyaovgarxpr")
    public suspend fun enableDefaultResourceGroup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDefaultResourceGroup = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `PayAsYouGo`.
     */
    @JvmName("rhffkkhcpjqcywdx")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("cupheyfaigtjtsfa")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The point in time to which you want to restore data from the backup set.
     */
    @JvmName("ldixywwayrulwpoe")
    public suspend fun restoreToTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreToTime = mapped
    }

    /**
     * @param value The method that you want to use to restore data. Valid values:
     */
    @JvmName("rgduwuyeidpfncmq")
    public suspend fun restoreType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreType = mapped
    }

    /**
     * @param value The IP addresses in an IP address whitelist of a cluster. Separate multiple IP addresses with commas (,). You can add a maximum of 500 different IP addresses to a whitelist. The entries in the IP address whitelist must be in one of the following formats:
     * - IP addresses, such as 10.23.XX.XX.
     * - CIDR blocks, such as 10.23.xx.xx/24. In this example, 24 indicates that the prefix of each IP address in the IP whitelist is 24 bits in length. You can replace 24 with a value within the range of 1 to 32.
     */
    @JvmName("hktdlesqrkimgfog")
    public suspend fun securityIps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityIps = mapped
    }

    /**
     * @param value The ID of the source AnalyticDB for MySQL Data Warehouse Edition cluster.
     */
    @JvmName("gjrywhxebcsvtkkq")
    public suspend fun sourceDbClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbClusterId = mapped
    }

    /**
     * @param value The storage resources of the cluster.
     */
    @JvmName("gnriefjexjfubgqr")
    public suspend fun storageResource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageResource = mapped
    }

    /**
     * @param value The vpc ID of the resource.
     */
    @JvmName("ohqigdgvnftydbnd")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the vSwitch.
     */
    @JvmName("bhrxeeowxarmtppb")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the resource.
     */
    @JvmName("pwgpstniikovnelq")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DBClusterLakeVersionArgs = DBClusterLakeVersionArgs(
        backupSetId = backupSetId,
        computeResource = computeResource,
        dbClusterDescription = dbClusterDescription,
        dbClusterVersion = dbClusterVersion,
        enableDefaultResourceGroup = enableDefaultResourceGroup,
        paymentType = paymentType,
        resourceGroupId = resourceGroupId,
        restoreToTime = restoreToTime,
        restoreType = restoreType,
        securityIps = securityIps,
        sourceDbClusterId = sourceDbClusterId,
        storageResource = storageResource,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
