@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.alicloud.adb.LakeAccountArgs.builder
import com.pulumi.alicloud.adb.kotlin.inputs.LakeAccountAccountPrivilegeArgs
import com.pulumi.alicloud.adb.kotlin.inputs.LakeAccountAccountPrivilegeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ADB Lake Account resource. Account of the DBClusterLakeVesion.
 * For information about ADB Lake Account and how to use it, see [What is Lake Account](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2021-12-01-createaccount).
 * For information about ADB Lake Account Privileges and how to use it, see [What are Lake Account Privileges](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/developer-reference/api-adb-2021-12-01-modifyaccountprivileges/).
 * > **NOTE:** Available since v1.214.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const VPCID = new alicloud.vpc.Network("VPCID", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const VSWITCHID = new alicloud.vpc.Switch("VSWITCHID", {
 *     vpcId: VPCID.id,
 *     zoneId: "cn-hangzhou-k",
 *     vswitchName: name,
 *     cidrBlock: "172.16.0.0/24",
 * });
 * const createInstance = new alicloud.adb.DBClusterLakeVersion("CreateInstance", {
 *     storageResource: "0ACU",
 *     zoneId: "cn-hangzhou-k",
 *     vpcId: VPCID.id,
 *     vswitchId: VSWITCHID.id,
 *     dbClusterDescription: name,
 *     computeResource: "16ACU",
 *     dbClusterVersion: "5.0",
 *     paymentType: "PayAsYouGo",
 *     securityIps: "127.0.0.1",
 * });
 * const defaultLakeAccount = new alicloud.adb.LakeAccount("default", {
 *     dbClusterId: createInstance.id,
 *     accountType: "Super",
 *     accountName: "tfnormal",
 *     accountPassword: "normal@2023",
 *     accountPrivileges: [
 *         {
 *             privilegeType: "Database",
 *             privilegeObject: {
 *                 database: "MYSQL",
 *             },
 *             privileges: [
 *                 "select",
 *                 "update",
 *             ],
 *         },
 *         {
 *             privilegeType: "Table",
 *             privilegeObject: {
 *                 database: "INFORMATION_SCHEMA",
 *                 table: "ENGINES",
 *             },
 *             privileges: ["update"],
 *         },
 *         {
 *             privilegeType: "Column",
 *             privilegeObject: {
 *                 table: "COLUMNS",
 *                 column: "PRIVILEGES",
 *                 database: "INFORMATION_SCHEMA",
 *             },
 *             privileges: ["update"],
 *         },
 *     ],
 *     accountDescription: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * vpcid = alicloud.vpc.Network("VPCID",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/12")
 * vswitchid = alicloud.vpc.Switch("VSWITCHID",
 *     vpc_id=vpcid.id,
 *     zone_id="cn-hangzhou-k",
 *     vswitch_name=name,
 *     cidr_block="172.16.0.0/24")
 * create_instance = alicloud.adb.DBClusterLakeVersion("CreateInstance",
 *     storage_resource="0ACU",
 *     zone_id="cn-hangzhou-k",
 *     vpc_id=vpcid.id,
 *     vswitch_id=vswitchid.id,
 *     db_cluster_description=name,
 *     compute_resource="16ACU",
 *     db_cluster_version="5.0",
 *     payment_type="PayAsYouGo",
 *     security_ips="127.0.0.1")
 * default_lake_account = alicloud.adb.LakeAccount("default",
 *     db_cluster_id=create_instance.id,
 *     account_type="Super",
 *     account_name="tfnormal",
 *     account_password="normal@2023",
 *     account_privileges=[
 *         {
 *             "privilege_type": "Database",
 *             "privilege_object": {
 *                 "database": "MYSQL",
 *             },
 *             "privileges": [
 *                 "select",
 *                 "update",
 *             ],
 *         },
 *         {
 *             "privilege_type": "Table",
 *             "privilege_object": {
 *                 "database": "INFORMATION_SCHEMA",
 *                 "table": "ENGINES",
 *             },
 *             "privileges": ["update"],
 *         },
 *         {
 *             "privilege_type": "Column",
 *             "privilege_object": {
 *                 "table": "COLUMNS",
 *                 "column": "PRIVILEGES",
 *                 "database": "INFORMATION_SCHEMA",
 *             },
 *             "privileges": ["update"],
 *         },
 *     ],
 *     account_description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var VPCID = new AliCloud.Vpc.Network("VPCID", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var VSWITCHID = new AliCloud.Vpc.Switch("VSWITCHID", new()
 *     {
 *         VpcId = VPCID.Id,
 *         ZoneId = "cn-hangzhou-k",
 *         VswitchName = name,
 *         CidrBlock = "172.16.0.0/24",
 *     });
 *     var createInstance = new AliCloud.Adb.DBClusterLakeVersion("CreateInstance", new()
 *     {
 *         StorageResource = "0ACU",
 *         ZoneId = "cn-hangzhou-k",
 *         VpcId = VPCID.Id,
 *         VswitchId = VSWITCHID.Id,
 *         DbClusterDescription = name,
 *         ComputeResource = "16ACU",
 *         DbClusterVersion = "5.0",
 *         PaymentType = "PayAsYouGo",
 *         SecurityIps = "127.0.0.1",
 *     });
 *     var defaultLakeAccount = new AliCloud.Adb.LakeAccount("default", new()
 *     {
 *         DbClusterId = createInstance.Id,
 *         AccountType = "Super",
 *         AccountName = "tfnormal",
 *         AccountPassword = "normal@2023",
 *         AccountPrivileges = new[]
 *         {
 *             new AliCloud.Adb.Inputs.LakeAccountAccountPrivilegeArgs
 *             {
 *                 PrivilegeType = "Database",
 *                 PrivilegeObject = new AliCloud.Adb.Inputs.LakeAccountAccountPrivilegePrivilegeObjectArgs
 *                 {
 *                     Database = "MYSQL",
 *                 },
 *                 Privileges = new[]
 *                 {
 *                     "select",
 *                     "update",
 *                 },
 *             },
 *             new AliCloud.Adb.Inputs.LakeAccountAccountPrivilegeArgs
 *             {
 *                 PrivilegeType = "Table",
 *                 PrivilegeObject = new AliCloud.Adb.Inputs.LakeAccountAccountPrivilegePrivilegeObjectArgs
 *                 {
 *                     Database = "INFORMATION_SCHEMA",
 *                     Table = "ENGINES",
 *                 },
 *                 Privileges = new[]
 *                 {
 *                     "update",
 *                 },
 *             },
 *             new AliCloud.Adb.Inputs.LakeAccountAccountPrivilegeArgs
 *             {
 *                 PrivilegeType = "Column",
 *                 PrivilegeObject = new AliCloud.Adb.Inputs.LakeAccountAccountPrivilegePrivilegeObjectArgs
 *                 {
 *                     Table = "COLUMNS",
 *                     Column = "PRIVILEGES",
 *                     Database = "INFORMATION_SCHEMA",
 *                 },
 *                 Privileges = new[]
 *                 {
 *                     "update",
 *                 },
 *             },
 *         },
 *         AccountDescription = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		VPCID, err := vpc.NewNetwork(ctx, "VPCID", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		VSWITCHID, err := vpc.NewSwitch(ctx, "VSWITCHID", &vpc.SwitchArgs{
 * 			VpcId:       VPCID.ID(),
 * 			ZoneId:      pulumi.String("cn-hangzhou-k"),
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		createInstance, err := adb.NewDBClusterLakeVersion(ctx, "CreateInstance", &adb.DBClusterLakeVersionArgs{
 * 			StorageResource:      pulumi.String("0ACU"),
 * 			ZoneId:               pulumi.String("cn-hangzhou-k"),
 * 			VpcId:                VPCID.ID(),
 * 			VswitchId:            VSWITCHID.ID(),
 * 			DbClusterDescription: pulumi.String(name),
 * 			ComputeResource:      pulumi.String("16ACU"),
 * 			DbClusterVersion:     pulumi.String("5.0"),
 * 			PaymentType:          pulumi.String("PayAsYouGo"),
 * 			SecurityIps:          pulumi.String("127.0.0.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = adb.NewLakeAccount(ctx, "default", &adb.LakeAccountArgs{
 * 			DbClusterId:     createInstance.ID(),
 * 			AccountType:     pulumi.String("Super"),
 * 			AccountName:     pulumi.String("tfnormal"),
 * 			AccountPassword: pulumi.String("normal@2023"),
 * 			AccountPrivileges: adb.LakeAccountAccountPrivilegeArray{
 * 				&adb.LakeAccountAccountPrivilegeArgs{
 * 					PrivilegeType: pulumi.String("Database"),
 * 					PrivilegeObject: &adb.LakeAccountAccountPrivilegePrivilegeObjectArgs{
 * 						Database: pulumi.String("MYSQL"),
 * 					},
 * 					Privileges: pulumi.StringArray{
 * 						pulumi.String("select"),
 * 						pulumi.String("update"),
 * 					},
 * 				},
 * 				&adb.LakeAccountAccountPrivilegeArgs{
 * 					PrivilegeType: pulumi.String("Table"),
 * 					PrivilegeObject: &adb.LakeAccountAccountPrivilegePrivilegeObjectArgs{
 * 						Database: pulumi.String("INFORMATION_SCHEMA"),
 * 						Table:    pulumi.String("ENGINES"),
 * 					},
 * 					Privileges: pulumi.StringArray{
 * 						pulumi.String("update"),
 * 					},
 * 				},
 * 				&adb.LakeAccountAccountPrivilegeArgs{
 * 					PrivilegeType: pulumi.String("Column"),
 * 					PrivilegeObject: &adb.LakeAccountAccountPrivilegePrivilegeObjectArgs{
 * 						Table:    pulumi.String("COLUMNS"),
 * 						Column:   pulumi.String("PRIVILEGES"),
 * 						Database: pulumi.String("INFORMATION_SCHEMA"),
 * 					},
 * 					Privileges: pulumi.StringArray{
 * 						pulumi.String("update"),
 * 					},
 * 				},
 * 			},
 * 			AccountDescription: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.adb.DBClusterLakeVersion;
 * import com.pulumi.alicloud.adb.DBClusterLakeVersionArgs;
 * import com.pulumi.alicloud.adb.LakeAccount;
 * import com.pulumi.alicloud.adb.LakeAccountArgs;
 * import com.pulumi.alicloud.adb.inputs.LakeAccountAccountPrivilegeArgs;
 * import com.pulumi.alicloud.adb.inputs.LakeAccountAccountPrivilegePrivilegeObjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var vPCID = new Network("VPCID", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var vSWITCHID = new Switch("VSWITCHID", SwitchArgs.builder()
 *             .vpcId(VPCID.id())
 *             .zoneId("cn-hangzhou-k")
 *             .vswitchName(name)
 *             .cidrBlock("172.16.0.0/24")
 *             .build());
 *         var createInstance = new DBClusterLakeVersion("createInstance", DBClusterLakeVersionArgs.builder()
 *             .storageResource("0ACU")
 *             .zoneId("cn-hangzhou-k")
 *             .vpcId(VPCID.id())
 *             .vswitchId(VSWITCHID.id())
 *             .dbClusterDescription(name)
 *             .computeResource("16ACU")
 *             .dbClusterVersion("5.0")
 *             .paymentType("PayAsYouGo")
 *             .securityIps("127.0.0.1")
 *             .build());
 *         var defaultLakeAccount = new LakeAccount("defaultLakeAccount", LakeAccountArgs.builder()
 *             .dbClusterId(createInstance.id())
 *             .accountType("Super")
 *             .accountName("tfnormal")
 *             .accountPassword("normal@2023")
 *             .accountPrivileges(
 *                 LakeAccountAccountPrivilegeArgs.builder()
 *                     .privilegeType("Database")
 *                     .privilegeObject(LakeAccountAccountPrivilegePrivilegeObjectArgs.builder()
 *                         .database("MYSQL")
 *                         .build())
 *                     .privileges(
 *                         "select",
 *                         "update")
 *                     .build(),
 *                 LakeAccountAccountPrivilegeArgs.builder()
 *                     .privilegeType("Table")
 *                     .privilegeObject(LakeAccountAccountPrivilegePrivilegeObjectArgs.builder()
 *                         .database("INFORMATION_SCHEMA")
 *                         .table("ENGINES")
 *                         .build())
 *                     .privileges("update")
 *                     .build(),
 *                 LakeAccountAccountPrivilegeArgs.builder()
 *                     .privilegeType("Column")
 *                     .privilegeObject(LakeAccountAccountPrivilegePrivilegeObjectArgs.builder()
 *                         .table("COLUMNS")
 *                         .column("PRIVILEGES")
 *                         .database("INFORMATION_SCHEMA")
 *                         .build())
 *                     .privileges("update")
 *                     .build())
 *             .accountDescription(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   VPCID:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/12
 *   VSWITCHID:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${VPCID.id}
 *       zoneId: cn-hangzhou-k
 *       vswitchName: ${name}
 *       cidrBlock: 172.16.0.0/24
 *   createInstance:
 *     type: alicloud:adb:DBClusterLakeVersion
 *     name: CreateInstance
 *     properties:
 *       storageResource: 0ACU
 *       zoneId: cn-hangzhou-k
 *       vpcId: ${VPCID.id}
 *       vswitchId: ${VSWITCHID.id}
 *       dbClusterDescription: ${name}
 *       computeResource: 16ACU
 *       dbClusterVersion: '5.0'
 *       paymentType: PayAsYouGo
 *       securityIps: 127.0.0.1
 *   defaultLakeAccount:
 *     type: alicloud:adb:LakeAccount
 *     name: default
 *     properties:
 *       dbClusterId: ${createInstance.id}
 *       accountType: Super
 *       accountName: tfnormal
 *       accountPassword: normal@2023
 *       accountPrivileges:
 *         - privilegeType: Database
 *           privilegeObject:
 *             database: MYSQL
 *           privileges:
 *             - select
 *             - update
 *         - privilegeType: Table
 *           privilegeObject:
 *             database: INFORMATION_SCHEMA
 *             table: ENGINES
 *           privileges:
 *             - update
 *         - privilegeType: Column
 *           privilegeObject:
 *             table: COLUMNS
 *             column: PRIVILEGES
 *             database: INFORMATION_SCHEMA
 *           privileges:
 *             - update
 *       accountDescription: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ADB Lake Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/lakeAccount:LakeAccount example <db_cluster_id>:<account_name>
 * ```
 * @property accountDescription The description of the account.
 * @property accountName The name of the account.
 * @property accountPassword AccountPassword.
 * @property accountPrivileges List of permissions granted. See `account_privileges` below.
 * @property accountType The type of the account.
 * @property dbClusterId The DBCluster ID.
 */
public data class LakeAccountArgs(
    public val accountDescription: Output<String>? = null,
    public val accountName: Output<String>? = null,
    public val accountPassword: Output<String>? = null,
    public val accountPrivileges: Output<List<LakeAccountAccountPrivilegeArgs>>? = null,
    public val accountType: Output<String>? = null,
    public val dbClusterId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.adb.LakeAccountArgs> {
    override fun toJava(): com.pulumi.alicloud.adb.LakeAccountArgs =
        com.pulumi.alicloud.adb.LakeAccountArgs.builder()
            .accountDescription(accountDescription?.applyValue({ args0 -> args0 }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .accountPassword(accountPassword?.applyValue({ args0 -> args0 }))
            .accountPrivileges(
                accountPrivileges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .accountType(accountType?.applyValue({ args0 -> args0 }))
            .dbClusterId(dbClusterId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LakeAccountArgs].
 */
@PulumiTagMarker
public class LakeAccountArgsBuilder internal constructor() {
    private var accountDescription: Output<String>? = null

    private var accountName: Output<String>? = null

    private var accountPassword: Output<String>? = null

    private var accountPrivileges: Output<List<LakeAccountAccountPrivilegeArgs>>? = null

    private var accountType: Output<String>? = null

    private var dbClusterId: Output<String>? = null

    /**
     * @param value The description of the account.
     */
    @JvmName("nijqpexkvymcwpwu")
    public suspend fun accountDescription(`value`: Output<String>) {
        this.accountDescription = value
    }

    /**
     * @param value The name of the account.
     */
    @JvmName("yjbjpyipdirrodad")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value AccountPassword.
     */
    @JvmName("crrcndberkxsnxfw")
    public suspend fun accountPassword(`value`: Output<String>) {
        this.accountPassword = value
    }

    /**
     * @param value List of permissions granted. See `account_privileges` below.
     */
    @JvmName("etvmkeikctnasqei")
    public suspend fun accountPrivileges(`value`: Output<List<LakeAccountAccountPrivilegeArgs>>) {
        this.accountPrivileges = value
    }

    @JvmName("tvcdvtfbbmecljpw")
    public suspend fun accountPrivileges(vararg values: Output<LakeAccountAccountPrivilegeArgs>) {
        this.accountPrivileges = Output.all(values.asList())
    }

    /**
     * @param values List of permissions granted. See `account_privileges` below.
     */
    @JvmName("nbyghyuufrywrgvd")
    public suspend fun accountPrivileges(values: List<Output<LakeAccountAccountPrivilegeArgs>>) {
        this.accountPrivileges = Output.all(values)
    }

    /**
     * @param value The type of the account.
     */
    @JvmName("rjnbhuhpoewpacwp")
    public suspend fun accountType(`value`: Output<String>) {
        this.accountType = value
    }

    /**
     * @param value The DBCluster ID.
     */
    @JvmName("hydxkljtmqseirhw")
    public suspend fun dbClusterId(`value`: Output<String>) {
        this.dbClusterId = value
    }

    /**
     * @param value The description of the account.
     */
    @JvmName("sdgxdfxvfwinbotk")
    public suspend fun accountDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountDescription = mapped
    }

    /**
     * @param value The name of the account.
     */
    @JvmName("vlmtejofpvdcnrhq")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value AccountPassword.
     */
    @JvmName("nsafkqhewwcutpxk")
    public suspend fun accountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountPassword = mapped
    }

    /**
     * @param value List of permissions granted. See `account_privileges` below.
     */
    @JvmName("ptpwsytiqwlecbqy")
    public suspend fun accountPrivileges(`value`: List<LakeAccountAccountPrivilegeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountPrivileges = mapped
    }

    /**
     * @param argument List of permissions granted. See `account_privileges` below.
     */
    @JvmName("xpwohqnklahugrxa")
    public suspend fun accountPrivileges(argument: List<suspend LakeAccountAccountPrivilegeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LakeAccountAccountPrivilegeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accountPrivileges = mapped
    }

    /**
     * @param argument List of permissions granted. See `account_privileges` below.
     */
    @JvmName("sygnbsscdevlvgwh")
    public suspend fun accountPrivileges(vararg argument: suspend LakeAccountAccountPrivilegeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LakeAccountAccountPrivilegeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accountPrivileges = mapped
    }

    /**
     * @param argument List of permissions granted. See `account_privileges` below.
     */
    @JvmName("rgttaoydwndtunkn")
    public suspend fun accountPrivileges(argument: suspend LakeAccountAccountPrivilegeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LakeAccountAccountPrivilegeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.accountPrivileges = mapped
    }

    /**
     * @param values List of permissions granted. See `account_privileges` below.
     */
    @JvmName("nrlceupyweuvnnao")
    public suspend fun accountPrivileges(vararg values: LakeAccountAccountPrivilegeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountPrivileges = mapped
    }

    /**
     * @param value The type of the account.
     */
    @JvmName("ulpkblnjdiwesgie")
    public suspend fun accountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    /**
     * @param value The DBCluster ID.
     */
    @JvmName("fwobdpeauwtetqcj")
    public suspend fun dbClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterId = mapped
    }

    internal fun build(): LakeAccountArgs = LakeAccountArgs(
        accountDescription = accountDescription,
        accountName = accountName,
        accountPassword = accountPassword,
        accountPrivileges = accountPrivileges,
        accountType = accountType,
        dbClusterId = dbClusterId,
    )
}
