@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.adb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ResourceGroup].
 */
@PulumiTagMarker
public class ResourceGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceGroupArgs = ResourceGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceGroupArgsBuilder.() -> Unit) {
        val builder = ResourceGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceGroup {
        val builtJavaResource = com.pulumi.alicloud.adb.ResourceGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceGroup(builtJavaResource)
    }
}

/**
 * Provides a AnalyticDB for MySQL (ADB) Resource Group resource.
 * For information about AnalyticDB for MySQL (ADB) Resource Group and how to use it, see [What is Resource Group](https://www.alibabacloud.com/help/en/analyticdb-for-mysql/latest/api-doc-adb-2019-03-15-api-doc-createdbresourcegroup).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.adb.getZones({});
 * const defaultGetResourceGroups = alicloud.resourcemanager.getResourceGroups({
 *     status: "OK",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "10.4.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultDBCluster = new alicloud.adb.DBCluster("default", {
 *     computeResource: "48Core192GB",
 *     dbClusterCategory: "MixedStorage",
 *     dbClusterVersion: "3.0",
 *     dbNodeClass: "E32",
 *     dbNodeStorage: 100,
 *     description: name,
 *     elasticIoResource: 1,
 *     maintainTime: "04:00Z-05:00Z",
 *     mode: "flexible",
 *     paymentType: "PayAsYouGo",
 *     resourceGroupId: defaultGetResourceGroups.then(defaultGetResourceGroups => defaultGetResourceGroups.ids?.[0]),
 *     securityIps: [
 *         "10.168.1.12",
 *         "10.168.1.11",
 *     ],
 *     vpcId: defaultNetwork.id,
 *     vswitchId: defaultSwitch.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     tags: {
 *         Created: "TF",
 *         For: "example",
 *     },
 * });
 * const defaultResourceGroup = new alicloud.adb.ResourceGroup("default", {
 *     groupName: "TF_EXAMPLE",
 *     groupType: "batch",
 *     nodeNum: 0,
 *     dbClusterId: defaultDBCluster.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.adb.get_zones()
 * default_get_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="10.4.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_db_cluster = alicloud.adb.DBCluster("default",
 *     compute_resource="48Core192GB",
 *     db_cluster_category="MixedStorage",
 *     db_cluster_version="3.0",
 *     db_node_class="E32",
 *     db_node_storage=100,
 *     description=name,
 *     elastic_io_resource=1,
 *     maintain_time="04:00Z-05:00Z",
 *     mode="flexible",
 *     payment_type="PayAsYouGo",
 *     resource_group_id=default_get_resource_groups.ids[0],
 *     security_ips=[
 *         "10.168.1.12",
 *         "10.168.1.11",
 *     ],
 *     vpc_id=default_network.id,
 *     vswitch_id=default_switch.id,
 *     zone_id=default.zones[0].id,
 *     tags={
 *         "Created": "TF",
 *         "For": "example",
 *     })
 * default_resource_group = alicloud.adb.ResourceGroup("default",
 *     group_name="TF_EXAMPLE",
 *     group_type="batch",
 *     node_num=0,
 *     db_cluster_id=default_db_cluster.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.Adb.GetZones.Invoke();
 *     var defaultGetResourceGroups = AliCloud.ResourceManager.GetResourceGroups.Invoke(new()
 *     {
 *         Status = "OK",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "10.4.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultDBCluster = new AliCloud.Adb.DBCluster("default", new()
 *     {
 *         ComputeResource = "48Core192GB",
 *         DbClusterCategory = "MixedStorage",
 *         DbClusterVersion = "3.0",
 *         DbNodeClass = "E32",
 *         DbNodeStorage = 100,
 *         Description = name,
 *         ElasticIoResource = 1,
 *         MaintainTime = "04:00Z-05:00Z",
 *         Mode = "flexible",
 *         PaymentType = "PayAsYouGo",
 *         ResourceGroupId = defaultGetResourceGroups.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0]),
 *         SecurityIps = new[]
 *         {
 *             "10.168.1.12",
 *             "10.168.1.11",
 *         },
 *         VpcId = defaultNetwork.Id,
 *         VswitchId = defaultSwitch.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         Tags =
 *         {
 *             { "Created", "TF" },
 *             { "For", "example" },
 *         },
 *     });
 *     var defaultResourceGroup = new AliCloud.Adb.ResourceGroup("default", new()
 *     {
 *         GroupName = "TF_EXAMPLE",
 *         GroupType = "batch",
 *         NodeNum = 0,
 *         DbClusterId = defaultDBCluster.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/adb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := adb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetResourceGroups, err := resourcemanager.GetResourceGroups(ctx, &resourcemanager.GetResourceGroupsArgs{
 * 			Status: pulumi.StringRef("OK"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDBCluster, err := adb.NewDBCluster(ctx, "default", &adb.DBClusterArgs{
 * 			ComputeResource:   pulumi.String("48Core192GB"),
 * 			DbClusterCategory: pulumi.String("MixedStorage"),
 * 			DbClusterVersion:  pulumi.String("3.0"),
 * 			DbNodeClass:       pulumi.String("E32"),
 * 			DbNodeStorage:     pulumi.Int(100),
 * 			Description:       pulumi.String(name),
 * 			ElasticIoResource: pulumi.Int(1),
 * 			MaintainTime:      pulumi.String("04:00Z-05:00Z"),
 * 			Mode:              pulumi.String("flexible"),
 * 			PaymentType:       pulumi.String("PayAsYouGo"),
 * 			ResourceGroupId:   pulumi.String(defaultGetResourceGroups.Ids[0]),
 * 			SecurityIps: pulumi.StringArray{
 * 				pulumi.String("10.168.1.12"),
 * 				pulumi.String("10.168.1.11"),
 * 			},
 * 			VpcId:     defaultNetwork.ID(),
 * 			VswitchId: defaultSwitch.ID(),
 * 			ZoneId:    pulumi.String(_default.Zones[0].Id),
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("TF"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = adb.NewResourceGroup(ctx, "default", &adb.ResourceGroupArgs{
 * 			GroupName:   pulumi.String("TF_EXAMPLE"),
 * 			GroupType:   pulumi.String("batch"),
 * 			NodeNum:     pulumi.Int(0),
 * 			DbClusterId: defaultDBCluster.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.adb.AdbFunctions;
 * import com.pulumi.alicloud.adb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.adb.DBCluster;
 * import com.pulumi.alicloud.adb.DBClusterArgs;
 * import com.pulumi.alicloud.adb.ResourceGroup;
 * import com.pulumi.alicloud.adb.ResourceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = AdbFunctions.getZones();
 *         final var defaultGetResourceGroups = ResourcemanagerFunctions.getResourceGroups(GetResourceGroupsArgs.builder()
 *             .status("OK")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("10.4.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultDBCluster = new DBCluster("defaultDBCluster", DBClusterArgs.builder()
 *             .computeResource("48Core192GB")
 *             .dbClusterCategory("MixedStorage")
 *             .dbClusterVersion("3.0")
 *             .dbNodeClass("E32")
 *             .dbNodeStorage(100)
 *             .description(name)
 *             .elasticIoResource(1)
 *             .maintainTime("04:00Z-05:00Z")
 *             .mode("flexible")
 *             .paymentType("PayAsYouGo")
 *             .resourceGroupId(defaultGetResourceGroups.applyValue(getResourceGroupsResult -> getResourceGroupsResult.ids()[0]))
 *             .securityIps(
 *                 "10.168.1.12",
 *                 "10.168.1.11")
 *             .vpcId(defaultNetwork.id())
 *             .vswitchId(defaultSwitch.id())
 *             .zoneId(default_.zones()[0].id())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "TF"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *         var defaultResourceGroup = new ResourceGroup("defaultResourceGroup", ResourceGroupArgs.builder()
 *             .groupName("TF_EXAMPLE")
 *             .groupType("batch")
 *             .nodeNum(0)
 *             .dbClusterId(defaultDBCluster.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 10.4.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultDBCluster:
 *     type: alicloud:adb:DBCluster
 *     name: default
 *     properties:
 *       computeResource: 48Core192GB
 *       dbClusterCategory: MixedStorage
 *       dbClusterVersion: '3.0'
 *       dbNodeClass: E32
 *       dbNodeStorage: 100
 *       description: ${name}
 *       elasticIoResource: 1
 *       maintainTime: 04:00Z-05:00Z
 *       mode: flexible
 *       paymentType: PayAsYouGo
 *       resourceGroupId: ${defaultGetResourceGroups.ids[0]}
 *       securityIps:
 *         - 10.168.1.12
 *         - 10.168.1.11
 *       vpcId: ${defaultNetwork.id}
 *       vswitchId: ${defaultSwitch.id}
 *       zoneId: ${default.zones[0].id}
 *       tags:
 *         Created: TF
 *         For: example
 *   defaultResourceGroup:
 *     type: alicloud:adb:ResourceGroup
 *     name: default
 *     properties:
 *       groupName: TF_EXAMPLE
 *       groupType: batch
 *       nodeNum: 0
 *       dbClusterId: ${defaultDBCluster.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:adb:getZones
 *       Arguments: {}
 *   defaultGetResourceGroups:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments:
 *         status: OK
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Adb Resource Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:adb/resourceGroup:ResourceGroup example <db_cluster_id>:<group_name>
 * ```
 */
public class ResourceGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.adb.ResourceGroup,
) : KotlinCustomResource(javaResource, ResourceGroupMapper) {
    /**
     * The time when the resource group was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The ID of the DBCluster.
     */
    public val dbClusterId: Output<String>
        get() = javaResource.dbClusterId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource group. The `group_name` can be up to 255 characters in length and can contain digits, uppercase letters, hyphens (-), and underscores (_). It must start with a digit or uppercase letter.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * The query execution mode. Default value: `interactive`. Valid values: `interactive`, `batch`.
     */
    public val groupType: Output<String>
        get() = javaResource.groupType().applyValue({ args0 -> args0 })

    /**
     * The number of nodes.
     */
    public val nodeNum: Output<Int>?
        get() = javaResource.nodeNum().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The time when the resource group was updated.
     */
    public val updateTime: Output<String>
        get() = javaResource.updateTime().applyValue({ args0 -> args0 })

    /**
     * The database accounts that are associated with the resource group.
     */
    public val user: Output<String>
        get() = javaResource.user().applyValue({ args0 -> args0 })

    /**
     * The database accounts with which to associate the resource group.
     */
    public val users: Output<List<String>>?
        get() = javaResource.users().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object ResourceGroupMapper : ResourceMapper<ResourceGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.adb.ResourceGroup::class == javaResource::class

    override fun map(javaResource: Resource): ResourceGroup = ResourceGroup(
        javaResource as
            com.pulumi.alicloud.adb.ResourceGroup,
    )
}

/**
 * @see [ResourceGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceGroup].
 */
public suspend fun resourceGroup(
    name: String,
    block: suspend ResourceGroupResourceBuilder.() -> Unit,
): ResourceGroup {
    val builder = ResourceGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceGroup(name: String): ResourceGroup {
    val builder = ResourceGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
